/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public final class SkinSliderUI
extends BasicSliderUI {
    private Skin skin = SkinLookAndFeel.getSkin();

    public SkinSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public Dimension getPreferredHorizontalSize() {
        return this.skin.getSlider().getPreferredSize(this.slider, super.getPreferredHorizontalSize());
    }

    public Dimension getPreferredVerticalSize() {
        return this.skin.getSlider().getPreferredSize(this.slider, super.getPreferredVerticalSize());
    }

    public Dimension getMinimumHorizontalSize() {
        return this.skin.getSlider().getPreferredSize(this.slider, super.getMinimumHorizontalSize());
    }

    public Dimension getMinimumVerticalSize() {
        return this.skin.getSlider().getPreferredSize(this.slider, super.getMinimumVerticalSize());
    }

    public void paintTrack(Graphics graphics) {
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int n = rectangle.height / 2 - 2;
            graphics.translate(rectangle.x, rectangle.y + n);
            this.skin.getSlider().paintTrack(graphics, this.slider, rectangle);
            graphics.translate(-rectangle.x, -(rectangle.y + n));
        } else {
            int n = rectangle.width / 2 - 2;
            graphics.translate(rectangle.x + n, rectangle.y);
            this.skin.getSlider().paintTrack(graphics, this.slider, rectangle);
            graphics.translate(-(rectangle.x + n), -rectangle.y);
        }
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        graphics.translate(rectangle.x, rectangle.y);
        this.skin.getSlider().paintThumb(graphics, this.slider, rectangle);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        this.skin.getSlider().installSkin(jSlider);
    }

    protected Dimension getThumbSize() {
        Dimension dimension = this.skin.getSlider().getThumbSize(this.slider);
        return dimension == null ? super.getThumbSize() : dimension;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SkinSliderUI((JSlider)jComponent);
    }
}

