/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.CustomImageObserver;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.util.AccessUtils;
import com.l2fprod.util.ImageUtils;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class SkinUtils {
    public static final boolean DEBUG = "true".equals(AccessUtils.getProperty("debug.skinlf"));

    public static void setFont(Font font) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            Object k = enumeration.nextElement();
            if (!(k instanceof String) || !(string = (String)k).endsWith(".font") && !string.endsWith(".titleFont") && !string.endsWith(".acceleratorFont") || !(uIDefaults.get(string) instanceof FontUIResource)) continue;
            UIManager.put(string, font);
        }
    }

    public static Font getFont(String string, int n, int n2) {
        return new Font(string, n, n2);
    }

    public static Image loadImage(String string) throws Exception {
        return SkinUtils.loadImage(SkinUtils.toURL(new File(string)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadImage(URL uRL) throws Exception {
        Object object;
        Image image = null;
        byte[] byArray = SkinLookAndFeel.getURLContent(uRL);
        image = Toolkit.getDefaultToolkit().createImage(byArray, 0, byArray.length);
        CustomImageObserver customImageObserver = new CustomImageObserver();
        int n = image.getWidth(customImageObserver);
        int n2 = image.getHeight(customImageObserver);
        Object object2 = object = customImageObserver.getLock();
        synchronized (object2) {
            if (n2 < 1 && n < 1) {
                object.wait();
            }
        }
        return ImageUtils.transparent(image);
    }

    public static URL toURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    public static String decodeColor(String string) {
        if (string.startsWith("#")) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", {}");
        String string2 = "#";
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        if (SkinUtils.is0to1color(string3) && SkinUtils.is0to1color(string4) && SkinUtils.is0to1color(string5)) {
            string3 = (int)(Float.parseFloat(string3) * 255.0f) + "";
            string4 = (int)(Float.parseFloat(string4) * 255.0f) + "";
            string5 = (int)(Float.parseFloat(string5) * 255.0f) + "";
        } else {
            string3 = (int)Float.parseFloat(string3) + "";
            string4 = (int)Float.parseFloat(string4) + "";
            string5 = (int)Float.parseFloat(string5) + "";
        }
        string2 = string2 + SkinUtils.toHexString(Integer.parseInt(string3));
        string2 = string2 + SkinUtils.toHexString(Integer.parseInt(string4));
        string2 = string2 + SkinUtils.toHexString(Integer.parseInt(string5));
        return string2;
    }

    static boolean is0to1color(String string) {
        int n = string.indexOf(".");
        return n != -1 && string.substring(0, n).length() <= 1;
    }

    static String toHexString(int n) {
        if (n == 0) {
            return "00";
        }
        return Integer.toHexString(n).toUpperCase();
    }

    public static Insets stringToInsets(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
        int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
        return new Insets(n3, n, n4, n2);
    }
}

