/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinPersonality;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkImage;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkListCellRenderer;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkStyle;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkTableHeaderRenderer;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import com.l2fprod.util.ImageUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

final class GtkPersonality
extends AbstractSkinPersonality {
    Image background;
    int backgroundPaintMode;
    DefaultButton menu;
    Border menuBarBorder;
    Border toolBarBorder;
    DefaultButton menuitemSelected;
    DefaultButton menuBackground;
    DefaultButton itemSelected;
    DefaultButton itemUnselected;
    DefaultButton comboBox;
    DefaultButton rolloverComboBox;
    DefaultButton disabledComboBox;
    DefaultButton focus;
    Insets comboBoxInsets = new Insets(1, 4, 1, 4);
    static int MINIMAL_SIZE = 50;

    public GtkPersonality(GtkParser gtkParser) throws Exception {
        if (gtkParser.getClass("GtkWindow") != null) {
            GtkStyle gtkStyle = gtkParser.getClass("GtkWindow").getStyle();
            GtkImage gtkImage = gtkStyle.getEngine().findImage(new String[]{"function"}, new String[]{"FLAT_BOX"});
            this.backgroundPaintMode = "TRUE".equals(gtkImage.getProperty("stretch")) ? 1 : 2;
            this.background = gtkImage.getImage(gtkParser.getDirectory());
            if (this.background != null && this.backgroundPaintMode == 2) {
                int n = this.background.getWidth(ImageUtils.producer);
                int n2 = this.background.getHeight(ImageUtils.producer);
                int n3 = Math.max(MINIMAL_SIZE / n2, MINIMAL_SIZE / n);
                if (n3 > 1) {
                    this.background = ImageUtils.buildTile(this.background, n3);
                }
            }
            this.background = ImageUtils.toBufferedImage(this.background);
        }
        this.menuBackground = GtkUtils.newButton(gtkParser, "GtkMenu", new String[]{"function"}, new String[]{"BOX"});
        this.toolBarBorder = GtkUtils.newButton(gtkParser, "GtkToolbar", new String[]{"function"}, new String[]{"BOX"}, false, true, false);
        if (this.toolBarBorder != null) {
            this.toolBarBorder = new BorderUIResource(this.toolBarBorder);
        }
        this.menuBarBorder = GtkUtils.newButton(gtkParser, "GtkMenuBar", new String[]{"function"}, new String[]{"BOX"}, false, true, false);
        if (this.menuBarBorder != null) {
            this.menuBarBorder = new BorderUIResource(this.menuBarBorder);
        }
        this.menuitemSelected = GtkUtils.newButton(gtkParser, "GtkMenuItem", new String[]{"function"}, new String[]{"BOX"});
        this.itemUnselected = GtkUtils.newButton(gtkParser, "GtkListItem", new String[]{"function", "state"}, new String[]{"FLAT_BOX", "INSENSITIVE"});
        this.itemSelected = GtkUtils.newButton(gtkParser, "GtkListItem", new String[]{"function", "state"}, new String[]{"FLAT_BOX", null});
        this.comboBox = GtkUtils.newButton(gtkParser, "GtkOptionMenu", new String[]{"function", "state"}, new String[]{"BOX", null}, false, true, false);
        if (this.comboBox == null) {
            this.comboBox = GtkUtils.newButton(gtkParser, "GtkOptionMenu", new String[]{"function"}, new String[]{"TAB"}, false, true, true);
        }
        this.rolloverComboBox = GtkUtils.newButton(gtkParser, "GtkOptionMenu", new String[]{"function", "state"}, new String[]{"BOX", "PRELIGHT"}, false, true, false);
        this.disabledComboBox = GtkUtils.newButton(gtkParser, "GtkOptionMenu", new String[]{"function", "state"}, new String[]{"BOX", "INSENSITIVE"}, false, true, false);
        this.focus = GtkUtils.newButton(gtkParser, "default", new String[]{"function"}, new String[]{"FOCUS"}, true);
        if (this.focus != null) {
            this.focus.setCenterFill(5);
        }
    }

    public Insets getComboBoxInsets() {
        if (this.comboBox != null) {
            return this.comboBox.getInsets();
        }
        return this.comboBoxInsets;
    }

    public Dimension getComboBoxPreferredSize(JComboBox jComboBox) {
        if (this.comboBox != null) {
            return this.comboBox.getMinimumSize();
        }
        return null;
    }

    public TableCellRenderer getTableHeaderRenderer() {
        if (this.itemSelected != null && this.itemUnselected != null) {
            return new GtkTableHeaderRenderer(this.itemSelected, this.itemUnselected);
        }
        return new DefaultTableCellRenderer();
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent jComponent) {
        if (jComponent instanceof JMenuBar && this.menuBarBorder != null) {
            jComponent.setBorder(this.menuBarBorder);
        }
        if (jComponent instanceof JToolBar && this.toolBarBorder != null) {
            jComponent.setBorder(this.toolBarBorder);
        }
        return true;
    }

    public void uninstallSkin(JComponent jComponent) {
    }

    public boolean paintDialog(Graphics graphics, Component component) {
        if (component instanceof JPopupMenu && this.menuBackground != null) {
            this.menuBackground.paint(graphics, component);
        } else {
            JComponent jComponent = (JComponent)component;
            if (this.background != null) {
                Rectangle rectangle = jComponent.getVisibleRect();
                ImageUtils.paint(jComponent, graphics, this.background, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true, this.backgroundPaintMode);
            }
        }
        return true;
    }

    public boolean paintFocus(Graphics graphics, JComponent jComponent) {
        return false;
    }

    public boolean paintMenu(Graphics graphics, JMenu jMenu) {
        return false;
    }

    public boolean paintMenuItem(Graphics graphics, JMenuItem jMenuItem) {
        if (this.menuitemSelected != null) {
            if (jMenuItem.isArmed() || jMenuItem instanceof JMenu && jMenuItem.getModel().isSelected()) {
                this.menuitemSelected.paint(graphics, jMenuItem);
            }
            return true;
        }
        return false;
    }

    public boolean paintComboBox(Graphics graphics, JComboBox jComboBox, Rectangle rectangle, boolean bl, boolean bl2) {
        if (!jComboBox.isEnabled() && this.disabledComboBox != null) {
            this.disabledComboBox.paint(graphics, jComboBox);
            return true;
        }
        if (bl2 && this.rolloverComboBox != null) {
            this.rolloverComboBox.paint(graphics, jComboBox);
            return true;
        }
        if (this.comboBox != null) {
            this.comboBox.paint(graphics, jComboBox);
            return true;
        }
        return false;
    }

    public TableCellRenderer createTableHeaderRenderer() {
        return this.getTableHeaderRenderer();
    }

    public ListCellRenderer createListCellRenderer() {
        if (this.itemSelected != null && this.itemUnselected != null) {
            return new GtkListCellRenderer(this.itemSelected, this.itemUnselected);
        }
        return new DefaultListCellRenderer();
    }
}

