/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinScrollbar;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinScrollbar;
import com.l2fprod.gui.plaf.skin.impl.gtk.ArrowButton;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingConstants;

final class GtkScrollbar
extends AbstractSkinScrollbar
implements SkinScrollbar,
SwingConstants {
    DefaultButton h_track;
    DefaultButton v_track;
    DefaultButton h_thumb;
    DefaultButton v_thumb;
    DefaultButton h_handle;
    DefaultButton v_handle;
    ArrowButton up;
    ArrowButton down;
    ArrowButton left;
    ArrowButton right;
    Dimension minimumThumbSize;

    public GtkScrollbar(GtkParser gtkParser) throws Exception {
        this.h_thumb = GtkUtils.newButton(gtkParser, "GtkScrollbar", new String[]{"function", "detail", "orientation", "state"}, new String[]{"BOX", "slider", "HORIZONTAL", "NORMAL"}, false, true, true);
        this.v_thumb = GtkUtils.newButton(gtkParser, "GtkScrollbar", new String[]{"function", "detail", "orientation"}, new String[]{"BOX", "slider", "VERTICAL"}, false, true, true);
        this.h_track = GtkUtils.newButton(gtkParser, "GtkScrollbar", new String[]{"function", "detail", "orientation"}, new String[]{"BOX", "trough", "HORIZONTAL"}, false, true, true);
        this.v_track = GtkUtils.newButton(gtkParser, "GtkScrollbar", new String[]{"function", "detail", "orientation"}, new String[]{"BOX", "trough", "VERTICAL"}, false, true, true);
        this.h_handle = GtkUtils.newButton(gtkParser, "default", new String[]{"function", "orientation"}, new String[]{"HANDLE", "HORIZONTAL"}, true, true);
        if (this.h_handle != null) {
            this.h_handle.setCenterFill(1);
        }
        this.v_handle = GtkUtils.newButton(gtkParser, "default", new String[]{"function", "orientation"}, new String[]{"HANDLE", "VERTICAL"}, true, true);
        if (this.v_handle != null) {
            this.v_handle.setCenterFill(1);
        }
        this.up = new ArrowButton(gtkParser, "UP");
        this.down = new ArrowButton(gtkParser, "DOWN");
        this.left = new ArrowButton(gtkParser, "LEFT");
        this.right = new ArrowButton(gtkParser, "RIGHT");
        this.minimumThumbSize = new Dimension(this.h_thumb.getInsets().left + (this.h_handle != null ? this.h_handle.getWidth() : 0) + this.h_thumb.getInsets().right, this.v_thumb.getInsets().top + (this.v_handle != null ? this.v_handle.getHeight() : 0) + this.v_thumb.getInsets().bottom);
    }

    public Dimension getPreferredSize(JScrollBar jScrollBar) {
        return jScrollBar.getOrientation() == 1 ? new Dimension(Math.max(10, Math.min(this.up.getWidth(), this.v_thumb.getWidth())), 48) : new Dimension(48, Math.max(10, Math.min(this.left.getHeight(), this.h_thumb.getHeight())));
    }

    public Dimension getMinimumThumbSize() {
        return this.minimumThumbSize;
    }

    public Dimension getArrowPreferredSize(int n) {
        switch (n) {
            case 1: {
                return this.up.getPreferredSize();
            }
            case 5: {
                return this.down.getPreferredSize();
            }
            case 7: {
                return this.left.getPreferredSize();
            }
            case 3: {
                return this.right.getPreferredSize();
            }
        }
        throw new Error("Invalid direction " + n);
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent jComponent) {
        return true;
    }

    public boolean paintArrow(Graphics graphics, AbstractButton abstractButton, int n) {
        switch (n) {
            case 1: {
                this.up.paint(graphics, abstractButton);
                break;
            }
            case 5: {
                this.down.paint(graphics, abstractButton);
                break;
            }
            case 7: {
                this.left.paint(graphics, abstractButton);
                break;
            }
            case 3: {
                this.right.paint(graphics, abstractButton);
            }
        }
        return true;
    }

    public boolean paintTrack(Graphics graphics, JScrollBar jScrollBar, Rectangle rectangle) {
        if (this.h_track != null) {
            if (jScrollBar.getOrientation() == 0) {
                this.h_track.paint(graphics, 0, 0, rectangle.width, rectangle.height, jScrollBar);
            } else {
                this.v_track.paint(graphics, 0, 0, rectangle.width, rectangle.height, jScrollBar);
            }
            return true;
        }
        return false;
    }

    public boolean paintThumb(Graphics graphics, JScrollBar jScrollBar, Rectangle rectangle) {
        if (this.h_thumb != null) {
            if (jScrollBar.getOrientation() == 0) {
                this.h_thumb.paint(graphics, 0, 0, rectangle.width, rectangle.height, jScrollBar);
                if (this.h_handle != null && this.h_handle.getWidth() < rectangle.width) {
                    this.h_handle.paint(graphics, Math.max(0, (rectangle.width - this.h_handle.getWidth()) / 2), (rectangle.height - this.h_handle.getHeight()) / 2, Math.min(rectangle.width, this.h_handle.getWidth()), this.h_handle.getHeight(), jScrollBar);
                }
            } else {
                this.v_thumb.paint(graphics, 0, 0, rectangle.width, rectangle.height, jScrollBar);
                if (this.v_handle != null && this.v_handle.getHeight() < rectangle.height) {
                    this.v_handle.paint(graphics, (rectangle.width - this.v_handle.getWidth()) / 2, Math.max(0, (rectangle.height - this.v_handle.getHeight()) / 2), this.v_handle.getWidth(), Math.min(rectangle.height, this.v_handle.getHeight()), jScrollBar);
                }
            }
            return true;
        }
        return false;
    }
}

