/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.border.ActiveBorder;
import com.l2fprod.gui.plaf.skin.SkinButton;
import com.l2fprod.gui.plaf.skin.SkinFrame;
import com.l2fprod.gui.plaf.skin.SkinPersonality;
import com.l2fprod.gui.plaf.skin.SkinProgress;
import com.l2fprod.gui.plaf.skin.SkinScrollbar;
import com.l2fprod.gui.plaf.skin.SkinSlider;
import com.l2fprod.gui.plaf.skin.SkinSplitPane;
import com.l2fprod.gui.plaf.skin.SkinTab;
import com.l2fprod.gui.plaf.skin.SkinUtils;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkin;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkButton;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkPersonality;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkProgress;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkScrollbar;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkSeparator;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkSkinNotFoundException;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkSlider;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkSplitPane;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkTab;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

public final class GtkSkin
extends AbstractSkin {
    String[] colors;
    static String[] swingToGtk = new String[]{"desktop", "", "activeCaption", "", "activeCaptionText", "", "activeCaptionBorder", "", "inactiveCaption", "", "inactiveCaptionText", "", "inactiveCaptionBorder", "", "window", "window.bg[NORMAL]", "windowBorder", "window.bg[NORMAL]", "windowText", "window.fg[NORMAL]", "menu", "menu.bg[NORMAL]", "menuPressedItemB", "bg[ACTIVE]", "menuPressedItemF", "fg[ACTIVE]", "menuText", "fg[NORMAL]", "text", "bg[NORMAL]", "textText", "fg[NORMAL]", "textHighlight", "bg[SELECTED]", "textHighlightText", "fg[SELECTED]", "textInactiveText", "fg[INSENSITIVE]", "control", "button.bg[NORMAL]", "controlText", "button.fg[NORMAL]", "controlHighlight", "", "controlLtHighlight", "", "controlShadow", "", "controlDkShadow", "", "scrollbar", "", "info", "", "infoText", ""};
    Border textBorder;
    Border disabledTextBorder;

    public GtkSkin(String string) throws Exception {
        this(SkinUtils.toURL(new File(string)));
    }

    public GtkSkin(URL uRL) throws Exception {
        GtkParser gtkParser = new GtkParser(uRL);
        gtkParser.buildStructure();
        this.init(gtkParser);
    }

    public GtkSkin(URL uRL, InputStream inputStream) throws Exception {
        GtkParser gtkParser = new GtkParser(inputStream);
        gtkParser.setDirectory(uRL);
        gtkParser.buildStructure();
        this.init(gtkParser);
    }

    public GtkSkin(GtkParser gtkParser) throws Exception {
        this.init(gtkParser);
    }

    public SkinPersonality getPersonality() {
        return this.personality;
    }

    public SkinButton getButton() {
        return this.button;
    }

    public SkinFrame getFrame() {
        return null;
    }

    public SkinTab getTab() {
        return this.tab;
    }

    public SkinProgress getProgress() {
        return this.progress;
    }

    public String[] getColors() {
        return this.colors;
    }

    public SkinScrollbar getScrollbar() {
        return this.scrollbar;
    }

    public SkinSplitPane getSplitPane() {
        return this.splitpane;
    }

    public SkinSlider getSlider() {
        return this.slider;
    }

    private void init(GtkParser gtkParser) throws Exception {
        this.personality = new GtkPersonality(gtkParser);
        this.button = new GtkButton(gtkParser);
        this.tab = new GtkTab(gtkParser);
        this.progress = new GtkProgress(gtkParser);
        this.scrollbar = new GtkScrollbar(gtkParser);
        this.splitpane = new GtkSplitPane(gtkParser);
        this.slider = new GtkSlider(gtkParser);
        this.separator = new GtkSeparator(gtkParser);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < swingToGtk.length; i += 2) {
            String string = swingToGtk[i + 1];
            String string2 = null;
            if ("".equals(string)) continue;
            int n = string.indexOf(".");
            if (n != -1) {
                if (gtkParser.getStyle(string.substring(0, n)) != null) {
                    string2 = (String)gtkParser.getStyle(string.substring(0, n)).getProperty(string.substring(n + 1));
                }
                if (string2 == null) {
                    string = string.substring(n + 1);
                }
            }
            if (string2 == null) {
                string2 = (String)gtkParser.getStyle("default").getProperty(string);
            }
            if (string2 == null) continue;
            vector.addElement(swingToGtk[i]);
            vector.addElement(SkinUtils.decodeColor(string2));
        }
        this.colors = new String[vector.size()];
        vector.copyInto(this.colors);
        this.disabledTextBorder = GtkUtils.newButton(gtkParser, "default", new String[]{"function", "state", "detail"}, new String[]{"FLAT_BOX", "INSENSITIVE", "text"}, true);
        this.textBorder = GtkUtils.newButton(gtkParser, "default", new String[]{"function", "state", "detail"}, new String[]{"FLAT_BOX", null, "text"}, true);
        if (this.disabledTextBorder != null && this.textBorder != null) {
            this.textBorder = new BorderUIResource(new ActiveBorder(this.textBorder, this.disabledTextBorder));
        }
    }

    public void initComponentDefaults(UIDefaults uIDefaults) {
        if (Boolean.TRUE.equals(UIManager.get("EnableBorders")) && this.textBorder != null) {
            uIDefaults.put("TextField.border", this.textBorder);
            uIDefaults.put("PasswordField.border", this.textBorder);
            uIDefaults.put("ScrollPane.border", this.textBorder);
            uIDefaults.put("Spinner.border", this.textBorder);
        }
    }

    public static String getDefaultSkinLocation() throws GtkSkinNotFoundException {
        String string = System.getProperty("user.home");
        if (string == null) {
            return null;
        }
        String string2 = string + File.separator + ".gtkrc";
        File file = new File(string2);
        if (!file.exists()) {
            throw new GtkSkinNotFoundException();
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                String string4;
                File file2;
                if (string3.indexOf("gtkrc") != -1 && (file2 = new File(string4 = string3.substring(9, string3.length() - 1))).exists()) {
                    return file2.getCanonicalPath();
                }
                string3 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            throw new GtkSkinNotFoundException();
        }
        throw new GtkSkinNotFoundException();
    }
}

