/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class HSBFilter
extends RGBImageFilter {
    private float[] hsbvals = new float[3];
    float fgHue;
    float fgSaturation;
    float fgBrightness;

    public HSBFilter(Color color) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.hsbvals);
        this.fgHue = this.hsbvals[0];
        this.fgSaturation = this.hsbvals[1];
        this.fgBrightness = this.hsbvals[2];
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 >> 24 & 0xFF;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        Color.RGBtoHSB(n5, n6, n7, this.hsbvals);
        float f = this.fgHue;
        float f2 = this.hsbvals[1] * this.fgSaturation;
        float f3 = this.hsbvals[2] * (this.hsbvals[1] * this.fgBrightness + (1.0f - this.hsbvals[1]));
        n3 = Color.HSBtoRGB(f, f2, f3);
        return n3 & 0xFFFFFF | n4 << 24;
    }
}

