/*
 * Decompiled with CFR 0.152.
 */
package com.sciapp.demo;

import com.sciapp.common.gui.GUIFader;
import com.sciapp.common.gui.SkinManager;
import com.sciapp.common.gui.SkinPanel;
import com.sciapp.demo.JTableDemoPanel;
import com.sciapp.demo.TableDemoPanel;
import com.sciapp.demo.TreeTableDemoPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class Demo
extends JApplet {
    public static final String VERSION = "2.3";

    public String getAppletInfo() {
        return "Table Library Demo\n\nApplet showing the features of the Table Library API";
    }

    public void init() {
        super.init();
        Container container = this.getContentPane();
        Demo.init(container);
        SkinManager.instance().setMainComponent(this);
        this.resize(700, 500);
    }

    public static void init(Container container) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        TableDemoPanel tableDemoPanel = new TableDemoPanel();
        TreeTableDemoPanel treeTableDemoPanel = new TreeTableDemoPanel();
        JTableDemoPanel jTableDemoPanel = new JTableDemoPanel();
        jTabbedPane.addTab("Table", tableDemoPanel);
        jTabbedPane.addTab("TreeTable", treeTableDemoPanel);
        jTabbedPane.addTab("JTable", jTableDemoPanel);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(" Visualizations "));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        SkinPanel skinPanel = new SkinPanel();
        skinPanel.add((Component)new JLabel("Look & Feel"), 0);
        skinPanel.setBorder(null);
        final JCheckBox jCheckBox = new JCheckBox("Use faders", false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = jCheckBox.isSelected();
                GUIFader.setEnabled(bl);
            }
        });
        jPanel.add(skinPanel);
        jPanel.add(jCheckBox);
        container.add((Component)jPanel, "North");
        container.add((Component)jTabbedPane, "Center");
        GUIFader.setEnabled(jCheckBox.isSelected());
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Table Libary v2.3 Demo");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        try {
            Container container = jFrame.getContentPane();
            Demo.init(container);
            ((Component)jFrame).setSize(700, 500);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = jFrame.getSize();
            ((Component)jFrame).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            SkinManager.instance().setMainComponent(jFrame);
            ((Component)jFrame).setVisible(true);
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
    }
}

