package com.sciapp.demo;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

import com.sciapp.table.*;
import com.sciapp.filter.FilterTablePanel;
import com.sciapp.renderers.*;
import com.sciapp.filter.*;
/**
 *
 */
public class JTableDemoPanel extends AbstractDemoPanel {
	public TableReorder tr;
/**
 *
 */
public JTableDemoPanel() {
	super();
}
/**
 *
 */
public JTableDemoPanel(ListTableModel dataModel, DataFeeder dataFeeder) {
	super(dataModel, dataFeeder);
}
/**
 *
 */
protected void action(ActionEvent e) {
	Object source = e.getSource();

	if (source == showLastColumn || source == reorderFirstColumn) {
		JOptionPane.showMessageDialog(this, "This feature is not available for a JTable.");
	}
	else super.action(e);
}
/**
 *
 */
protected JTable createTable() {
	//create a tablereorder that handles row selections
	final TableReorder tr = new TableReorder(new JTable());

	JTable table = new JTable() {
		public void tableChanged(javax.swing.event.TableModelEvent e) {
			super.tableChanged(e);

			if (tr != null) tr.reselectTableRows();
		}
	};

	this.tr = tr;

	//associate the TableReorder instance with this table
	tr.setTable(table);

	//set the table's header to an instance of FilterTableHeader
	table.setTableHeader(new FilterTableHeader(table.getColumnModel()));

	//create editors and renderers and set alternate color in renderers
	com.sciapp.editors.DateEditor de = new com.sciapp.editors.DateEditor();
	table.setDefaultEditor(java.util.Date.class, de);

	Color c = new Color(194, 194, 194);

	BooleanRenderer cbr = new BooleanRenderer();
	table.setDefaultRenderer(Boolean.class, cbr);
	cbr.setOddColor(c);

	DefaultRenderer dr = new DefaultRenderer();
	table.setDefaultRenderer(Object.class, dr);
	dr.setOddColor(c);

	NumberRenderer nr = new NumberRenderer();
	table.setDefaultRenderer(Number.class, nr);
	table.setDefaultRenderer(Float.class, nr);
	nr.setOddColor(c);

	DateRenderer drr = new DateRenderer();
	table.setDefaultRenderer(java.util.Date.class, drr);
	drr.setOddColor(c);

	return table;
}
/**
 *
 */
protected com.sciapp.table.ListTableModel createTableModel(ListTableModel model) {
	return model;
}
/**
 *
 */
public JPanel createTablePanel(ListTableModel dataModel) {
	JPanel p = super.createTablePanel(dataModel);

	sortTableModel.addReorderListener(tr);

	//create a TableAssistant instance for use with this table.
	TableAssistant tableAssistant = new TableAssistant(table);
	tableAssistant.register(table.getColumnModel());

	//the following two lines are needed for Java 1.2.
	sortTableModel.setHeader(table.getTableHeader());
	tableAssistant.setHeader(table.getTableHeader());

	return p;
}
}
