#ifndef FORMAT_H
#define FORMAT_H

#include <string>

namespace Libexcel {

	class FormatImpl;

	// Class for generating Excel formats

	class Format 
	{	
	public:

		enum Underline {UNDERLINE_NONE,
						UNDERLINE_UNDERLINE, 
						UNDERLINE_DOUBLE};

		enum Border    {BORDER_NONE,
						BORDER_THIN,
						BORDER_THICK,
						BORDER_DASH,
						BORDER_DOT,
						BORDER_SUPERTHICK,
						BORDER_DOUBLE};

		enum Bold	   {BOLD_LIGHT                        = 0x64,
						BOLD_NORMAL                       = 0x190,
						BOLD_BOLD                         = 0x2BC,
						BOLD_STRONG                       = 0x3E8};

		enum AlignH	   {ALIGN_NONE, 
						ALIGN_LEFT,
						ALIGN_CENTER, 
						ALIGN_RIGHT,
						ALIGN_FILL, 
						ALIGN_JUSTIFY,
						ALIGN_MERGE, 
						ALIGN_EQUAL_SPACE};

		enum AlignV	   {ALIGN_TOP, 
						ALIGN_VCENTER,
						ALIGN_BOTTOM,
						ALIGN_VJUSTIFY, 
						ALIGN_VEQUAL_SPACE};

		enum Color	   {COLOR_BLACK                       = 8,
						COLOR_WHITE                       = 9,			
						COLOR_RED                         = 10,					
						COLOR_BRIGHTGREEN                 = 11,
						COLOR_BLUE                        = 12,
						COLOR_YELLOW                      = 13,
						COLOR_PINK                        = 14,
						COLOR_TURQUOISE                   = 15,
						COLOR_DARKRED                     = 16,
						COLOR_GREEN                       = 17,
						COLOR_DARKBLUE                    = 18,
						COLOR_DARKYELLOW                  = 19,
						COLOR_VIOLET                      = 20,
						COLOR_TEAL                        = 21,
						COLOR_GRAY25                      = 22,
						COLOR_GRAY50                      = 23,
						COLOR_PERIWINKLE_CF               = 24,
						COLOR_PLUM_CF                     = 25,
						COLOR_IVORY_CF                    = 26,
						COLOR_LIGHTTURQUOISE_CF           = 27,
						COLOR_DARKPURPLE_CF               = 28,
						COLOR_CORAL_CF                    = 29,
						COLOR_OCEANBLUE_CF                = 30,
						COLOR_ICEBLUE_CF                  = 31,
						COLOR_DARKBLUE_CL                 = 32,
						COLOR_PINK_CL                     = 33,
						COLOR_YELLOW_CL                   = 34,
						COLOR_TURQUOISE_CL                = 35,
						COLOR_VIOLET_CL                   = 36,
						COLOR_DARKRED_CL                  = 37,
						COLOR_TEAL_CL                     = 38,
						COLOR_BLUE_CL                     = 39,
						COLOR_SKYBLUE                     = 40,
						COLOR_LIGHTTURQUOISE              = 41,
						COLOR_LIGHTGREEN                  = 42,
						COLOR_LIGHTYELLOW                 = 43,
						COLOR_PALEBLUE                    = 44,
						COLOR_ROSE                        = 45,
						COLOR_LAVENDER                    = 46,
						COLOR_TAN                         = 47,
						COLOR_LIGHTBLUE                   = 48,
						COLOR_AQUA                        = 49,
						COLOR_LIME                        = 50,
						COLOR_GOLD                        = 51,
						COLOR_LIGHTORANGE                 = 52,
						COLOR_ORANGE                      = 53,
						COLOR_BLUEGRAY                    = 54,
						COLOR_GRAY40                      = 55,
						COLOR_DARKTEAL                    = 56,
						COLOR_SEAGREEN                    = 57,
						COLOR_DARKGREEN                   = 58,
						COLOR_OLIVEGREEN                  = 59,
						COLOR_BROWN                       = 60,
						COLOR_PLUM                        = 61,
						COLOR_INDIGO                      = 62,
						COLOR_GRAY80                      = 63};

		enum Script	   {SCRIPT_NONE,
						SCRIPT_SUPERSCRIPT,
						SCRIPT_SUBSCRIPT};

		enum Pattern   {PATTERN_NOBACKGROUND              = 0, 
						PATTERN_SOLID                     = 1, 
						PATTERN_GRAY75                    = 3,
						PATTERN_GRAY50                    = 2,
						PATTERN_GRAY25                    = 4,
						PATTERN_GRAY12P5                  = 17,
						PATTERN_GRAY6P25                  = 18,					  
						PATTERN_HORSTRIPE                 = 5, 
						PATTERN_VERSTIPE                  = 6,
						PATTERN_REVDIAGSTRIPE             = 7,
						PATTERN_DIAGSTRIPE                = 8,
						PATTERN_DIAGCROSSHATCH            = 9, 
						PATTERN_THICKDIAGCROSSHATCH       = 10,
						PATTERN_THINHORSTRIPE             = 11,
						PATTERN_THINVERSTRIPE             = 12,
						PATTERN_THINREVDIAGSTRIPE         = 13,
						PATTERN_THINDIAGSTRIPE            = 14,
						PATTERN_THINHORCROSSHATCH         = 15,
						PATTERN_THINDIAGCROSSHATCH        = 16};

		enum NumFormat {NUMFORMAT_GENERAL                 = 0,        // General
						NUMFORMAT_NUMBER                  = 1,        // 0
						NUMFORMAT_NUMBER_D2               = 2,        // 0.00
						NUMFORMAT_NUMBER_SEP              = 3,        // #,##0
						NUMFORMAT_NUMBER_SEP_D2           = 4,        // #,##0.00
						NUMFORMAT_CURRENCY_NEGBRA         = 5,        // ($#,##0_);($#,##0)
						NUMFORMAT_CURRENCY_NEGBRARED      = 6,        // ($#,##0_);[Red]($#,##0)
						NUMFORMAT_CURRENCY_D2_NEGBRA      = 7,        // ($#,##0.00_);($#,##0.00)
						NUMFORMAT_CURRENCY_D2_NEGBRARED   = 8,        // ($#,##0.00_);[Red]($#,##0.00)
						NUMFORMAT_PERCENT                 = 9,        // 0%
						NUMFORMAT_PERCENT_D2              = 10,       // 0.00%
						NUMFORMAT_SCIENTIFIC_D2           = 11,       // 0.00E+00
						NUMFORMAT_FRACTION_ONEDIG         = 12,       // # ?/?
						NUMFORMAT_FRACTION_TWODIG         = 13,       // # ??/??
						NUMFORMAT_DATE_MDY                = 14,       // m/d/yy
						NUMFORMAT_CUSTOM_D_MON_YY         = 15,       // d-mmm-yy
						NUMFORMAT_CUSTOM_D_MON            = 16,       // d-mmm
						NUMFORMAT_CUSTOM_MON_YY           = 17,       // mmm-yy
						NUMFORMAT_CUSTOM_HMM_AM           = 18,       // h:mm AM/PM
						NUMFORMAT_CUSTOM_HMMSS_AM         = 19,       // h:mm:ss AM/PM
						NUMFORMAT_CUSTOM_HMM              = 20,       // h:mm
						NUMFORMAT_CUSTOM_HMMSS            = 21,       // h:mm:ss
						NUMFORMAT_CUSTOM_MDYYYY_HMM       = 22,       // m/d/yy h:mm
						NUMFORMAT_NUMBER_SEP_NEGBRA       = 37,       // (#,##0_);(#,##0)
						NUMFORMAT_NUMBER_SEP_NEGBRARED    = 38,       // (#,##0_);[Red](#,##0)
						NUMFORMAT_NUMBER_D2_SEP_NEGBRA    = 39,       // (#,##0.00_);(#,##0.00)
						NUMFORMAT_NUMBER_D2_SEP_NEGBRARED = 40,       // (#,##0.00_);[Red](#,##0.00)
						NUMFORMAT_ACCOUNT                 = 41,       // _(* #,##0_);_(* (#,##0);_(* "-"_);_(@_)
						NUMFORMAT_ACCOUNT_CUR             = 42,       // _($* #,##0_);_($* (#,##0);_($* "-"_);_(@_)
						NUMFORMAT_ACCOUNT_D2              = 43,       // _(* #,##0.00_);_(* (#,##0.00);_(* "-"??_);_(@_)
						NUMFORMAT_ACCOUNT_D2_CUR          = 44,       // _($* #,##0.00_);_($* (#,##0.00);_($* "-"??_);_(@_)
						NUMFORMAT_CUSTOM_MMSS             = 45,       // mm:ss
						NUMFORMAT_CUSTOM_H0MMSS           = 46,       // [h]:mm:ss
						NUMFORMAT_CUSTOM_MMSS0            = 47,       // mm:ss.0
						NUMFORMAT_CUSTOM_000P0E_PLUS0     = 48,       // ##0.0E+0
						NUMFORMAT_TEXT                    = 49};      // @

    	
		// Alignments

		void setAlign(AlignH hor, AlignV ver);                        // sets cell horizontal and vertical alignment
		void setAlignH(AlignH hor);                                   // sets cell horizontal alignment
		void setAlignV(AlignV ver);                                   // sets cell vertical alignment
		void setTextWrap(bool textwrap = true);                       // sets text wrapping

		// Format
		
		void setNumFormat(NumFormat num_format);                      // sets the numeric format (date, time, currency...)

		// Font

		void setSize(int size);                                       // sets font size
		void setFont(const std::string& font);                        // sets font name
		void setBold(Bold weight = BOLD_BOLD);                        // sets bold font style
		void setItalic(bool italic = true);                           // sets italic font style
		void setUnderline(Underline underline = UNDERLINE_UNDERLINE); // sets underline font style
		void setStrikeOut(bool strikeout = true);                     // sets strikeout font style
		void setScript(Script script);                                // sets the script type of the text
		void setTextRotation(int angle);                              // sets the orientation of the text (from -90 to 90, 0 for stacking top-to-bottom)

		// Colors & Patterns

		void setTextColor(int color);                                 // sets the cell's text color
		void setBgColor(int color);	                                  // sets the cell's background color	
		void setPattern(Pattern pattern = PATTERN_SOLID);             // sets the cell's fill pattern

		// Borders

		void setBorder(Border style);                                 // sets the cell's border style
		void setLeft(Border style);                                   // sets the cell's left border style
		void setTop(Border style);	                                  // sets the cell's top border style
		void setRight(Border style);                                  // sets the cell's right border style
		void setBottom(Border style);                                 // sets the cell's bottom border style

		void setBorderColor(int color);                               // sets the cell's border color   
		void setLeftColor(int color);                                 // sets the cell's left border color
		void setTopColor(int color);                                  // sets the cell's top border color 
		void setRightColor(int color);                                // sets the cell's right border color
		void setBottomColor(int color);                               // sets the cell's bottom border color
		
		// Utils
        
		void setLocked(bool locked = true);                           // locks a cell
		
		FormatImpl* getImpl() { return m_impl; }                      // for internal use only

	private:		
		friend class WorkbookImpl;
		Format(int biff_version, int index);
		~Format();
		FormatImpl* m_impl;	
	};
}

#endif
