'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'//Copyright 1999-2005, Hitek Software LLC
'//http://www.sharewarejustice.com
'//This source code is subject to change without any prior notice.  
'//The source code is subject to a non-disclosure agreement. 
'//No part of this source code may be reproduced, transmitted to other Shareware Developers or any other person, without the written permission of Hitek Software LLC.
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Module Tracker
    Dim args As System.Collections.ObjectModel.ReadOnlyCollection(Of String) = My.Application.CommandLineArgs

    Sub Main()
        Try
            Dim authorid As String = "testid"
            Dim authorpwd As String = "testpwd"
            Dim mode As String = "install"
            Dim program As String = "testPgm"
            Dim version As String = "1.0"
            Dim key As String = "111-222-333"
            Dim key2 As String = "aaa-bbb-ccc"

            'collect data to be posted for GET method
            'The GET method is used all 3 modes: install, register, and usage 		
            Dim cd As CollectData = New CollectData()
            Dim parString As String = cd.GetParameterString(cd.GET_, authorid, authorpwd, mode, program, version, key, key2)
            Console.WriteLine("GET Url String = " + parString)

            'post data using GET method
            Dim pd As PostData = New PostData()
            pd.GetMethod(parString)
            Console.WriteLine("Status = " + pd.status)
            Console.WriteLine("Data Line = " + pd.dataLine)

            'POST method is used only for register or usage mode 		
            If (args.Item(2) = "register" Or args.Item(2) = "usage") Then
                'Collect data to be posted for POST method
                cd = New CollectData()
                parString = cd.GetParameterString(cd.POST, authorid, authorpwd, mode, program, version, key, key2)
                Console.WriteLine("POST Url String = " + parString)

                'post data using POST method
                pd = New PostData()
                pd.PostMethod(parString)
                Console.WriteLine("Status = " + pd.status)
                Console.WriteLine("Data Line = " + pd.dataLine)
            End If

        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
        End Try

    End Sub

End Module
