<?php
//============================================================+
// File name   : cp_config.php                                 
// Begin       : 2001-09-02                                    
// Last Update : 2003-09-23                                    
//                                                             
// Description : ADMIN Base cofiguration file                  
//                                                             
//                                                             
// Author: Nicola Asuni                                        
//                                                             
// (c) Copyright:                                              
//               Tecnick.com S.r.l.                            
//               Via Ugo Foscolo n.19                          
//               09045 Quartu Sant'Elena (CA)                  
//               ITALY                                         
//               www.tecnick.com                               
//               info@tecnick.com                              
//============================================================+

// -- INCLUDE files -- 
require_once('../../shared/config/cp_extension.inc');
require_once('../config/cp_auth.'.CP_EXT);
require_once('../../shared/config/cp_config.'.CP_EXT);

// -- Language -- 
define ("K_DEFAULT_LANGUAGE", "eng"); //default administration panel language

// -- Options / COSTANTS --
define ("K_MAX_EXECUTION_TIME", 2*K_SECONDS_IN_HOUR); // [seconds] Limits the maximum execution time for a script
define ("K_MAX_MEMORY_LIMIT", "128M"); // max memory limit

define ("K_MAX_ROWS_PER_PAGE", 20); //max number of rows to display in tables
define ("K_MAX_ICONS_IN_ROW", 7); // number of icons in the same row (for main page)
define ("K_OVERLIB_IMAGE", K_PATH_IMAGES."overlib/description.gif");
define ("K_MAX_UPLOAD_SIZE", 10000000); //max size to be uploaded in bytes
define ("K_USE_ERROR_LOG", TRUE); //enable error log (../log/cp_errors.log)
define ("K_MIN_CHECK_LINK_TIMES", 3); //number of times that link could be unavailable before deleting
define ("K_USE_GRAPHIC_BUTTONS", FALSE); // if true graphics buttons instead normal form buttons
define ("K_GRAPHIC_BUTTON_STYLE", "AIOCP"); // name of the graphic button style
define ("K_DISPLAY_QUICK_HELP", TRUE); // if TRUE display form fields description using overlib

define ("K_LANG_ON_MENU", FALSE); // if TRUE display language selector on aiocp menu

define ("K_USE_FRAMES", TRUE); // DO NOT CHANGE
define ("K_MAIN_FRAME_NAME", "CPMAIN"); //DO NOT CHANGE
define ("K_CHECK_JAVASCRIPT", TRUE); //DO NOT CHANGE
define ("K_REDIRECT_JAVASCRIPT_ERROR", "../code/cp_javascript_error.".CP_EXT); //DO NOT CHANGE

define ("K_BACKUP_EXCLUDE", "admin/backup,cache,install"); //directory names excluded from backup process (separated by comma)

// -- DEFAULT META and BODY Tags --
define ("K_AIOCP_TITLE", "All In One Control Panel");
define ("K_AIOCP_DESCRIPTION", "All In One Control Panel by Tecnick.com");
define ("K_AIOCP_AUTHOR", "Nicola Asuni - Tecnick.com S.r.l.");
define ("K_AIOCP_REPLY_TO", "info@tecnick.com");
define ("K_AIOCP_KEYWORDS", "Control Panel, Server, Functions, Menu");
define ("K_AIOCP_ICON", "../favicon.ico");
define ("K_AIOCP_STYLE", K_PATH_STYLE_SHEETS."aiocp.css");
define ("K_AIOCP_HELP_STYLE", K_PATH_STYLE_SHEETS."aiocp_help.css");

define ("K_CLOCK_IN_UTC", true); //if true display admin clock in UTC (GMT)

define ("K_DEAFULT_EMAIL_MSG","<"."?xml version=\"1.0\" encoding=\"iso-8859-1\"?".">
<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"DTD/xhtml1-transitional.dtd\">
<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">
<body>
<!-- START OF MESSAGE BODY -->

<!-- END OF MESSAGE BODY -->
</body>
</html>"); //set the default email message

// -- INCLUDE files -- 
require_once('../../admin/code/cp_functions_errmsg.'.CP_EXT);
require_once('../../shared/config/cp_db_config.'.CP_EXT);
require_once('../../shared/code/cp_db_connect.'.CP_EXT);
require_once('../../shared/code/cp_functions_general.'.CP_EXT);
require('../../shared/code/cp_languages.'.CP_EXT);
require_once('../../shared/code/cp_currency.'.CP_EXT);

ini_set("memory_limit", K_MAX_MEMORY_LIMIT); //set memory limit
ini_set("session.use_trans_sid", 0); //if =1 use PHPSESSID 
set_time_limit(K_MAX_EXECUTION_TIME); //Limit the maximum execution time

//============================================================+
// END OF FILE                                                 
//============================================================+
?>