<?php
//============================================================+
// File name   : cp_paths.php                                  
// Begin       : 2002-01-15                                    
// Last Update : 2003-03-31                                    
//                                                             
// Description : Cofiguration file for paths                   
//                                                             
//                                                             
// Author: Nicola Asuni                                        
//                                                             
// (c) Copyright:                                              
//               Tecnick.com S.r.l.                            
//               Via Ugo Foscolo n.19                          
//               09045 Quartu Sant'Elena (CA)                  
//               ITALY                                         
//               www.tecnick.com                               
//               info@tecnick.com                              
//============================================================+

// Normally you must change only the following 4 constant values

define ("K_PATH_HOST", ""); // host URL (e.g.: "http://www.yoursite.com")
define ("K_PATH_AIOCP", ""); // relative URL where this program is installed (e.g.: "/")
define ("K_PATH_MAIN", ""); //real full path where this program is installed (e.g: "/usr/local/apache/htdocs/AIOCP/")
define ("K_PATH_MYSQL_DATA", ""); //real full path to mySQL data needed for backup (leave void to not backup data) (e.g.: /var/lib/mysql/)
define ("K_STANDARD_PORT", 80); // standard port

// ----------------------------------------
define ("K_PATH_PUBLIC_CODE", K_PATH_HOST.K_PATH_AIOCP."public/code/"); //public code
define ("K_PATH_PUBLIC_CODE_REAL", K_PATH_MAIN."public/code/"); //server path of public code
define ("K_PATH_SEARCH_START", K_PATH_PUBLIC_CODE); //starting directory for search indexing
define ("K_PATH_SEARCH_FIRST_PAGE", K_PATH_SEARCH_START."cp_dpage.php?aiocp_dp=_main"); //starting page for search indexing
define ("K_PATH_CACHE", K_PATH_MAIN."cache/"); //cache directory for temporary files (full path)
define ("K_PATH_URL_CACHE", K_PATH_AIOCP."cache/"); //cache directory for temporary files (url path)
define ("K_PATH_FONTS", K_PATH_MAIN."fonts/"); //full font path
define ("FPDF_FONTPATH", K_PATH_FONTS); //path for PDF fonts
putenv("GDFONTPATH=".K_PATH_FONTS); //set GD library font path for GD2
define ("K_PATH_STYLE_SHEETS", "../styles/");
define ("K_PATH_JSCRIPTS", "../jscripts/");
define ("K_PATH_SHARED_JSCRIPTS", "../../shared/jscripts/");
define ("K_PATH_TRACEROUTE", "tracert"); // use "tracert" for windows and "/usr/sbin/traceroute" for unix
define ("K_PATH_FILES_BACKUP", K_PATH_MAIN."admin/backup/"); //directory path for backups
define ("K_PATH_FILES_ATTACHMENTS", "../../attachments/"); //relative newsletter attached files directory
define ("K_PATH_FILES_ATTACHMENTS_FULL", K_PATH_HOST.K_PATH_AIOCP."attachments/"); //full newsletter attached files directory
define ("K_PATH_FILES_PAGES", "../../pagefiles/"); //relative directory for dynamic pages files
define ("K_PATH_FILES_PAGES_FULL", K_PATH_HOST.K_PATH_AIOCP."pagefiles/"); //full directory for dynamic pages files
define ("K_PATH_FILES_DOWNLOAD", "../../download/"); //download dir
define ("K_PATH_FILES_BANNERS", "../../banners/"); //banners dir

define ("K_PATH_FILES_SHIPPING_MODULES", "../../shared/shipping/"); //shipping modules directory (for e-commerce)
define ("K_PATH_FILES_PAYMENT_MODULES", "../../shared/payment/"); //payment modules directory (for e-commerce)
define ("K_PATH_FILES_DOWNLOADABLES", K_PATH_MAIN."download/"); //directory path where are stored the downloadable proctucts (software). Please protect this directory from http access

define ("K_PATH_IMAGES", "../../images/");
define ("K_PATH_IMAGES_AVATARS", K_PATH_IMAGES."avatars/");
define ("K_PATH_IMAGES_AWARDS", K_PATH_IMAGES."awards/");
define ("K_PATH_IMAGES_BACKGROUNDS", K_PATH_IMAGES."backgrounds/cp/");
define ("K_PATH_IMAGES_BUTTONS", K_PATH_IMAGES."dbuttons/");
define ("K_PATH_IMAGES_COMPANY", K_PATH_IMAGES."company/");
define ("K_PATH_IMAGES_HTMLED", K_PATH_IMAGES."html_editor/");
define ("K_PATH_IMAGES_FLAGS", K_PATH_IMAGES."flags/");
define ("K_PATH_IMAGES_FORUM", K_PATH_IMAGES."forum/");
define ("K_PATH_IMAGES_ICONS", K_PATH_IMAGES."icons/");
define ("K_PATH_IMAGES_ICONS_CLIENT", K_PATH_IMAGES."icons_client/");
define ("K_PATH_IMAGES_LEVELS", K_PATH_IMAGES."levels/");
define ("K_PATH_IMAGES_REVIEWS", K_PATH_IMAGES."reviews/");
define ("K_PATH_IMAGES_MANUFACTURERS", K_PATH_IMAGES."manufacturers/");
define ("K_PATH_IMAGES_PRODUCTS", K_PATH_IMAGES."products/");
define ("K_PATH_IMAGES_PRODUCTS_CATEGORIES", K_PATH_IMAGES."products_categories/");
define ("K_PATH_IMAGES_SHELL", K_PATH_IMAGES."shell/");
define ("K_PATH_IMAGES_EMOTICONS", K_PATH_IMAGES."emoticons/");
define ("K_PATH_IMAGES_USER_PHOTO", K_PATH_IMAGES."userphoto/");
define ("K_PATH_IMAGES_BARS", K_PATH_IMAGES."bars/");

define ("K_PATH_SOUNDS", "../../sounds/");
define ("K_PATH_SOUNDS_MENU", K_PATH_SOUNDS."menu/");

define ("K_PATH_JAVA", "../java/");
define ("K_PATH_SHARED_JAVA", "../../shared/java/");

define ("K_FILE_USER_REG_OPTIONS", "../../shared/config/cp_user_registration.cfg");
define ("K_FILE_COMPANY_DATA", "../../shared/config/cp_company_data.cfg");

//============================================================+
// END OF FILE                                                 
//============================================================+
?>
