<?php
//============================================================+
// File name   : cp_ec_pdf_doc                                 
// Begin       : 2002-07-27                                    
// Last Update : 2002-09-29                                    
//                                                             
// Description : FPDF class extension                          
//                                                             
//                                                             
// Author: Nicola Asuni                                        
//                                                             
// (c) Copyright:                                              
//               Tecnick.com S.r.l.                            
//               Via Ugo Foscolo n.19                          
//               09045 Quartu Sant'Elena (CA)                  
//               ITALY                                         
//               www.tecnick.com                               
//               info@tecnick.com                              
//============================================================+

require_once('fpdf.php');

define("K_CELL_HEIGHT_RATIO", 1.25); //height of cell repect font height
define("K_TITLE_MAGNIFICATION", 1.3); //title magnification respect main font size

/*
* AIOCP PDF class extension for commercial documents
*/
class EC_DOC_PDF extends FPDF {
	
	var $header_margin;				// minimum distance between header and top page margin
	var $footer_margin;				// minimum distance between footer and bottom page margin
	var $header_font;				// header font
	var $footer_font;				// footer font
	var $lang_templates;			// language templates
	var $company_data;				// company data
	var $barcode = false;			// if true print barcode on footer
	var $print_header = true;		// if true print header
	var $print_footer = true;		// if true print footer
	var $header_width = 0;			// header width (0 = full page width)
	
	/*
 	* Set header margin
	* (minimum distance between header and top page margin)
	* @param hm distance in millimeters
	*/
	function SetHeaderMargin($hm=10) {
		$this->header_margin = $hm;
	}
	
	/*
 	* Set footer margin
	* (minimum distance between footer and bottom page margin)
	* @param fm distance in millimeters
	*/
	function SetFooterMargin($fm=10) {
		$this->footer_margin = $fm;
	}
	
	/*
 	* Page header
	*/
	function Header() {
		if ($this->print_header) {
			$header_string = "";
			
			if ($this->company_data['fiscalcode']) {
				 $header_string .= $this->lang_templates['w_fiscalcode'].": ".$this->company_data['fiscalcode']."";
			}
			
			if ($this->company_data['address']) {
				 $header_string .= " - ".$this->company_data['address'];
			}
			if ($this->company_data['postcode']) {
				 $header_string .= " - ".$this->company_data['postcode'];
			}
			if ($this->company_data['city']) {
				 $header_string .= " - ".$this->company_data['city'];
			}
			if ($this->company_data['state']) {
				 $header_string .= " (".$this->company_data['state'].")";
			}
			if ($this->company_data['country']) {
				 $header_string .= " - ".strtoupper($this->company_data['country']);
			}
			
			if ($this->company_data['telephone']) {
				 $header_string .= " - ".$this->lang_templates['w_telephone_abbr']." ".$this->company_data['telephone'];
			}
			if ($this->company_data['fax']) {
				 $header_string .= " - ".$this->lang_templates['w_fax']." ".$this->company_data['fax'];
			}
			
			if ($this->company_data['url']) {
				 $header_string .= " - ".$this->company_data['url'];
			}
			if ($this->company_data['email']) {
				 $header_string .= " - ".$this->company_data['email'];
			}
			
			//set current position
			$this->SetXY($this->lMargin, $this->header_margin);
			
			if (($this->company_data['logo']) AND ($this->company_data['logo'] != K_BLANK_IMAGE)) {
				$this->Image(K_PATH_IMAGES_COMPANY.$this->company_data['logo'], $this->lMargin, $this->header_margin, $this->company_data['logowidth']);
			}
			else {
				$this->img_rb_y = $pdf->GetY();
			}
			
			$cell_height = round((K_CELL_HEIGHT_RATIO * $this->header_font[2]) / $this->k, 2);
			
			$header_x = $this->lMargin + ($this->company_data['logowidth'] * 1.05); //set left margin for text data cell
			
			$this->SetFont($this->header_font[0], 'B', $this->header_font[2]);
			$this->SetX($header_x);
			$this->Cell($this->header_width, $cell_height, $this->company_data['name'], 0, 1, 'L'); 
			
			$this->SetFont($this->header_font[0], $this->header_font[1], $this->header_font[2]);
			$this->SetX($header_x);
			$this->MultiCell($this->header_width, $cell_height, $header_string, 0, 'L', 0);
			
			if (!$this->header_width) {
				//set style for cell border
				$this->SetLineWidth(0.3);
				$this->SetDrawColor(0, 0, 0);
				$this->SetY(max($this->img_rb_y, $this->GetY()));
				$this->Cell(0, 0, '', 'T', 0, 'C'); 
			}
			
			//restore margin position
			$this->SetXY($this->lMargin, $this->tMargin);
		}
	}
	
	/*
 	* Page footer
	* print page footer and page number
	*/
	function Footer() {
		
		if ($this->print_footer) {
			//$this->company_data['description']
			//$this->company_data['otherdata']
			
			//set font
			$this->SetFont($this->footer_font[0], $this->footer_font[1] , $this->footer_font[2]);
			//set style for cell border
			$line_width = 0.3;
			$this->SetLineWidth($line_width);
			$this->SetDrawColor(0, 0, 0);
			
			$footer_height = round((K_CELL_HEIGHT_RATIO * $this->footer_font[2]) / $this->k, 2); //footer height
			//get footer y position
			$footer_y = $this->h - $this->footer_margin - $footer_height;
			//set current position
			$this->SetXY($this->lMargin, $footer_y); 
			
			//print document barcode
			if ($this->barcode) {
				$this->Ln();
				$barcode_width = round(($this->w - $this->lMargin - $this->rMargin)); //max width
				$this->Barcode($this->lMargin, $footer_y + $line_width, $barcode_width, $footer_height - $line_width, "C128B", false, false, 2, $this->barcode);
			}
			
			$this->SetXY($this->lMargin, $footer_y); 
			
			//Print page number
			$this->Cell(0, $footer_height, $this->lang_templates['w_page']." ".$this->PageNo().' / {nb}', 'T', 0, 'R'); 
		}
	}
	
	/*
 	* Set document barcode
	* @param bc barcode
	*/
	function SetBarcode($bc="") {
		$this->barcode = $bc;
	}
	
	/*
 	* Print Barcode
	* @param $x x position in user units
	* @param $y y position in user units
	* @param $w width in user units
	* @param $h height position in user units
	* @param $type type of barcode
	* @param $style barcode style
	* @param $font font for text
	* @param $xres x resolution
	* @param $code code to print
	*/
	function Barcode($x, $y, $w, $h, $type, $style, $font, $xres, $code) {
		require_once("../../shared/barcode/barcode.php");
		require_once("../../shared/barcode/i25object.php");
		require_once("../../shared/barcode/c39object.php");
		require_once("../../shared/barcode/c128aobject.php");
		require_once("../../shared/barcode/c128bobject.php");
		require_once("../../shared/barcode/c128cobject.php");
		
		if (!$code) {return;}
		
		if (!$style) {
			$style  = BCS_ALIGN_LEFT;
			$style |= BCS_IMAGE_PNG;
			$style |= BCS_TRANSPARENT;
			//$style |= BCS_BORDER;
			//$style |= BCS_DRAW_TEXT;
			//$style |= BCS_STRETCH_TEXT;
			//$style |= BCS_REVERSE_COLOR;
		}
		if (!$font) {$font = BCD_DEFAULT_FONT;}
		if (!$xres) {$xres = BCD_DEFAULT_XRES;}
		
		$scale_factor = 1.5 * $xres * $this->k;
		$bc_w = round($w * $scale_factor); //width in points
		$bc_h = round($h * $scale_factor); //height in points
		
		switch (strtoupper($type)) {
			case "I25": {
				$obj = new I25Object($bc_w, $bc_h, $style, $code);
				break;
			}
			case "C128A": {
				$obj = new C128AObject($bc_w, $bc_h, $style, $code);
				break;
			}
			default:
			case "C128B": {
				$obj = new C128BObject($bc_w, $bc_h, $style, $code);
				break;
			}
			case "C128C": {
				$obj = new C128CObject($bc_w, $bc_h, $style, $code);
				break;
			}
			case "C39": {
				$obj = new C39Object($bc_w, $bc_h, $style, $code);
				break;
			}
		}
		
		$obj->SetFont($font);   
		$obj->DrawObject($xres);
		
		//use a temporary file....
		$tmpName=tempnam(K_PATH_CACHE,'img');
		imagepng($obj->mImg ,$tmpName);
		$this->Image($tmpName, $x, $y, $w, $h, 'png');
		$obj->DestroyObject();
		unset($obj);
		unlink($tmpName);
	}
	
	/*
 	* return the PDF data
	*/
	function GetPDFData() {
		if($this->state < 3) {
			$this->Close();
		}
		return $this->buffer;
	}
}

//============================================================+
// END OF FILE                                                 
//============================================================+
?>