/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml;

import com.spket.util.Enumerator;
import com.spket.util.StringUtils;
import com.spket.xml.XMLConstants;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.xerces.xni.NamespaceContext;

public class NamespaceContextImpl
implements NamespaceContext,
Cloneable {
    protected String[] fNamespace = new String[32];
    protected int fNamespaceSize;
    protected int[] fContext = new int[8];
    protected int fCurrentContext;

    public boolean declarePrefix(String string, String string2) {
        if (XMLConstants.PREFIX_XML.equals(string) || XMLConstants.PREFIX_XMLNS.equals(string)) {
            return false;
        }
        for (int i = this.fNamespaceSize; i > this.fContext[this.fCurrentContext]; i -= 2) {
            if (!StringUtils.equals((Object)this.fNamespace[i - 2], (Object)string)) continue;
            this.fNamespace[i - 1] = string2;
            return true;
        }
        if (this.fNamespaceSize == this.fNamespace.length) {
            String[] stringArray = new String[this.fNamespaceSize * 2];
            System.arraycopy(this.fNamespace, 0, stringArray, 0, this.fNamespaceSize);
            this.fNamespace = stringArray;
        }
        this.fNamespace[this.fNamespaceSize++] = string;
        this.fNamespace[this.fNamespaceSize++] = string2;
        return true;
    }

    public Enumeration getAllPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.fNamespaceSize / 2);
        for (int i = this.fNamespaceSize; i > 0; i -= 2) {
            String string = this.fNamespace[i - 2];
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return new Enumerator(arrayList);
    }

    public String getDeclaredPrefixAt(int n) {
        return this.fNamespace[this.fContext[this.fCurrentContext] + n * 2];
    }

    public int getDeclaredPrefixCount() {
        return (this.fNamespaceSize - this.fContext[this.fCurrentContext]) / 2;
    }

    public String getPrefix(String string) {
        for (int i = this.fNamespaceSize; i > 0; i -= 2) {
            if (!StringUtils.equals((Object)this.fNamespace[i - 1], (Object)string) || !StringUtils.equals((Object)this.getURI(this.fNamespace[i - 2]), (Object)string)) continue;
            return this.fNamespace[i - 2];
        }
        return null;
    }

    public String getURI(String string) {
        for (int i = this.fNamespaceSize; i > 0; i -= 2) {
            if (!StringUtils.equals((Object)this.fNamespace[i - 2], (Object)string)) continue;
            return this.fNamespace[i - 1];
        }
        return null;
    }

    public void popContext() {
        this.fNamespaceSize = this.fContext[this.fCurrentContext--];
    }

    public void pushContext() {
        if (this.fCurrentContext + 1 == this.fContext.length) {
            int[] nArray = new int[this.fContext.length * 2];
            System.arraycopy(this.fContext, 0, nArray, 0, this.fContext.length);
            this.fContext = nArray;
        }
        this.fContext[++this.fCurrentContext] = this.fNamespaceSize;
    }

    public void reset() {
        this.fNamespaceSize = 0;
        this.fCurrentContext = 0;
        this.fContext[this.fCurrentContext] = this.fNamespaceSize;
        this.fNamespace[this.fNamespaceSize++] = XMLConstants.PREFIX_XML;
        this.fNamespace[this.fNamespaceSize++] = XMLConstants.XML_URI;
        this.fNamespace[this.fNamespaceSize++] = XMLConstants.PREFIX_XMLNS;
        this.fNamespace[this.fNamespaceSize++] = XMLConstants.XMLNS_URI;
        ++this.fCurrentContext;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

