/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml;

import com.spket.buffer.BufferChangedEvent;
import com.spket.buffer.BufferManager;
import com.spket.buffer.IBuffer;
import com.spket.buffer.IBufferListener;
import com.spket.ui.text.IProblem;
import com.spket.ui.text.IProblemRequestor;
import com.spket.util.IntStack;
import com.spket.util.StringUtils;
import com.spket.xml.IDOMModel;
import com.spket.xml.IModelChangedListener;
import com.spket.xml.INodeRegion;
import com.spket.xml.ModelChangedEvent;
import com.spket.xml.PositionInfo;
import com.spket.xml.StructureTracker;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLProblem;
import com.spket.xml.grammars.GrammarManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.util.SymbolTable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

public class XMLModel
implements IDOMModel {
    private IPath fPath;
    private IProject fProject;
    protected GrammarManager fGrammar;
    protected IBuffer fBuffer;
    protected XMLDocument fXMLDocument;
    protected boolean fTrace = true;
    protected long fLastModified;
    protected ListenerList fListeners;
    protected StructureTracker fStructureTracker;
    private List fProblems = new ArrayList();
    protected IBufferListener fBufferListener = new IBufferListener(){

        public void bufferAboutToBeChanged(BufferChangedEvent bufferChangedEvent) {
            XMLModel.this.onBufferAboutToBeChanged(bufferChangedEvent);
        }

        public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
            XMLModel.this.onBufferChanged(bufferChangedEvent);
        }

        public void bufferClosed(IBuffer iBuffer) {
            if (XMLModel.this.fBuffer != null) {
                XMLModel.this.fBuffer = null;
                if (XMLModel.this.fXMLDocument != null) {
                    XMLModel.this.fXMLDocument.dispose();
                    XMLModel.this.fXMLDocument = null;
                }
            }
        }
    };

    public XMLModel() {
        this.fGrammar = this.createGrammarManager();
        this.fStructureTracker = new StructureTracker(this);
        this.fListeners = new ListenerList(1);
    }

    public void dispose() {
        if (this.fBuffer != null) {
            if (this.fBufferListener != null) {
                this.fBuffer.removeBufferListener(this.fBufferListener);
            }
            BufferManager.getDefault().releaseBuffer(this.fPath);
            this.fBuffer = null;
        }
        if (this.fXMLDocument != null) {
            this.fXMLDocument.dispose();
            this.fXMLDocument = null;
        }
        if (this.fListeners != null) {
            this.fListeners.clear();
            this.fListeners = null;
        }
        if (this.fStructureTracker != null) {
            this.fStructureTracker.dispose();
            this.fStructureTracker = null;
        }
        if (this.fProblems != null) {
            this.fProblems.clear();
            this.fProblems = null;
        }
        this.fBufferListener = null;
    }

    public IBuffer getBuffer() {
        return this.fBuffer;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public void setPath(IPath iPath) {
        if (this.fPath == iPath) {
            return;
        }
        if (StringUtils.equals((Object)this.fPath, (Object)iPath)) {
            return;
        }
        IBuffer iBuffer = null;
        BufferManager bufferManager = BufferManager.getDefault();
        if (iPath != null) {
            iBuffer = bufferManager.getBuffer(iPath);
        }
        if (this.fBuffer == iBuffer) {
            if (iBuffer != null) {
                bufferManager.releaseBuffer(iPath);
            }
            return;
        }
        if (this.fBuffer != null) {
            this.fBuffer.removeBufferListener(this.fBufferListener);
            bufferManager.releaseBuffer(this.fPath);
        }
        this.fPath = iPath;
        this.fBuffer = iBuffer;
        if (this.fGrammar != null) {
            this.fGrammar.reset();
        }
        if (this.fBuffer == null) {
            if (this.fXMLDocument != null) {
                this.fXMLDocument.dispose();
                this.fXMLDocument = null;
            }
        } else {
            this.fXMLDocument = this.fStructureTracker.reparse();
            this.fBuffer.addBufferListener(this.fBufferListener);
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject iProject) {
        this.fProject = iProject;
        if (this.fGrammar != null) {
            this.fGrammar.reset();
        }
    }

    public XMLDocument getXMLDocument() {
        return this.fXMLDocument;
    }

    public Image getImage(Object object) {
        return null;
    }

    public SymbolTable getSymbolTable() {
        return null;
    }

    public GrammarManager getGrammar() {
        return this.fGrammar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptProblems(int n, int n2, List list) {
        int n3 = this.fBuffer.getLength();
        if (n == 0 && n2 >= n3) {
            List list2 = this.fProblems;
            synchronized (list2) {
                if (this.fProblems.size() > 0) {
                    this.fProblems.clear();
                }
                if (list.size() > 0) {
                    this.fProblems.addAll(list);
                }
            }
        }
        int n4 = 0;
        List list3 = this.fProblems;
        synchronized (list3) {
            int n5 = this.fProblems.size();
            while (n4 < n5) {
                IProblem iProblem = (IProblem)this.fProblems.get(n4);
                int n6 = iProblem.getOffset();
                if (n6 >= n && n6 <= n2) {
                    this.fProblems.remove(n4);
                    --n5;
                    continue;
                }
                ++n4;
            }
            if (list.size() > 0) {
                this.fProblems.addAll(list);
            }
        }
    }

    protected void onBufferAboutToBeChanged(BufferChangedEvent bufferChangedEvent) {
        this.fLastModified = System.currentTimeMillis();
        if (this.fXMLDocument != null && this.fTrace) {
            this.fStructureTracker.prepare(bufferChangedEvent.getOffset(), bufferChangedEvent.getLength(), bufferChangedEvent.getText());
        }
    }

    protected void onBufferChanged(BufferChangedEvent bufferChangedEvent) {
        XMLNode xMLNode = null;
        if (this.fTrace) {
            long l = System.currentTimeMillis();
            xMLNode = this.fStructureTracker.update();
            l = System.currentTimeMillis() - l;
        }
        this.fireModelChanged(ModelChangedEvent.CONTENT_CHANGE);
        if (this.fTrace) {
            this.fireModelObjectChanged(xMLNode);
        }
    }

    public void addModelChangedListener(IModelChangedListener iModelChangedListener) {
        if (this.fListeners != null) {
            this.fListeners.add((Object)iModelChangedListener);
        }
    }

    public void removeModelChangedListener(IModelChangedListener iModelChangedListener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)iModelChangedListener);
        }
    }

    public void fireModelChanged(ModelChangedEvent modelChangedEvent) {
        if (this.fListeners.size() > 0) {
            Object[] objectArray = this.fListeners.getListeners();
            for (int i = 0; i < objectArray.length; ++i) {
                ((IModelChangedListener)objectArray[i]).modelChanged(modelChangedEvent);
            }
        }
    }

    public void fireModelObjectChanged(Object object) {
        if (this.fListeners.size() > 0) {
            this.fireModelChanged(new ModelChangedEvent(this, 3, object, null));
        }
    }

    public Template[] getTemplates(String string) {
        return null;
    }

    public TemplateContextType getContextType(PositionInfo positionInfo) {
        return null;
    }

    public void reconcile(IProblemRequestor iProblemRequestor) {
        long l = this.fLastModified;
        List list = this.validating();
        if (l == this.fLastModified && list != null) {
            iProblemRequestor.beginReporting();
            if (list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && l == this.fLastModified) {
                    iProblemRequestor.acceptProblem((IProblem)iterator.next());
                }
            }
            iProblemRequestor.endReporting(l != this.fLastModified);
        }
    }

    protected GrammarManager createGrammarManager() {
        return new GrammarManager(this);
    }

    protected void handleProblem(List list, int n, int n2, String string) {
        if (n2 > 0) {
            XMLProblem xMLProblem = new XMLProblem(string, 1, n, n2, -1);
            list.add(xMLProblem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List validating() {
        int n = 0;
        IntStack intStack = new IntStack();
        ArrayList arrayList = new ArrayList();
        XMLNode xMLNode = this.getXMLDocument();
        long l = this.fLastModified;
        block3: while (xMLNode != null && l == this.fLastModified) {
            int n2 = ((XMLNode)xMLNode).getChildrenCount();
            if (n2 > 0) {
                XMLNode[] xMLNodeArray = ((XMLNode)xMLNode).getChildren();
                for (int i = n; i < n2; ++i) {
                    XMLElement xMLElement;
                    if (l != this.fLastModified) break block3;
                    XMLNode xMLNode2 = xMLNodeArray[i];
                    if (xMLNode2.getNodeType() != 1 || (xMLElement = (XMLElement)xMLNode2).isEmptyTag()) continue;
                    INodeRegion iNodeRegion = xMLElement.getStartTagRegion();
                    if (iNodeRegion == null) {
                        iNodeRegion = xMLElement.getEndTagRegion();
                        this.handleProblem(arrayList, iNodeRegion.getStart(), xMLElement.getName().length() + 2, "Missing start tag");
                        continue;
                    }
                    if (xMLElement.getEndTagRegion() == null) {
                        this.handleProblem(arrayList, iNodeRegion.getStart(), xMLElement.getName().length() + 1, "Missing closing tag");
                    }
                    if (xMLElement.getChildrenCount() <= 0) continue;
                    n = 0;
                    xMLNode = xMLNode2;
                    intStack.push(i + 1);
                    continue block3;
                }
            }
            if (intStack.size() == 0) break;
            xMLNode = ((XMLNode)xMLNode).getParent();
            n = intStack.pop();
        }
        if (l == this.fLastModified) {
            List list = this.fProblems;
            synchronized (list) {
                if (this.fProblems.size() > 0) {
                    arrayList.addAll(this.fProblems);
                }
            }
        }
        return arrayList;
    }
}

