/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.grammars;

import com.spket.util.Debug;
import com.spket.util.StringUtils;
import com.spket.xml.IDOMModel;
import com.spket.xml.XMLDocType;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import com.spket.xml.grammars.CMContainer;
import com.spket.xml.grammars.CMDocument;
import com.spket.xml.grammars.CMElement;
import com.spket.xml.grammars.CMNode;
import com.spket.xml.grammars.ISymbolProvider;
import com.spket.xml.grammars.dtd.DTDDocument;
import com.spket.xml.grammars.xsd.XSDDocument;
import com.spket.xml.internal.XMLPlugin;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.ShadowedSymbolTable;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLCatalogResolver;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class GrammarManager {
    private static final String DTD = "dtd";
    private static final String XSD = "xsd";
    private static final String T_SYMBOL = "symbol";
    private static final String T_CATALOG = "catalog";
    private static final String T_MAPPER = "mapper";
    private static final String T_NAMESPACE = "namespace";
    private static final String A_FILE = "file";
    private static final String A_CLASS = "class";
    private static final String A_PREFIX = "prefix";
    private static final String A_EXTENSIONS = "extensions";
    private static final String A_URI = "uri";
    private static final String A_PUBLIC_ID = "publicId";
    private static final String A_SYSTEM_ID = "systemId";
    private static final String CATALOG_EXTENSION_POINT = "com.spket.xml.catalog";
    private static Map gMapper;
    private static Map gGrammars;
    private static Map gNamespaces;
    private static SymbolTable gSymbolTable;
    private static XMLCatalogResolver gCatalogResolver;
    private XMLModel fModel;
    private boolean fSearchDocType;
    private XMLGrammarPreparser fPreparser;
    private Map fGrammars = new HashMap(4);

    private static void initialize() {
        ArrayList<String> arrayList = new ArrayList<String>();
        gMapper = new HashMap();
        gGrammars = new HashMap();
        gNamespaces = new HashMap();
        gSymbolTable = new SymbolTable(709);
        GrammarManager.initialize(gSymbolTable);
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(CATALOG_EXTENSION_POINT);
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            Object object;
            Object object2;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[i];
            String string = iConfigurationElement.getName();
            if (T_CATALOG.equals(string)) {
                string = iConfigurationElement.getAttribute(A_FILE);
                if (string == null || (object2 = FileLocator.find((Bundle)(object = Platform.getBundle((String)iConfigurationElement.getContributor().getName())), (IPath)Path.fromPortableString((String)string), null)) == null) continue;
                arrayList.add(((URL)object2).toExternalForm());
                continue;
            }
            if (T_SYMBOL.equals(string)) {
                string = iConfigurationElement.getAttribute(A_CLASS);
                if (string == null) {
                    XMLPlugin.logErrorMessage("class is required for symbol.");
                    continue;
                }
                try {
                    object = (ISymbolProvider)iConfigurationElement.createExecutableExtension(A_CLASS);
                    object.initialize(gSymbolTable);
                }
                catch (CoreException coreException) {
                    XMLPlugin.log(coreException.getStatus());
                }
                catch (RuntimeException runtimeException) {
                    XMLPlugin.log(runtimeException);
                }
                continue;
            }
            if (T_MAPPER.equals(string)) {
                Object object3;
                object = StringUtils.split((String)iConfigurationElement.getAttribute(A_EXTENSIONS), (char)',');
                if (((String[])object).length <= 0) continue;
                object2 = null;
                String[] stringArray = null;
                string = iConfigurationElement.getAttribute(A_URI);
                if (string == null) {
                    string = iConfigurationElement.getAttribute(A_PUBLIC_ID);
                    if (string == null) {
                        string = iConfigurationElement.getAttribute(A_SYSTEM_ID);
                        if (string != null) {
                            stringArray = object3 = new String[2];
                            object3[1] = string;
                        }
                    } else {
                        stringArray = object3 = new String[2];
                        object3[0] = string;
                        object3[1] = iConfigurationElement.getAttribute(A_SYSTEM_ID);
                    }
                } else {
                    object2 = gSymbolTable.addSymbol(string);
                    stringArray = object2;
                }
                if (stringArray == null) continue;
                object3 = null;
                for (int j = 0; j < ((Object)object).length; ++j) {
                    object3 = gSymbolTable.addSymbol((String)object[j]);
                    gMapper.put(object3, stringArray);
                    if (object2 == null || gNamespaces.containsKey(object3)) continue;
                    gNamespaces.put(object3, object2);
                }
                continue;
            }
            if (!T_NAMESPACE.equals(string) || (string = iConfigurationElement.getAttribute(A_PREFIX)) == null || string.length() <= 0) continue;
            object = iConfigurationElement.getAttribute(A_URI);
            string = gSymbolTable.addSymbol(string);
            if (object == null) continue;
            gNamespaces.put(string, gSymbolTable.addSymbol((String)object));
        }
        if (arrayList.size() > 0) {
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            gCatalogResolver = new XMLCatalogResolver(stringArray);
        } else {
            gCatalogResolver = new XMLCatalogResolver();
        }
    }

    private static void initialize(SymbolTable symbolTable) {
        symbolTable.addSymbol(SchemaSymbols.XSI_SCHEMALOCATION);
        symbolTable.addSymbol(SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION);
        symbolTable.addSymbol(NamespaceContext.XML_URI);
        symbolTable.addSymbol(NamespaceContext.XMLNS_URI);
        symbolTable.addSymbol(SchemaSymbols.URI_SCHEMAFORSCHEMA);
        symbolTable.addSymbol(SchemaSymbols.URI_XSI);
        symbolTable.addSymbol(XMLSymbols.EMPTY_STRING);
        symbolTable.addSymbol(XMLSymbols.PREFIX_XML);
        symbolTable.addSymbol(XMLSymbols.PREFIX_XMLNS);
    }

    public static SymbolTable getSymbolTable() {
        return gSymbolTable;
    }

    public GrammarManager(XMLModel xMLModel) {
        this.fModel = xMLModel;
    }

    protected IDOMModel getModel() {
        return this.fModel;
    }

    public void reset() {
        if (this.fGrammars != null && this.fGrammars.size() > 0) {
            this.fGrammars.clear();
        }
    }

    public String getDefaultNamespace(String string) {
        if (string == null) {
            return null;
        }
        return (String)gNamespaces.get(string);
    }

    public Collection getPrefixes() {
        return gNamespaces.keySet();
    }

    public Collection getNamespaces() {
        return gNamespaces.values();
    }

    protected CMDocument getCMDocument() {
        Object v;
        String string;
        IPath iPath;
        CMDocument cMDocument = null;
        if (this.fModel != null && (iPath = this.fModel.getPath()) != null && (string = iPath.getFileExtension()) != null && (v = gMapper.get(string)) != null) {
            String[] stringArray;
            if (v instanceof String) {
                cMDocument = this.getCMDocument((String)v);
            } else if (v instanceof String[] && (stringArray = (String[])v).length == 2) {
                cMDocument = this.getCMDocument(stringArray[0], stringArray[1]);
            }
        }
        return cMDocument;
    }

    public CMDocument getCMDocument(XMLNode xMLNode) {
        CMDocument cMDocument = null;
        if (xMLNode != null) {
            switch (xMLNode.getNodeType()) {
                case 0: 
                case 1: 
                case 6: {
                    break;
                }
                default: {
                    xMLNode = xMLNode.getParent();
                }
            }
            if (xMLNode != null) {
                if (xMLNode.getNodeType() == 1) {
                    cMDocument = this.getCMDocument(xMLNode.getNamespace(), xMLNode);
                }
                if (cMDocument == null && this.fSearchDocType) {
                    XMLDocType xMLDocType = null;
                    if (xMLNode.getNodeType() == 6) {
                        xMLDocType = (XMLDocType)xMLNode;
                    } else {
                        XMLDocument xMLDocument = xMLNode.getDocument();
                        if (xMLDocument != null) {
                            xMLDocType = xMLDocument.getDoctype();
                        }
                    }
                    if (xMLDocType != null && (xMLDocType.getPublicId() != null || xMLDocType.getSystemId() != null)) {
                        cMDocument = this.getCMDocument(xMLDocType.getPublicId(), xMLDocType.getSystemId());
                    }
                }
            }
        }
        if (cMDocument == null) {
            cMDocument = this.getCMDocument();
        }
        return cMDocument;
    }

    public CMContainer getNodeDeclaration(String string, XMLNode xMLNode) {
        CMDocument cMDocument = this.getCMDocument(string, xMLNode);
        if (cMDocument == null) {
            cMDocument = this.getCMDocument();
        }
        if (xMLNode != null && 1 == xMLNode.getNodeType() && cMDocument != null) {
            if (Boolean.TRUE.equals(cMDocument.getProperty(CMNode.FLAT_MODE))) {
                CMContainer cMContainer = cMDocument;
                if (StringUtils.equals((Object)string, (Object)xMLNode.getNamespace())) {
                    cMContainer = (CMContainer)cMDocument.getElements().getNamedItem(xMLNode.getLocalName());
                }
                return cMContainer == null ? cMDocument : cMContainer;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (xMLNode != null && xMLNode.getNodeType() == 1) {
                if (StringUtils.equals((Object)string, (Object)xMLNode.getNamespace())) {
                    arrayList.add(xMLNode.getLocalName());
                }
                xMLNode = xMLNode.getParent();
            }
            CMContainer cMContainer = null;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                String string2 = (String)arrayList.get(i);
                cMContainer = cMContainer == null ? (CMContainer)cMDocument.getElements().getNamedItem(string2) : (CMContainer)cMContainer.getElements().getNamedItem(string2);
            }
            return cMContainer == null ? cMDocument : cMContainer;
        }
        return cMDocument;
    }

    public CMElement getElementDeclaration(XMLElement xMLElement) {
        CMDocument cMDocument = this.getCMDocument(xMLElement);
        if (cMDocument != null) {
            if (Boolean.TRUE.equals(cMDocument.getProperty(CMNode.FLAT_MODE))) {
                return (CMElement)cMDocument.getElements().getNamedItem(xMLElement.getLocalName());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = xMLElement.getNamespace();
            arrayList.add(xMLElement.getLocalName());
            for (XMLNode xMLNode = xMLElement.getParent(); xMLNode != null && xMLNode.getNodeType() == 1; xMLNode = xMLNode.getParent()) {
                if (!StringUtils.equals((Object)string, (Object)xMLNode.getNamespace())) continue;
                arrayList.add(xMLNode.getLocalName());
            }
            CMContainer cMContainer = null;
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                String string2 = (String)arrayList.get(i);
                cMContainer = cMContainer == null ? (CMElement)cMDocument.getElements().getNamedItem(string2) : (CMElement)cMContainer.getElements().getNamedItem(string2);
            }
            return cMContainer;
        }
        return null;
    }

    public CMDocument getCMDocument(String string) {
        CMDocument cMDocument = null;
        if (string != null) {
            String string2 = null;
            try {
                string2 = gCatalogResolver.resolveURI(string);
            }
            catch (IOException iOException) {
                Debug.debug((Throwable)iOException);
            }
            if (string2 != null) {
                cMDocument = this.getCMDocument(string2, false);
            }
        }
        return cMDocument;
    }

    protected CMDocument getCMDocument(String string, XMLNode xMLNode) {
        String string2;
        CMDocument cMDocument = null;
        if (string != null) {
            cMDocument = this.getCMDocument(string);
        }
        if (cMDocument == null && xMLNode != null && (string2 = XMLUtils.getSchemaLocation(xMLNode, string)) != null) {
            cMDocument = this.getCMDocument(string2, true);
        }
        return cMDocument;
    }

    protected CMDocument getCMDocument(String string, String string2) {
        CMDocument cMDocument = null;
        String string3 = null;
        boolean bl = false;
        try {
            if (string != null) {
                string3 = gCatalogResolver.resolvePublic(string, string2);
            } else if (string2 != null && (string3 = gCatalogResolver.resolveSystem(string2)) == null) {
                bl = true;
                string3 = string2;
            }
        }
        catch (IOException iOException) {
            Debug.debug((Throwable)iOException);
        }
        if (string3 != null) {
            cMDocument = this.getCMDocument(string3, bl);
        }
        return cMDocument;
    }

    protected CMDocument getCMDocument(String string, boolean bl) {
        Object object;
        String string2;
        boolean bl2;
        boolean bl3 = bl2 = !bl;
        if (bl) {
            int n = string.indexOf(58);
            if (n == -1) {
                char c = string.charAt(0);
                if (c != '/' && (string2 = this.fModel.getPath()) != null) {
                    try {
                        object = new URI(string2.toPortableString());
                        object = ((URI)object).resolve(string);
                        string = ((URI)object).toString();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Debug.debug((Throwable)uRISyntaxException);
                        return null;
                    }
                }
            } else {
                bl = false;
            }
        }
        URL uRL = null;
        try {
            if (bl) {
                if (this.fModel.getProject() == null) {
                    File file = new File(string);
                    if (file.exists() && file.isFile()) {
                        uRL = file.toURL();
                    }
                } else {
                    Path path = new Path(string);
                    string2 = ResourcesPlugin.getWorkspace().getRoot();
                    object = string2.getFile((IPath)path);
                    if (object == null || !object.exists() || object.getType() != 1) {
                        object = string2.getFileForLocation((IPath)path);
                    }
                    if (object != null && object.exists() && 1 == object.getType()) {
                        uRL = object.getLocationURI().toURL();
                    }
                }
            } else {
                uRL = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Debug.debug((Throwable)malformedURLException);
        }
        CMDocument cMDocument = null;
        if (uRL != null && (cMDocument = (CMDocument)this.fGrammars.get(string2 = uRL.toExternalForm())) == null) {
            object = (Grammar)gGrammars.get(string2);
            if (object == null) {
                Object object2;
                if (this.fPreparser == null) {
                    object2 = new Resolver();
                    this.fPreparser = new XMLGrammarPreparser((SymbolTable)new ShadowedSymbolTable(gSymbolTable));
                    this.fPreparser.setEntityResolver((XMLEntityResolver)object2);
                    this.fPreparser.registerPreparser("http://www.w3.org/TR/REC-xml", null);
                    this.fPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
                    this.fPreparser.setProperty("http://apache.org/xml/properties/internal/entity-resolver", object2);
                }
                object2 = null;
                if (string2.endsWith(DTD)) {
                    object2 = "http://www.w3.org/TR/REC-xml";
                } else if (string2.endsWith(XSD)) {
                    object2 = "http://www.w3.org/2001/XMLSchema";
                }
                if (object2 != null) {
                    try {
                        XMLInputSource xMLInputSource = new XMLInputSource(null, string2, null);
                        object = this.fPreparser.preparseGrammar((String)object2, xMLInputSource);
                    }
                    catch (XNIException xNIException) {
                        Debug.debug((Throwable)xNIException);
                    }
                    catch (IOException iOException) {
                        Debug.debug((Throwable)iOException);
                    }
                }
                if (bl2 && object != null) {
                    gGrammars.put(string2, object);
                }
            }
            if (object != null) {
                cMDocument = object instanceof DTDGrammar ? new DTDDocument((DTDGrammar)object) : new XSDDocument((SchemaGrammar)object);
                this.fGrammars.put(string2, cMDocument);
            }
        }
        return cMDocument;
    }

    static {
        GrammarManager.initialize();
    }

    private static class Resolver
    implements XMLEntityResolver {
        private Resolver() {
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
            int n;
            String string = xMLResourceIdentifier.getLiteralSystemId();
            if (string != null && (n = string.indexOf(58)) == -1) {
                return new XMLInputSource(xMLResourceIdentifier.getPublicId(), xMLResourceIdentifier.getExpandedSystemId(), xMLResourceIdentifier.getBaseSystemId());
            }
            return gCatalogResolver.resolveEntity(xMLResourceIdentifier);
        }
    }
}

