/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.internal.text;

import com.spket.ui.text.AutoEditStrategy;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import com.spket.xml.INodeRegion;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import com.spket.xml.editors.XMLEditor;
import com.spket.xml.internal.XMLPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class XMLAutoIndentStrategy
extends AutoEditStrategy {
    private XMLEditor fEditor;
    private PositionInfo fPosition = new PositionInfo();

    protected static IPreferenceStore getPreferenceStore() {
        return XMLPlugin.getDefault().getCombinedPreferenceStore();
    }

    public XMLAutoIndentStrategy(XMLEditor xMLEditor, String string) {
        super(string);
        this.fEditor = xMLEditor;
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (!documentCommand.doit || documentCommand.text == null) {
            return;
        }
        if (!this.isSmartMode()) {
            super.customizeDocumentCommand(iDocument, documentCommand);
            return;
        }
        if (documentCommand.length == 0 && this.isLineDelimiter(iDocument, documentCommand.text)) {
            this.smartIndentAfterNewLine(iDocument, documentCommand);
        } else if (documentCommand.text.length() == 1) {
            this.smartIndentOnKeypress(iDocument, documentCommand);
        }
    }

    protected boolean isSmartMode() {
        if (this.fEditor == null) {
            return false;
        }
        return this.fEditor.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
    }

    private void smartIndentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        block22: {
            if (documentCommand.offset < 1) {
                return;
            }
            int n = documentCommand.offset - 1;
            XMLModel xMLModel = this.fEditor.getModel();
            if (xMLModel != null) {
                this.fPosition.reset();
                XMLUtils.findNode(xMLModel, n, this.fPosition);
                try {
                    if (100 != this.fPosition.nodeType) break block22;
                    XMLElement xMLElement = (XMLElement)this.fPosition.node;
                    INodeRegion iNodeRegion = xMLElement.getStartTagRegion();
                    if (n == iNodeRegion.getEnd() - 1) {
                        if (!xMLElement.isEmptyTag()) {
                            String string = this.getLineIndentation(iDocument, iNodeRegion.getStart());
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(documentCommand.text);
                            stringBuffer.append(string);
                            stringBuffer.append('\t');
                            iNodeRegion = xMLElement.getEndTagRegion();
                            if (iNodeRegion != null && n == iNodeRegion.getStart() - 1) {
                                documentCommand.shiftsCaret = false;
                                documentCommand.caretOffset = documentCommand.offset + stringBuffer.length();
                                stringBuffer.append(documentCommand.text);
                                stringBuffer.append(string);
                            }
                            documentCommand.text = stringBuffer.toString();
                            return;
                        }
                        break block22;
                    }
                    int n2 = iNodeRegion.getStart();
                    if (n < n2 + xMLElement.getName().length()) break block22;
                    int n3 = 0;
                    XMLAttr xMLAttr = null;
                    boolean bl = true;
                    int n4 = xMLElement.getAttrCount();
                    XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
                    if (n4 > 0) {
                        for (n3 = 0; n3 < n4 && n >= (iNodeRegion = (xMLAttr = xMLAttrArray[n3]).getNameRegion()).getStart() + n2; ++n3) {
                            if (n < iNodeRegion.getEnd() + n2) {
                                bl = false;
                                break;
                            }
                            iNodeRegion = xMLAttr.getValueRegion();
                            if (iNodeRegion != null && n >= iNodeRegion.getEnd() + n2 - 1) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (!bl) break block22;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(documentCommand.text);
                    if (n3 == 0) {
                        stringBuffer.append(this.getLineIndentation(iDocument, n2));
                        stringBuffer.append('\t');
                    } else {
                        xMLAttr = xMLAttrArray[n3 - 1];
                        int n5 = xMLAttr.getNameRegion().getStart() + n2;
                        IRegion iRegion = iDocument.getLineInformationOfOffset(n5);
                        if (iRegion.getOffset() > n2) {
                            stringBuffer.append(this.getLineIndentation(iDocument, n5));
                        } else {
                            stringBuffer.append(this.getLineIndentation(iDocument, n2));
                            n5 = xMLAttrArray[0].getNameRegion().getStart();
                            int n6 = this.getTabSize();
                            if (n6 > 0) {
                                int n7;
                                int n8 = n5 / n6;
                                for (n7 = 0; n7 < n8; ++n7) {
                                    stringBuffer.append('\t');
                                }
                                n8 = n5 % n6;
                                for (n7 = 0; n7 < n8; ++n7) {
                                    stringBuffer.append(' ');
                                }
                            } else {
                                for (int i = 0; i < n5; ++i) {
                                    stringBuffer.append(' ');
                                }
                            }
                        }
                    }
                    if (n3 < n4) {
                        iNodeRegion = xMLAttrArray[n3].getNameRegion();
                        documentCommand.length = iNodeRegion.getStart() + n2 - documentCommand.offset;
                    } else {
                        n = xMLElement.getStartTagRegion().getEnd() - 1;
                        if (iDocument.getChar(n) == '>') {
                            documentCommand.length = n - documentCommand.offset;
                        }
                    }
                    documentCommand.text = stringBuffer.toString();
                    return;
                }
                catch (BadLocationException badLocationException) {
                    Debug.debug((Throwable)badLocationException);
                }
            }
        }
        super.customizeDocumentCommand(iDocument, documentCommand);
    }

    private void smartIndentOnKeypress(IDocument iDocument, DocumentCommand documentCommand) {
        block12: {
            if (documentCommand.offset <= 1) {
                return;
            }
            char c = documentCommand.text.charAt(0);
            if (c == '/') {
                int n = documentCommand.offset - 1;
                try {
                    String string;
                    String string2;
                    XMLElement xMLElement;
                    INodeRegion iNodeRegion;
                    XMLNode xMLNode;
                    XMLModel xMLModel;
                    int n2;
                    int n3;
                    int n4;
                    if (iDocument.getChar(n) != '<' || (n4 = this.findEndOfWhiteSpace(iDocument, n3 = iDocument.getLineOffset(n2 = iDocument.getLineOfOffset(n)), n)) != n || (xMLModel = this.fEditor.getModel()) == null) break block12;
                    this.fPosition.reset();
                    XMLUtils.findNode(xMLModel, n3, this.fPosition);
                    if (3 == this.fPosition.nodeType && (xMLNode = this.fPosition.node) != null && 1 == xMLNode.getNodeType() && (iNodeRegion = (xMLElement = (XMLElement)xMLNode).getStartTagRegion()) != null && !(string2 = this.getLineIndentation(iDocument, iNodeRegion.getStart())).equals(string = iDocument.get(n3, n - n3))) {
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        stringBuffer.append(iDocument.get(n4, documentCommand.offset - n4));
                        stringBuffer.append(documentCommand.text);
                        documentCommand.length += documentCommand.offset - n3;
                        documentCommand.offset = n3;
                        documentCommand.text = stringBuffer.toString();
                    }
                }
                catch (BadLocationException badLocationException) {
                    Debug.debug((Throwable)badLocationException);
                }
            } else if (c == '>') {
                try {
                    int n;
                    for (n = documentCommand.offset - 1; n > 0 && (c = iDocument.getChar(n)) != '\"' && c != '\'' && !XMLUtils.isValidNameChar(c); --n) {
                        if (XMLUtils.isSpace(c)) continue;
                        return;
                    }
                    XMLModel xMLModel = this.fEditor.getModel();
                    if (xMLModel != null) {
                        XMLElement xMLElement;
                        this.fPosition.reset();
                        XMLUtils.findNode(xMLModel, n, this.fPosition);
                        if (100 == this.fPosition.nodeType && !(xMLElement = (XMLElement)this.fPosition.node).isEmptyTag() && xMLElement.getEndTagRegion() == null && this.valid(xMLElement, n)) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(documentCommand.text);
                            stringBuffer.append("</");
                            stringBuffer.append(xMLElement.getName());
                            stringBuffer.append('>');
                            documentCommand.shiftsCaret = false;
                            documentCommand.caretOffset = documentCommand.offset + 1;
                            documentCommand.text = stringBuffer.toString();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    Debug.debug((Throwable)badLocationException);
                }
            }
        }
    }

    protected boolean valid(XMLElement xMLElement, int n) {
        int n2;
        int n3 = xMLElement.getStartTagRegion().getStart();
        if (n < n3 + (n2 = xMLElement.getName().length())) {
            return false;
        }
        int n4 = xMLElement.getAttrCount();
        if (n4 > 0) {
            XMLAttr xMLAttr = xMLElement.getAttrs()[n4 - 1];
            INodeRegion iNodeRegion = xMLAttr.getValueRegion();
            if (iNodeRegion == null) {
                return false;
            }
            if (n < iNodeRegion.getEnd() + n3 - 1) {
                return false;
            }
        }
        return true;
    }

    protected int getTabSize() {
        int n = -1;
        IPreferenceStore iPreferenceStore = XMLAutoIndentStrategy.getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("tab.default");
        if (!bl) {
            n = StringUtils.toInt((String)iPreferenceStore.getString("tab.size"), (int)-1);
        }
        if (n < 0) {
            n = iPreferenceStore.getInt("tabWidth");
        }
        return n;
    }
}

