/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.internal.text;

import com.spket.ui.internal.UIImages;
import com.spket.ui.text.CompletionProposalComparator;
import com.spket.ui.text.EncodedTemplateContext;
import com.spket.ui.text.TemplateCompletionProposal;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import com.spket.xml.INodeRegion;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLConstants;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import com.spket.xml.grammars.CMAttribute;
import com.spket.xml.grammars.CMContainer;
import com.spket.xml.grammars.CMElement;
import com.spket.xml.grammars.CMNamedNodeMap;
import com.spket.xml.grammars.CMNode;
import com.spket.xml.grammars.GrammarManager;
import com.spket.xml.internal.XMLImages;
import com.spket.xml.internal.text.XMLCompletionProposal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.xerces.util.ShadowedSymbolTable;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class XMLCompletionProcessor
implements IContentAssistProcessor {
    protected static final int M_NONE = 0;
    protected static final int M_FILE = 1;
    protected static final int M_TAG = 2;
    protected static final int M_TAG_CLOSING = 3;
    protected static final int M_ATTR = 4;
    protected static final int M_ATTR_VALUE = 5;
    protected static final char[] NAMESPACE_TRIGGER = new char[]{':'};
    protected static final char[] ATTR_TRIGGER = new char[]{'\"', '\'', ' '};
    protected static final char[] ELEM_TRIGGER = new char[]{'<', ':', ' ', '/'};
    protected static final ICompletionProposal[] EMPTY_PROPOSALS = new ICompletionProposal[0];
    protected static final Comparator fgProposalComparator = new CompletionProposalComparator(true);
    protected int fOffset;
    protected int fLength;
    protected char[] fPrefix;
    protected ITextViewer fViewer;
    protected XMLModel fModel;
    protected GrammarManager fGrammar;
    protected XMLAttr fAttr;
    protected int fProposalMode;
    protected PositionInfo fPositionInfo;
    protected NamespaceContext fNamespaceContext;
    private char[] autoActivationCharacters = null;

    public XMLCompletionProcessor(XMLModel xMLModel) {
        this.fModel = xMLModel;
        this.fGrammar = this.fModel.getGrammar();
        this.fPositionInfo = new PositionInfo();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        this.reset();
        this.fViewer = iTextViewer;
        this.fOffset = n;
        this.prepare();
        int n2 = this.determineProposalMode(this.fViewer.getDocument(), this.fOffset, this.getPrefix());
        ICompletionProposal[] iCompletionProposalArray = this.determineProposals(n2);
        ICompletionProposal[] iCompletionProposalArray2 = this.determineTemplateProposals(n2);
        return this.mergeProposals(iCompletionProposalArray, iCompletionProposalArray2);
    }

    public void setActivationCharacters(char[] cArray) {
        this.autoActivationCharacters = cArray;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationCharacters;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    protected void reset() {
        this.fOffset = -1;
        this.fProposalMode = -1;
        this.fLength = 0;
        this.fAttr = null;
        this.fPrefix = null;
        this.fNamespaceContext = null;
        this.fPositionInfo.reset();
    }

    protected void prepare() {
        Point point = this.fViewer.getSelectedRange();
        if (point != null && point.x != -1 && point.y > 0) {
            this.fLength = point.y;
        }
        XMLUtils.findNode(this.fModel, this.fOffset, this.fPositionInfo);
    }

    protected char getCharAt(int n) {
        IDocument iDocument;
        char c = '\u0000';
        if (n >= 0 && n < (iDocument = this.fViewer.getDocument()).getLength()) {
            try {
                c = iDocument.getChar(n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return c;
    }

    protected char[] getPrefix() {
        if (this.fPrefix != null) {
            return this.fPrefix;
        }
        this.fPrefix = this.extractPrefix(this.fViewer, this.fOffset);
        return this.fPrefix;
    }

    protected char[] extractPrefix(ITextViewer iTextViewer, int n) {
        IDocument iDocument = iTextViewer.getDocument();
        if (n > iDocument.getLength()) {
            return StringUtils.EMPTY_CHARS;
        }
        try {
            String string;
            char c;
            int n2;
            for (n2 = n; n2 > 0 && (c = iDocument.getChar(n2 - 1)) != '$' && (Character.isJavaIdentifierPart(c) || c == '.' || c == '-' || c == ':'); --n2) {
            }
            if (n != n2 && (string = iDocument.get(n2, n - n2)) != null) {
                return string.toCharArray();
            }
        }
        catch (BadLocationException badLocationException) {
            Debug.error((Throwable)badLocationException);
        }
        return StringUtils.EMPTY_CHARS;
    }

    protected NamespaceContext getNamespaceContext() {
        if (this.fNamespaceContext == null) {
            SymbolTable symbolTable = this.fModel.getSymbolTable();
            if (symbolTable != null) {
                symbolTable = new ShadowedSymbolTable(symbolTable);
            }
            this.fNamespaceContext = XMLUtils.getNamespaceContext(this.fPositionInfo.node, symbolTable, null);
        }
        return this.fNamespaceContext;
    }

    protected XMLAttr findAttr(XMLElement xMLElement, int n) {
        int n2 = xMLElement.getAttrCount();
        if (n2 > 0) {
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            for (int i = 0; i < n2; ++i) {
                XMLAttr xMLAttr = xMLAttrArray[i];
                if (xMLAttr.contains(n) != 0) continue;
                return xMLAttr;
            }
        }
        return null;
    }

    protected int determineProposalMode(IDocument iDocument, int n, char[] cArray) {
        if (this.fProposalMode != -1) {
            return this.fProposalMode;
        }
        int n2 = iDocument.getLength();
        XMLNode xMLNode = this.fPositionInfo.node;
        if (n2 == 0 || n2 == 1 || xMLNode == null || xMLNode.getNodeType() == 0) {
            return 1;
        }
        int n3 = 0;
        switch (this.fPositionInfo.nodeType) {
            case 100: {
                XMLElement xMLElement = (XMLElement)xMLNode;
                INodeRegion iNodeRegion = xMLElement.getStartTagRegion();
                if (iNodeRegion.getStart() == this.fOffset) {
                    n3 = 2;
                    this.fPositionInfo.node = xMLNode.getParent();
                    this.fPositionInfo.nodeType = 3;
                    if (this.fOffset <= 1) break;
                    IDocument iDocument2 = this.fViewer.getDocument();
                    String string = null;
                    try {
                        string = iDocument2.get(this.fOffset - 2, 2);
                    }
                    catch (BadLocationException badLocationException) {
                        return 0;
                    }
                    if (!"</".equals(string)) break;
                    n3 = 3;
                    break;
                }
                int n4 = iNodeRegion.getEnd() - 1;
                if (n4 == this.fOffset && xMLElement.isEmptyTag() && this.getCharAt(n4 - 1) == '/') break;
                String string = xMLNode.getName();
                if (this.fOffset - iNodeRegion.getStart() <= string.length() + 1) {
                    n3 = 2;
                    break;
                }
                n4 = this.fOffset - iNodeRegion.getStart();
                this.fAttr = this.findAttr(xMLElement, n4);
                if (this.fAttr == null) {
                    n3 = 4;
                    break;
                }
                iNodeRegion = this.fAttr.getNameRegion();
                if (iNodeRegion.contains(n4) == 0) {
                    n3 = 4;
                    break;
                }
                iNodeRegion = this.fAttr.getValueRegion();
                if (iNodeRegion == null) {
                    if (this.fAttr.getEqualOffset() <= 0 || n4 <= this.fAttr.getEqualOffset()) break;
                    n3 = 5;
                    break;
                }
                if (iNodeRegion.contains(n4) != 0) break;
                n3 = 5;
                break;
            }
            case 101: {
                XMLElement xMLElement = (XMLElement)xMLNode;
                INodeRegion iNodeRegion = xMLElement.getEndTagRegion();
                if (iNodeRegion.getStart() == this.fOffset) {
                    n3 = 2;
                    this.fPositionInfo.nodeType = 3;
                    if (xMLElement.hasStartTag()) break;
                    this.fPositionInfo.node = xMLElement.getParent();
                    break;
                }
                int n5 = this.fOffset - cArray.length - 1;
                char c = this.getCharAt(n5);
                if (c != '/' && !XMLUtils.isValidNameStartChar(c)) break;
                n3 = 3;
                break;
            }
            case 1: 
            case 3: {
                n3 = 2;
                if (this.fOffset <= 1) break;
                IDocument iDocument3 = this.fViewer.getDocument();
                String string = null;
                try {
                    string = iDocument3.get(this.fOffset - 2, 2);
                }
                catch (BadLocationException badLocationException) {
                    return 0;
                }
                if (!"</".equals(string)) break;
                n3 = 3;
            }
        }
        return n3;
    }

    protected Set getAttrs(XMLNode xMLNode, CMNode cMNode) {
        HashSet<String> hashSet = null;
        if (xMLNode != null && xMLNode.getNodeType() == 1) {
            XMLAttr[] xMLAttrArray;
            XMLElement xMLElement = (XMLElement)xMLNode;
            int n = xMLElement.getAttrCount();
            if (n > 0) {
                hashSet = new HashSet<String>(n);
                xMLAttrArray = xMLElement.getAttrs();
                for (int i = 0; i < n; ++i) {
                    hashSet.add(xMLAttrArray[i].getName());
                }
            }
            xMLAttrArray = null;
            if (cMNode != null) {
                xMLAttrArray = cMNode.getDocument();
            }
            if (xMLAttrArray != null && Boolean.TRUE.equals(xMLAttrArray.getProperty(CMNode.USING_TAG_AS_ATTRIBUTE)) && (n = xMLElement.getChildrenCount()) > 0) {
                if (hashSet == null) {
                    hashSet = new HashSet(n);
                }
                XMLNode[] xMLNodeArray = xMLElement.getChildren();
                for (int i = 0; i < n; ++i) {
                    XMLNode xMLNode2 = xMLNodeArray[i];
                    if (xMLNode2.getNodeType() != 1) continue;
                    hashSet.add(xMLNode2.getName());
                }
            }
        }
        return hashSet == null ? Collections.EMPTY_SET : hashSet;
    }

    protected ICompletionProposal[] getAttributeProposals(char[] cArray) {
        Object object;
        Enumeration enumeration;
        int n;
        int n2;
        Object object2;
        Object object3;
        XMLNode xMLNode = this.fPositionInfo.node;
        if (xMLNode == null || xMLNode.getNodeType() != 1) {
            return EMPTY_PROPOSALS;
        }
        String string = null;
        ArrayList<Object> arrayList = null;
        CMElement cMElement = null;
        CMNamedNodeMap cMNamedNodeMap = null;
        String string2 = xMLNode.getNamespace();
        NamespaceContext namespaceContext = this.getNamespaceContext();
        int n3 = StringUtils.indexOf((char)':', (char[])cArray, (int)0);
        if (n3 > 0) {
            string = new String(cArray, 0, n3);
            object3 = namespaceContext.getURI(string);
            if (object3 != null) {
                if (((String)object3).equals(string2)) {
                    cMElement = this.fGrammar.getElementDeclaration((XMLElement)xMLNode);
                    if (cMElement != null) {
                        cMNamedNodeMap = cMElement.getAttributes();
                    }
                } else {
                    object2 = this.fGrammar.getCMDocument((String)object3);
                    if (object2 != null) {
                        cMNamedNodeMap = object2.getAttributes();
                    }
                }
            }
        } else {
            cMElement = this.fGrammar.getElementDeclaration((XMLElement)xMLNode);
            if (cMElement != null) {
                cMNamedNodeMap = cMElement.getAttributes();
            }
        }
        if (cMNamedNodeMap != null && cMNamedNodeMap.size() > 0) {
            object3 = null;
            object2 = cMNamedNodeMap.iterator();
            arrayList = new ArrayList(cMNamedNodeMap.size());
            n2 = this.fOffset - cArray.length;
            n = cArray.length + this.fLength;
            if (n2 > 0 && !XMLUtils.isSpace(this.getCharAt(n2 - 1))) {
                object3 = " ";
            }
            enumeration = null;
            object = this.getAttrs(xMLNode, cMElement);
            while (object2.hasNext()) {
                String string3;
                CMAttribute cMAttribute = (CMAttribute)object2.next();
                String string4 = cMAttribute.getAttrName();
                String string5 = cMAttribute.getNamespace();
                if (string5 == null || string5.equals(string2)) {
                    if (string != null && string4.indexOf(58) == -1) {
                        string4 = string + ':' + string4;
                    }
                } else {
                    string3 = namespaceContext.getPrefix(string5);
                    if (string3 == null) continue;
                    string4 = string3 + ':' + string4;
                }
                if (object.contains(string4) || !StringUtils.startsWith((String)string4, (char[])cArray, (boolean)false)) continue;
                string3 = string4 + "=\"\"";
                if (object3 != null) {
                    string3 = (String)object3 + string3;
                }
                XMLCompletionProposal xMLCompletionProposal = new XMLCompletionProposal(n2, n, string3.length() - 1, string3, string4, (Image)enumeration);
                xMLCompletionProposal.setTriggerCharacters(ATTR_TRIGGER);
                arrayList.add(xMLCompletionProposal);
            }
        }
        if (namespaceContext.getDeclaredPrefixCount() > 2) {
            if (arrayList == null) {
                arrayList = new ArrayList<Object>(4);
            }
            int n4 = this.fOffset - cArray.length;
            n2 = cArray.length + this.fLength;
            n = n4 > 0 && !XMLUtils.isSpace(this.getCharAt(n4 - 1)) ? 1 : 0;
            enumeration = namespaceContext.getAllPrefixes();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (((String)object).length() == 0 || XMLConstants.PREFIX_XML.equals(object) || XMLConstants.PREFIX_XMLNS.equals(object) || !StringUtils.startsWith((String)object, (char[])cArray, (boolean)false)) continue;
                object = (String)object + ':';
                object3 = n != 0 ? new XMLCompletionProposal(n4, n2 + this.fLength, ((String)object).length() + 1, ' ' + (String)object, (String)object, null) : new XMLCompletionProposal(n4, n2 + this.fLength, (String)object, null);
                ((XMLCompletionProposal)object3).setTriggerCharacters(NAMESPACE_TRIGGER);
                arrayList.add(object3);
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return EMPTY_PROPOSALS;
        }
        object3 = new ICompletionProposal[arrayList.size()];
        arrayList.toArray((T[])object3);
        return object3;
    }

    protected ICompletionProposal[] getAttributeValueProposals(String[] stringArray, char[] cArray, Image image) {
        int n = cArray.length + this.fLength;
        int n2 = this.fOffset - cArray.length;
        int n3 = 0;
        ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (!StringUtils.startsWith((String)stringArray[i], (char[])cArray, (boolean)false)) continue;
            iCompletionProposalArray[n3++] = new XMLCompletionProposal(n2, n, stringArray[i], image);
        }
        if (n3 == stringArray.length) {
            return iCompletionProposalArray;
        }
        ICompletionProposal[] iCompletionProposalArray2 = new ICompletionProposal[n3];
        System.arraycopy(iCompletionProposalArray, 0, iCompletionProposalArray2, 0, n3);
        return iCompletionProposalArray2;
    }

    protected ICompletionProposal[] getAttributeValueProposals(char[] cArray) {
        if (this.fAttr == null) {
            return EMPTY_PROPOSALS;
        }
        String[] stringArray = null;
        String string = this.fAttr.getName();
        String string2 = this.fAttr.getPrefix();
        if (XMLConstants.PREFIX_XMLNS.equals(string)) {
            Collection collection = this.fGrammar.getNamespaces();
            if (collection != null && collection.size() > 0) {
                stringArray = new String[collection.size()];
                collection.toArray(stringArray);
            }
        } else if (XMLConstants.PREFIX_XMLNS.equals(string2)) {
            String string3 = this.fGrammar.getDefaultNamespace(this.fAttr.getLocalName());
            if (string3 == null) {
                stringArray = new String[]{string3};
            } else {
                Collection collection = this.fGrammar.getNamespaces();
                if (collection != null && collection.size() > 0) {
                    stringArray = new String[collection.size()];
                    collection.toArray(stringArray);
                }
            }
        } else {
            String string4;
            Object object;
            Object object2;
            CMContainer cMContainer = null;
            CMNamedNodeMap cMNamedNodeMap = null;
            XMLElement xMLElement = (XMLElement)this.fPositionInfo.node;
            if (string2 == null) {
                cMContainer = this.fGrammar.getElementDeclaration(xMLElement);
            } else {
                object2 = this.getNamespaceContext();
                object = object2.getURI(string2);
                if (object != null) {
                    cMContainer = ((String)object).equals(xMLElement.getNamespace()) ? this.fGrammar.getElementDeclaration(xMLElement) : this.fGrammar.getCMDocument((String)object);
                }
            }
            if (cMContainer != null) {
                cMNamedNodeMap = cMContainer.getAttributes();
            }
            if (cMNamedNodeMap != null && (object2 = string2 == null ? (CMAttribute)cMNamedNodeMap.getNamedItem(string) : (CMAttribute)cMNamedNodeMap.getNamedItem(this.fAttr.getLocalName())) != null && (object = object2.getAttrType()) != null && ((stringArray = object.getEnumeratedValues()) == null || stringArray.length == 0) && (string4 = object.getDefaultValue()) != null) {
                stringArray = new String[]{string4};
            }
        }
        if (stringArray == null || stringArray.length == 0) {
            return EMPTY_PROPOSALS;
        }
        return this.getAttributeValueProposals(stringArray, cArray, null);
    }

    protected List addElementProposals(CMContainer cMContainer, char[] cArray, boolean bl) {
        if (cMContainer == null) {
            return Collections.EMPTY_LIST;
        }
        CMNamedNodeMap cMNamedNodeMap = null;
        if (cMContainer != null && (cMNamedNodeMap = cMContainer.getElements()).size() == 0 && (cMContainer = cMContainer.getDocument()) != null) {
            cMNamedNodeMap = cMContainer.getElements();
        }
        return null;
    }

    protected ICompletionProposal[] getElementProposals(char[] cArray, boolean bl) {
        CMNamedNodeMap cMNamedNodeMap;
        Object object;
        Object object2;
        Object object3;
        Image image;
        Object object4;
        ArrayList<Object> arrayList = null;
        int n = this.fOffset - cArray.length;
        int n2 = cArray.length + this.fLength;
        if (n > 0 && this.getCharAt(n - 1) == '<') {
            --n;
            ++n2;
        }
        String string = null;
        CMContainer cMContainer = null;
        CMNamedNodeMap cMNamedNodeMap2 = null;
        XMLNode xMLNode = this.fPositionInfo.node;
        NamespaceContext namespaceContext = this.getNamespaceContext();
        int n3 = StringUtils.indexOf((char)':', (char[])cArray, (int)0);
        if (100 == this.fPositionInfo.nodeType && xMLNode != null) {
            xMLNode = xMLNode.getParent();
        }
        if (n3 == -1) {
            if (xMLNode == null || 1 != xMLNode.getNodeType()) {
                cMContainer = this.fGrammar.getCMDocument(xMLNode);
            } else {
                cMContainer = this.fGrammar.getNodeDeclaration(xMLNode.getNamespace(), xMLNode);
                if (cMContainer == null) {
                    object4 = namespaceContext.getURI(XMLConstants.EMPTY_STRING);
                    if (object4 != null && !object4.equals(xMLNode.getNamespace())) {
                        cMContainer = this.fGrammar.getNodeDeclaration((String)object4, xMLNode);
                    }
                } else {
                    string = xMLNode.getPrefix();
                }
            }
        } else {
            string = new String(cArray, 0, n3);
            object4 = namespaceContext.getURI(string);
            if (object4 == null) {
                object4 = this.fGrammar.getDefaultNamespace(string);
            }
            if (object4 != null) {
                cMContainer = this.fGrammar.getNodeDeclaration((String)object4, xMLNode);
            }
        }
        if (cMContainer != null && (cMNamedNodeMap2 = cMContainer.getElements()).size() == 0 && (cMContainer = cMContainer.getDocument()) != null) {
            cMNamedNodeMap2 = cMContainer.getElements();
        }
        if (cMNamedNodeMap2 != null && cMNamedNodeMap2.size() > 0) {
            object4 = cMNamedNodeMap2.iterator();
            int n4 = n3 + 1;
            arrayList = new ArrayList<Object>(cMNamedNodeMap2.size());
            image = XMLImages.get("_mime.tag.gif");
            while (object4.hasNext()) {
                object3 = (CMNode)object4.next();
                object2 = object3.getNodeName();
                if (!StringUtils.startsWith((String)object2, (char[])cArray, (int)n4, (boolean)false)) continue;
                if (string != null) {
                    object2 = string + ':' + (String)object2;
                }
                object = new XMLCompletionProposal(n, n2, (String)object2, image, false, null);
                ((XMLCompletionProposal)object).setTriggerCharacters(ELEM_TRIGGER);
                arrayList.add(object);
            }
        }
        if (cMContainer instanceof CMElement && (object4 = cMContainer.getDocument()) != null && Boolean.TRUE.equals(object4.getProperty(CMNode.USING_TAG_AS_ATTRIBUTE)) && (cMNamedNodeMap = cMContainer.getAttributes()) != null && cMNamedNodeMap.size() > 0) {
            object3 = this.getAttrs(xMLNode, (CMNode)object4);
            object2 = cMNamedNodeMap.iterator();
            image = XMLImages.get("_mime.attr.gif");
            if (arrayList == null) {
                arrayList = new ArrayList(cMNamedNodeMap.size());
            }
            while (object2.hasNext()) {
                object = (CMAttribute)object2.next();
                String string2 = object.getAttrName();
                if (object3.contains(string2) || !StringUtils.startsWith((String)string2, (char[])cArray, (boolean)false)) continue;
                XMLCompletionProposal xMLCompletionProposal = new XMLCompletionProposal(n, n2, string2, image, false, null);
                xMLCompletionProposal.setTriggerCharacters(ELEM_TRIGGER);
                arrayList.add(xMLCompletionProposal);
            }
        }
        if (n3 == -1 && namespaceContext.getDeclaredPrefixCount() > 2) {
            object4 = namespaceContext.getAllPrefixes();
            image = XMLImages.get("_mime.namespace.gif");
            while (object4.hasMoreElements()) {
                String string3 = (String)object4.nextElement();
                if (string3.length() == 0 || XMLConstants.PREFIX_XML.equals(string3) || XMLConstants.PREFIX_XMLNS.equals(string3) || !StringUtils.startsWith((String)string3, (char[])cArray, (boolean)false) || string != null && string.equals(string3)) continue;
                string3 = bl ? string3 + ':' : '<' + string3 + ':';
                object3 = new XMLCompletionProposal(n, n2, string3, image);
                ((XMLCompletionProposal)object3).setTriggerCharacters(NAMESPACE_TRIGGER);
                arrayList.add(object3);
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return EMPTY_PROPOSALS;
        }
        object4 = new ICompletionProposal[arrayList.size()];
        arrayList.toArray((T[])object4);
        return object4;
    }

    protected ICompletionProposal[] getClosingElementProposal(char[] cArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        XMLNode xMLNode = this.fPositionInfo.node;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = this.fOffset - cArray.length - 2;
        int n2 = cArray.length + this.fLength + 2;
        Image image = XMLImages.get("_mime.emptytag.gif");
        if (xMLNode != null && xMLNode.getNodeType() == 1) {
            object4 = xMLNode.getName();
            if (this.fPositionInfo.nodeType == 101 && (xMLNode = xMLNode.getParent()) != null && xMLNode.getNodeType() == 1) {
                object4 = xMLNode.getName();
            }
            if (StringUtils.startsWith((String)object4, (char[])cArray, (boolean)false)) {
                object3 = "</" + (String)object4 + '>';
                object2 = new XMLCompletionProposal(n, n2, (String)object3, image);
                ((XMLCompletionProposal)object2).setTriggerCharacters(ELEM_TRIGGER);
                arrayList.add(object2);
            }
        }
        if (arrayList.size() == 0) {
            object4 = this.getNamespaceContext();
            int n3 = StringUtils.indexOf((char)':', (char[])cArray, (int)0);
            object2 = XMLConstants.EMPTY_STRING;
            if (n3 != -1) {
                object2 = new String(cArray, 0, n3);
            }
            if ((object = object4.getURI((String)object2)) != null) {
                char[] cArray2 = n3 == -1 ? cArray : StringUtils.subarray((char[])cArray, (int)(n3 + 1), (int)cArray.length);
                CMNamedNodeMap cMNamedNodeMap = null;
                CMContainer cMContainer = this.fGrammar.getNodeDeclaration((String)object, xMLNode);
                if (cMContainer != null && (cMNamedNodeMap = cMContainer.getElements()).size() == 0 && (cMContainer = cMContainer.getDocument()) != null) {
                    cMNamedNodeMap = cMContainer.getElements();
                }
                if (cMNamedNodeMap != null && cMNamedNodeMap.size() > 0) {
                    Iterator iterator = cMNamedNodeMap.iterator();
                    while (iterator.hasNext()) {
                        CMNode cMNode = (CMNode)iterator.next();
                        if (!StringUtils.startsWith((String)cMNode.getNodeName(), (char[])cArray2, (boolean)false)) continue;
                        String string = "</";
                        if (((String)object2).length() > 0) {
                            string = string + (String)object2 + ':';
                        }
                        string = string + cMNode.getNodeName() + '>';
                        XMLCompletionProposal xMLCompletionProposal = new XMLCompletionProposal(n, n2, string, image);
                        xMLCompletionProposal.setTriggerCharacters(ELEM_TRIGGER);
                        arrayList.add(xMLCompletionProposal);
                    }
                }
            }
        }
        if (arrayList.size() == 0 && (object4 = this.getNamespaceContext()).getDeclaredPrefixCount() > 2) {
            object3 = object4.getAllPrefixes();
            image = XMLImages.get("_mime.namespace.gif");
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                if (((String)object2).length() == 0 || XMLConstants.PREFIX_XML.equals(object2) || XMLConstants.PREFIX_XMLNS.equals(object2) || !StringUtils.startsWith((String)object2, (char[])cArray, (boolean)false)) continue;
                object2 = "</" + (String)object2 + ':';
                object = new XMLCompletionProposal(n, n2, (String)object2, image);
                ((XMLCompletionProposal)object).setTriggerCharacters(NAMESPACE_TRIGGER);
                arrayList.add(object);
            }
        }
        if (arrayList.size() == 0) {
            return EMPTY_PROPOSALS;
        }
        object4 = new ICompletionProposal[arrayList.size()];
        arrayList.toArray((T[])object4);
        return object4;
    }

    protected ICompletionProposal[] mergeProposals(ICompletionProposal[] iCompletionProposalArray, ICompletionProposal[] iCompletionProposalArray2) {
        if (iCompletionProposalArray == null || iCompletionProposalArray.length == 0) {
            return iCompletionProposalArray2 != null ? iCompletionProposalArray2 : EMPTY_PROPOSALS;
        }
        if (iCompletionProposalArray2 == null || iCompletionProposalArray2.length == 0) {
            return iCompletionProposalArray;
        }
        ICompletionProposal[] iCompletionProposalArray3 = new ICompletionProposal[iCompletionProposalArray.length + iCompletionProposalArray2.length];
        System.arraycopy(iCompletionProposalArray, 0, iCompletionProposalArray3, 0, iCompletionProposalArray.length);
        System.arraycopy(iCompletionProposalArray2, 0, iCompletionProposalArray3, iCompletionProposalArray.length, iCompletionProposalArray2.length);
        return iCompletionProposalArray3;
    }

    protected ICompletionProposal[] determineProposals(int n) {
        char[] cArray = this.getPrefix();
        ICompletionProposal[] iCompletionProposalArray = null;
        if (cArray.length == 0 || cArray.length > 0 && cArray[0] != ':') {
            switch (n) {
                case 4: {
                    iCompletionProposalArray = this.getAttributeProposals(cArray);
                    break;
                }
                case 1: 
                case 2: {
                    iCompletionProposalArray = this.getElementProposals(cArray, false);
                    break;
                }
                case 5: {
                    iCompletionProposalArray = this.getAttributeValueProposals(cArray);
                    break;
                }
                case 3: {
                    iCompletionProposalArray = this.getClosingElementProposal(cArray);
                }
            }
        }
        if (iCompletionProposalArray != null && iCompletionProposalArray.length > 0) {
            Arrays.sort(iCompletionProposalArray, new CompletionProposalComparator());
        }
        return iCompletionProposalArray;
    }

    protected ICompletionProposal[] determineTemplateProposals(int n) {
        if (n == 4 || n == 5) {
            return null;
        }
        char[] cArray = this.getPrefix();
        Region region = new Region(this.fOffset - cArray.length, this.fLength + cArray.length);
        TemplateContext templateContext = this.createContext(this.fViewer, (IRegion)region);
        if (templateContext != null) {
            Object object;
            String string = templateContext.getContextType().getId();
            Template[] templateArray = this.fModel.getTemplates(string);
            if (templateArray == null || templateArray.length == 0) {
                return null;
            }
            if (this.fLength > 0) {
                object = null;
                try {
                    object = this.fViewer.getDocument().get(this.fOffset, this.fLength);
                }
                catch (BadLocationException badLocationException) {
                    Debug.debug((Throwable)badLocationException);
                }
                templateContext.setVariable("selection", (String)object);
            }
            if ((object = this.fModel.getProject()) != null) {
                templateContext.setVariable("project", object.getName());
            }
            ArrayList<ICompletionProposal> arrayList = new ArrayList<ICompletionProposal>();
            Image image = UIImages.getImage((String)"template_obj.gif");
            for (int i = 0; i < templateArray.length; ++i) {
                Template template = templateArray[i];
                if (!template.matches(null, string) || !StringUtils.startsWith((String)template.getName(), (char[])cArray, (boolean)false) || !templateContext.canEvaluate(template)) continue;
                arrayList.add(this.createProposal(template, templateContext, (IRegion)region, image, 0));
            }
            if (arrayList.size() > 0) {
                ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[arrayList.size()];
                arrayList.toArray(iCompletionProposalArray);
                Arrays.sort(iCompletionProposalArray, fgProposalComparator);
                return iCompletionProposalArray;
            }
        }
        return null;
    }

    protected TemplateContext createContext(ITextViewer iTextViewer, IRegion iRegion) {
        TemplateContextType templateContextType = this.fModel.getContextType(this.fPositionInfo);
        if (templateContextType != null) {
            IDocument iDocument = iTextViewer.getDocument();
            return new EncodedTemplateContext(templateContextType, iDocument, iRegion.getOffset(), iRegion.getLength());
        }
        return null;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext templateContext, IRegion iRegion, Image image, int n) {
        return new TemplateCompletionProposal(template, templateContext, iRegion, image, 0);
    }
}

