/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xml.internal.text;

import com.spket.ui.text.IFoldingSupport;
import com.spket.util.Debug;
import com.spket.util.IntStack;
import com.spket.xml.INodeRegion;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.internal.XMLPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;

public class XMLFoldingSupport
implements IFoldingSupport {
    private static final int T_COMMENT = 1;
    private static final int T_CDATA = 2;
    private static final int T_PI = 4;
    private static final Annotation[] EMTPY_ANN = new Annotation[0];
    private int fLineSpace;
    private boolean fChanged;
    private boolean fProjectionEnabled;
    private IProjectionListener fProjectionListener;
    protected XMLModel fModel;
    protected ProjectionViewer fViewer;

    protected static int getFoldType(int n) {
        switch (n) {
            case 5: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 7: {
                return 4;
            }
        }
        return 0;
    }

    public XMLFoldingSupport(XMLModel xMLModel) {
        this.fModel = xMLModel;
    }

    public void install(ProjectionViewer projectionViewer) {
        this.fViewer = projectionViewer;
        if (this.fProjectionListener == null) {
            this.fProjectionListener = new IProjectionListener(){

                public void projectionDisabled() {
                    XMLFoldingSupport.this.onProjectionDisabled();
                }

                public void projectionEnabled() {
                    XMLFoldingSupport.this.onProjectionEnabled();
                }
            };
        }
        this.fViewer.addProjectionListener(this.fProjectionListener);
    }

    public void uninstall() {
        if (this.fViewer != null) {
            if (this.fProjectionListener != null) {
                this.fViewer.removeProjectionListener(this.fProjectionListener);
            }
            this.fViewer = null;
        }
        this.fProjectionListener = null;
    }

    public void reconcile() {
        this.process(0);
    }

    public int affects(String string) {
        if ("xml_folding".equals(string)) {
            return 1;
        }
        return 0;
    }

    public void configure(IPreferenceStore iPreferenceStore, boolean bl) {
    }

    protected void onProjectionDisabled() {
        this.fProjectionEnabled = false;
    }

    protected void onProjectionEnabled() {
        this.fProjectionEnabled = true;
        this.initialize();
    }

    protected void initialize() {
        if (this.fProjectionEnabled) {
            int n = 0;
            IPreferenceStore iPreferenceStore = XMLPlugin.getDefault().getPreferenceStore();
            if (iPreferenceStore.getBoolean("xml_fld_cmt")) {
                n |= 1;
            }
            if (iPreferenceStore.getBoolean("xml_fld_cdata")) {
                n |= 2;
            }
            if (iPreferenceStore.getBoolean("xml_fld_pi")) {
                n |= 4;
            }
            this.process(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(int n) {
        if (!this.fProjectionEnabled || this.fViewer == null || this.fModel == null) {
            return;
        }
        XMLFoldingSupport xMLFoldingSupport = this;
        synchronized (xMLFoldingSupport) {
            this.fChanged = false;
        }
        xMLFoldingSupport = this.fViewer.getProjectionAnnotationModel();
        if (this.fChanged || xMLFoldingSupport == null) {
            return;
        }
        XMLDocument xMLDocument = this.fModel.getXMLDocument();
        if (xMLDocument == null || xMLDocument.getChildrenCount() == 0) {
            xMLFoldingSupport.removeAllAnnotations();
            return;
        }
        Set set = Collections.EMPTY_SET;
        try {
            set = this.folding(xMLDocument);
        }
        catch (BadLocationException badLocationException) {
            Debug.debug((Throwable)badLocationException);
            return;
        }
        if (this.fChanged) {
            return;
        }
        if (set.size() == 0) {
            xMLFoldingSupport.removeAllAnnotations();
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.match((ProjectionAnnotationModel)xMLFoldingSupport, set, arrayList);
        if (!(this.fChanged || set.size() <= 0 && arrayList.size() <= 0)) {
            Annotation[] annotationArray = EMTPY_ANN;
            HashMap<XMLProjectionAnnotation, Position> hashMap = Collections.EMPTY_MAP;
            if (set.size() > 0) {
                hashMap = new HashMap<XMLProjectionAnnotation, Position>(set.size());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    hashMap.put(new XMLProjectionAnnotation(pair.type, (pair.type & n) != 0), pair.position);
                }
            }
            if (!this.fChanged) {
                if (arrayList.size() > 0) {
                    annotationArray = new Annotation[arrayList.size()];
                    arrayList.toArray(annotationArray);
                }
                if (!this.fChanged) {
                    xMLFoldingSupport.modifyAnnotations(annotationArray, hashMap, EMTPY_ANN);
                }
            }
        }
    }

    protected void match(ProjectionAnnotationModel projectionAnnotationModel, Set set, List list) {
        Iterator iterator = projectionAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof XMLProjectionAnnotation)) continue;
            XMLProjectionAnnotation xMLProjectionAnnotation = (XMLProjectionAnnotation)((Object)e);
            Position position = projectionAnnotationModel.getPosition((Annotation)xMLProjectionAnnotation);
            Pair pair = new Pair(xMLProjectionAnnotation.getFoldingType(), position);
            if (set.remove(pair)) continue;
            list.add(e);
        }
    }

    protected Set folding(XMLNode xMLNode) throws BadLocationException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        XMLNode xMLNode2 = xMLNode;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        IntStack intStack = new IntStack();
        IntStack intStack2 = new IntStack();
        int n8 = Math.max(1, this.fLineSpace);
        IDocument iDocument = this.fViewer.getDocument();
        int n9 = iDocument.getNumberOfLines() - 1;
        int n10 = iDocument.getLength();
        if (n10 > 0) {
            n10 = iDocument.getLineOfOffset(n10);
            if (n8 > 1) {
                n10 /= n8;
            }
            n10 >>= 2;
        }
        n10 = Math.max(4, n10);
        HashSet<Pair> hashSet = new HashSet<Pair>(n10);
        int n11 = -1;
        block0: while (xMLNode2 != null && !this.fChanged) {
            int n12;
            INodeRegion iNodeRegion;
            if (n3 == 0 && xMLNode2.getNodeType() == 1) {
                iNodeRegion = ((XMLElement)xMLNode2).getStartTagRegion();
                n4 = iNodeRegion.getStart();
                n6 = iDocument.getLineOfOffset(n4);
                if (n6 > n5) {
                    n5 = n6;
                    intStack2.push(n6);
                } else {
                    intStack2.push(n11);
                }
            }
            if ((n2 = xMLNode2.getChildrenCount()) > 0) {
                XMLNode[] xMLNodeArray = xMLNode2.getChildren();
                for (n = n3; n < n2; ++n) {
                    XMLElement xMLElement;
                    if (this.fChanged) break block0;
                    XMLNode xMLNode3 = xMLNodeArray[n];
                    if (xMLNode3.getNodeType() == 1 && !(xMLElement = (XMLElement)xMLNode3).isEmptyTag()) {
                        if (!xMLElement.hasStartTag()) continue;
                        if (xMLElement.getChildrenCount() > 0) {
                            n3 = 0;
                            xMLNode2 = xMLNode3;
                            intStack.push(n + 1);
                            continue block0;
                        }
                    }
                    if ((n6 = iDocument.getLineOfOffset((iNodeRegion = xMLNode3.getRegion()).getStart())) <= n5 || (n7 = iDocument.getLineOfOffset(iNodeRegion.getEnd())) - n6 < n8) continue;
                    n4 = iDocument.getLineOffset(n6);
                    n12 = n7 < n9 ? iDocument.getLineOffset(n7 + 1) : iDocument.getLength();
                    Position position = new Position(n4, n12 - n4);
                    hashSet.add(new Pair(XMLFoldingSupport.getFoldType(xMLNode3.getNodeType()), position));
                    n5 = n7;
                }
            }
            if (xMLNode2.getNodeType() == 1) {
                n6 = intStack2.pop();
                iNodeRegion = ((XMLElement)xMLNode2).getEndTagRegion();
                if (n6 != -1) {
                    if (iNodeRegion != null) {
                        n7 = iDocument.getLineOfOffset(iNodeRegion.getEnd());
                        if (n7 - n6 >= n8) {
                            if (arrayList.size() > 0) {
                                n = n7 - 1;
                                int n13 = iDocument.getLineOffset(n7);
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    n12 = (Integer)arrayList.get(i);
                                    if (n - n12 < n8) continue;
                                    n4 = iDocument.getLineOffset(n12);
                                    hashSet.add(new Pair(new Position(n4, n13 - n4)));
                                }
                                arrayList.clear();
                            }
                            n4 = iDocument.getLineOffset(n6);
                            int n14 = n7 < n9 ? iDocument.getLineOffset(n7 + 1) : iDocument.getLength();
                            hashSet.add(new Pair(new Position(n4, n14 - n4)));
                            n5 = n7;
                        } else {
                            arrayList.clear();
                        }
                    } else {
                        arrayList.add(new Integer(n6));
                        n5 = n6;
                    }
                }
            }
            if (intStack.size() == 0) break;
            xMLNode2 = xMLNode2.getParent();
            n3 = intStack.pop();
        }
        if (arrayList.size() > 0) {
            n7 = n9;
            n2 = iDocument.getLineOffset(n7);
            for (int i = 0; i < arrayList.size(); ++i) {
                n = (Integer)arrayList.get(i);
                if (n7 - n < n8) continue;
                n4 = iDocument.getLineOffset(n);
                hashSet.add(new Pair(new Position(n4, n2 - n4)));
            }
            arrayList.clear();
        }
        return hashSet;
    }

    private static final class XMLProjectionAnnotation
    extends ProjectionAnnotation {
        private int fType;

        public XMLProjectionAnnotation(int n, boolean bl) {
            super(bl);
            this.fType = n;
        }

        public int getFoldingType() {
            return this.fType;
        }
    }

    private static class Pair {
        public int type;
        public Position position;

        public Pair(Position position) {
            this.position = position;
        }

        public Pair(int n, Position position) {
            this.type = n;
            this.position = position;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                return this.type == pair.type && this.position.equals((Object)pair.position);
            }
            return false;
        }

        public int hashCode() {
            return this.type << 30 | this.position.hashCode();
        }
    }
}

