/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.theme;

import com.spket.ui.theme.TabbedPane;
import com.spket.widget.CItem;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.presentations.IPresentablePart;

public class EditorPane
extends TabbedPane {
    public static final String DIRTY_PREFIX = "*";

    public EditorPane(Composite composite, int n) {
        super(composite, n);
        this.showTitle = false;
        this.tabPosition = 128;
    }

    protected boolean alwaysShowTab() {
        return true;
    }

    protected Point getMinimumSize() {
        int n = 28;
        if (this.buttons.length > 0) {
            n += this.buttons.length * 16;
        }
        return new Point(n, this.getTabHeight());
    }

    protected void layoutTabs(GC gC, Rectangle rectangle) {
        String string;
        Rectangle rectangle2;
        int n;
        int n2;
        int n3;
        int n4 = 0;
        if (this.current != null) {
            n4 = this.parts.indexOf(this.current);
        }
        int n5 = this.size();
        this.tabs = new CItem[n5];
        int n6 = n3 = this.getTabWidth(rectangle);
        for (n2 = 0; n2 < n5; ++n2) {
            this.tabs[n2] = this.createItem(this.getPart(n2));
        }
        n2 = 0;
        for (n = n4; n < n5; ++n) {
            rectangle2 = this.tabs[n].getBounds(false);
            string = this.tabs[n].getText();
            if (string != null) {
                rectangle2.width = gC.stringExtent((String)string).x;
            }
            if (this.tabs[n].getImage() != null) {
                rectangle2.width += 18;
            }
            rectangle2.width += 6;
            if (rectangle2.width > n6) {
                rectangle2.width = 0;
                break;
            }
            ++n2;
            n6 -= rectangle2.width;
        }
        if (n2 == 0 && n6 > 0 && n5 > 0) {
            this.tabs[n4].getBounds((boolean)false).width = n3;
        } else if (n6 > 0 && n4 > 0) {
            for (n = n4 - 1; n >= 0; --n) {
                rectangle2 = this.tabs[n].getBounds(false);
                string = this.tabs[n].getText();
                if (string != null) {
                    rectangle2.width = gC.stringExtent((String)string).x;
                }
                if (this.tabs[n].getImage() != null) {
                    rectangle2.width += 18;
                }
                rectangle2.width += 6;
                if (rectangle2.width > n6) {
                    rectangle2.width = 0;
                    break;
                }
                n6 -= rectangle2.width;
            }
        }
        n = rectangle.x + 4;
        int n7 = 0;
        int n8 = this.getTabHeight();
        n7 = this.tabPosition == 128 ? rectangle.y : rectangle.y + rectangle.height - n8;
        for (int i = 0; i < n5; ++i) {
            rectangle2 = this.tabs[i].getBounds(false);
            if (rectangle2.width == 0) continue;
            rectangle2.x = n;
            rectangle2.y = n7;
            rectangle2.height = n8;
            n += rectangle2.width;
        }
    }

    protected void drawEmptyArea(GC gC, int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            gC.setBackground(this.borderColor);
            gC.fillRectangle(n, n2, n3, n4);
            gC.setForeground(this.borderLightColor);
            if (n3 < 3 || n4 < 3) {
                gC.setBackground(this.getBackground());
                gC.fillRectangle(n + 1, n2 + 1, n3 - 2, n4 - 2);
            } else {
                gC.setForeground(this.getBackground());
                gC.drawRectangle(n + 1, n2 + 1, n3 - 3, n4 - 3);
            }
        }
    }

    protected CItem createItem(IPresentablePart iPresentablePart) {
        String string = iPresentablePart.getName();
        if (iPresentablePart.isDirty()) {
            string = DIRTY_PREFIX + string;
        }
        CItem cItem = new CItem(string);
        cItem.setImage(iPresentablePart.getTitleImage());
        cItem.setData(iPresentablePart);
        return cItem;
    }

    protected void onMenuButtonClicked(Event event) {
        Point point = this.getPaneMenuLocation();
        this.fireEvent(11, this.current, point.x, point.y);
    }

    protected void resetButtons() {
        if (this.size() > 0) {
            if (this.buttons == EMPTY_ITEMS) {
                this.setFlag(8, true);
                this.buttons = new CItem[2];
                CItem cItem = new CItem(2);
                cItem.setText("Active Files");
                this.buttons[0] = cItem;
                cItem = new CItem(1);
                cItem.setText("Close");
                this.buttons[1] = cItem;
            }
        } else {
            this.buttons = EMPTY_ITEMS;
        }
    }
}

