/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ywt.model;

import com.spket.ywt.model.YWTConstants;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.util.SymbolTable;

public class YWTHelper
implements YWTConstants {
    private static final String[] tags;
    private static final String[] attrs;
    private static Map tagMap;
    private static Map attrMap;

    public static Integer getTagID(String string) {
        if (string == null) {
            return null;
        }
        return (Integer)tagMap.get(string);
    }

    public static int getTagId(String string) {
        Integer n = YWTHelper.getTagID(string);
        return n == null ? Integer.MIN_VALUE : n;
    }

    public static String getTagName(int n) {
        if (n > 0 && n <= tags.length) {
            return tags[n - 1];
        }
        return null;
    }

    public static Integer getAttrID(String string) {
        if (string == null) {
            return null;
        }
        return (Integer)attrMap.get(string);
    }

    public static int getAttrId(String string) {
        Integer n = YWTHelper.getAttrID(string);
        return n == null ? Integer.MIN_VALUE : n;
    }

    public static String getAttrName(int n) {
        if (n > 0 && n <= attrs.length) {
            return attrs[n - 1];
        }
        return null;
    }

    public static void initSymbolTable(SymbolTable symbolTable) {
        int n;
        for (n = 0; n < tags.length; ++n) {
            symbolTable.addSymbol(tags[n]);
        }
        for (n = 0; n < attrs.length; ++n) {
            symbolTable.addSymbol(attrs[n]);
        }
    }

    static {
        int n;
        tags = new String[]{"about-box", "about-image", "about-text", "about-version", "action", "api", "contextMenuItems", "extension", "frame", "hotkey", "image", "menuItem", "option", "optionValue", "preference", "preferenceGroup", "scrollbar", "security", "shadow", "text", "textarea", "timer", "widget", "window"};
        attrs = new String[]{"alignment", "author", "autoHide", "bgColor", "bgOpacity", "checked", "clipRect", "color", "colorize", "colour", "columns", "company", "copyright", "data", "debug", "defaultTracking", "defaultValue", "description", "directory", "editable", "enabled", "file", "fillMode", "font", "group", "hAlign", "hLineSize", "hOffset", "hRegistrationPoint", "hScrollBar", "height", "hidden", "hslAdjustment", "hslTinting", "icon", "image", "interval", "key", "kind", "level", "lines", "loadingSrc", "max", "maxLength", "min", "minLength", "minimumVersion", "missingSrc", "modifier", "name", "notSaved", "onContextMenu", "onDragDrop", "onDragEnter", "onDragExit", "onFirstDisplay", "onGainFocus", "onImageLoaded", "onKeyDown", "onKeyPress", "onKeyUp", "onLoseFocus", "onMouseDown", "onMouseEnter", "onMouseExit", "onMouseMove", "onMouseUp", "onMouseWheel", "onMultiClick", "onSelect", "onTimerFired", "onValueChanged", "opacity", "option", "order", "orientation", "pageSize", "remoteAsync", "requiredPlatform", "rotation", "scrollX", "scrollY", "scrollbar", "secure", "shadow", "size", "spellcheck", "src", "srcHeight", "srcWidth", "style", "thumbColor", "tickLabel", "ticking", "ticks", "tileOrigin", "title", "tooltip", "tracking", "trigger", "truncation", "type", "url", "useFileIcon", "vAlign", "vLineSize", "vOffset", "vRegistrationPoint", "vScrollBar", "value", "version", "visible", "width", "window", "zOrder"};
        tagMap = new HashMap(tags.length);
        attrMap = new HashMap(attrs.length);
        for (n = 0; n < tags.length; ++n) {
            tagMap.put(tags[n], new Integer(n + 1));
        }
        for (n = 0; n < attrs.length; ++n) {
            attrMap.put(attrs[n], new Integer(n + 1));
        }
    }
}

