/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xpc.model;

import com.spket.js.model.ISlot;
import com.spket.js.model.JSObject;
import com.spket.js.model.NativeFunction;
import com.spket.js.model.ObjectImpl;
import com.spket.js.model.Slot;
import com.spket.js.model.SlotWrapper;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import com.spket.xpc.model.CID;
import com.spket.xpc.model.Typelib;
import com.spket.xpc.model.XPClass;
import com.spket.xpc.model.XPFolder;
import com.spket.xpc.model.XPInstance;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TypelibReader
implements ContentHandler {
    private static final String T_CLASS = "class";
    private static final String T_CID = "cid";
    private static final String T_FIELD = "field";
    private static final String T_METHOD = "method";
    private static final String T_RESULTS = "results";
    private static final String T_COMMENT = "comment";
    private static final String T_FOLDER = "folder";
    private static final String T_FILES = "files";
    private static final String A_ID = "id";
    private static final String A_NAME = "name";
    private static final String A_FILE = "file";
    private static final String A_VALUE = "value";
    private static final String T_PARAM = "param";
    private static final String A_EXTENDS = "extends";
    private static final String A_FLAGS = "flags";
    private static final String A_TYPE = "type";
    private static final String A_INTERFACE = "interface";
    private static final String[] MISSING_FIELDS = new String[]{"lastResult", "returnCode"};
    private Typelib typelib;
    ObjectImpl components;
    private XPClass xpClass;
    private ISlot slot;
    private ISlot clsSlot;
    private NativeFunction method;
    private int count;
    private boolean hasContent;
    private char[] buf = new char[5120];
    private Map ids = new HashMap(1228);
    private Map iids = new HashMap(1228);
    private Map cids = new HashMap(800);
    private Map ciids = new HashMap(800);
    private Map results = new HashMap(128);
    private Map supers = new HashMap(1228);
    private XPFolder parent;
    private Stack fs = new Stack();
    private List folders = new ArrayList();

    public TypelibReader(Typelib typelib) {
        this.typelib = typelib;
        this.components = new ObjectImpl("_XPCOM_");
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.hasContent) {
            if (this.count + n2 >= this.buf.length) {
                char[] cArray2 = new char[this.count + n2];
                System.arraycopy(this.buf, 0, cArray2, 0, this.count);
                this.buf = cArray2;
            }
            System.arraycopy(cArray, n, this.buf, this.count, n2);
            this.count += n2;
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        JSObject jSObject;
        Map map;
        Map[] mapArray;
        JSObject jSObject2;
        String[] stringArray;
        if (this.supers.size() > 0) {
            stringArray = this.supers.entrySet().iterator();
            jSObject2 = this.components.getProperty("nsISupports");
            while (stringArray.hasNext()) {
                Map.Entry entry = stringArray.next();
                String string = (String)entry.getValue();
                mapArray = this.components.getProperty(string);
                map = this.components.getProperty((String)entry.getKey());
                if (mapArray != null) {
                    map.setPrototype((JSObject)mapArray);
                    continue;
                }
                map.setParentScope(jSObject2);
                Debug.warn((String)string);
            }
        }
        if ((jSObject = this.components.getProperty("nsIXPCComponents")) instanceof XPClass) {
            this.xpClass = (XPClass)jSObject;
            map = this.xpClass.properties;
            mapArray = new Map[]{this.ids, this.iids, this.cids, this.ciids, this.results};
            if (map != null && map.size() > 0) {
                stringArray = Typelib.FIELDS;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string;
                    this.slot = (ISlot)map.get(stringArray[i]);
                    if (this.slot == null || (string = (String)this.slot.getData((Object)ISlot.P_TYPE)) == null || !((jSObject = this.components.getProperty(string)) instanceof XPClass)) continue;
                    ((XPClass)jSObject).setInstanceProperties(mapArray[i]);
                }
            }
            for (int i = 0; i < MISSING_FIELDS.length; ++i) {
                if (map != null && map.containsKey(MISSING_FIELDS[i])) continue;
                this.slot = new Slot();
                this.xpClass.defineProperty(MISSING_FIELDS[i], this.slot);
                this.slot.setData((Object)ISlot.P_TYPE, (Object)"Number");
            }
            jSObject = this.components.getProperty("nsIJSCID");
            if (jSObject instanceof XPClass && (jSObject = ((XPClass)jSObject).construct(this.typelib, (JSObject)this.components, null)) != null) {
                Iterator iterator = this.cids.values().iterator();
                while (iterator.hasNext()) {
                    this.slot = (ISlot)iterator.next();
                    this.slot.setObject(jSObject);
                }
            }
            if ((jSObject = this.components.getProperty("nsIJSIID")) instanceof XPClass) {
                this.xpClass = (XPClass)jSObject;
                Iterator iterator = this.ids.values().iterator();
                while (iterator.hasNext()) {
                    jSObject2 = (SlotWrapper)iterator.next();
                    jSObject = new XPInstance(this.xpClass, jSObject2.getPrototype());
                    jSObject.setParentScope((JSObject)this.components);
                    jSObject2.setObject(jSObject);
                }
            }
        }
        this.typelib.ids = this.ids;
        this.typelib.cids = this.cids;
        this.typelib.results = this.results;
        this.typelib.folders = this.folders;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (T_CLASS.equals(string3)) {
            String string4;
            this.clsSlot = this.slot = new Slot();
            SlotWrapper slotWrapper = new SlotWrapper(this.slot);
            String string5 = attributes.getValue(A_NAME);
            this.ids.put(string5, slotWrapper);
            this.xpClass = new XPClass(string5);
            this.slot.setObject((JSObject)this.xpClass);
            this.xpClass.setParentScope((JSObject)this.components);
            this.components.defineProperty(string5, (Object)this.slot);
            String string6 = attributes.getValue(A_EXTENDS);
            if (string6 != null) {
                this.supers.put(string5, string6);
            }
            if ((string4 = attributes.getValue(A_ID)) != null) {
                this.slot.setData((Object)ISlot.P_VALUE, (Object)string4);
                this.iids.put(string4, slotWrapper);
            }
            if ((string4 = attributes.getValue(A_FILE)) != null) {
                this.slot.setData((Object)ISlot.P_SOURCE, (Object)string4);
            }
        } else if (T_FIELD.equals(string3)) {
            this.slot = new Slot();
            String string7 = attributes.getValue(A_NAME);
            this.slot.setData((Object)ISlot.P_TYPE, (Object)attributes.getValue(A_TYPE));
            this.slot.setFlags(StringUtils.toInt((String)attributes.getValue(A_FLAGS)));
            this.slot.setFlag(0x200000, true);
            this.xpClass.defineProperty(string7, this.slot);
        } else if (T_METHOD.equals(string3)) {
            this.slot = new Slot();
            String string8 = attributes.getValue(A_NAME);
            String string9 = attributes.getValue(A_TYPE);
            this.method = new NativeFunction(string8);
            this.method.setValue((Object)string9);
            this.slot.setObject((JSObject)this.method);
            this.method.setParentScope((JSObject)this.components);
            this.slot.setData((Object)ISlot.P_TYPE, (Object)string9);
            this.slot.setFlags(StringUtils.toInt((String)attributes.getValue(A_FLAGS)));
            this.slot.setFlag(0x200000, true);
            this.xpClass.defineProperty(string8, this.slot);
        } else if (T_PARAM.equals(string3)) {
            this.method.addParameter(attributes.getValue(A_NAME), attributes.getValue(A_TYPE), StringUtils.toInt((String)attributes.getValue(A_FLAGS)));
        } else if (T_COMMENT.equals(string3)) {
            this.count = 0;
            this.hasContent = true;
        } else if (T_CID.equals(string3)) {
            this.slot = new Slot();
            CID cID = new CID();
            cID.id = attributes.getValue(A_ID);
            cID.name = attributes.getValue(A_NAME);
            String string10 = attributes.getValue(A_INTERFACE);
            if (string10 != null) {
                cID.interfaces = StringUtils.split((String)string10, (char)',', (boolean)false);
            }
            this.slot.setData((Object)ISlot.P_VALUE, (Object)cID);
            this.slot.setFlag(0x200000, true);
            this.cids.put(cID.name, this.slot);
            this.ciids.put(cID.id, this.slot);
        } else if (T_RESULTS.equals(string3)) {
            this.slot = new Slot();
            String string11 = attributes.getValue(A_NAME);
            this.slot.setFlag(0x200000, true);
            this.slot.setData((Object)ISlot.P_VALUE, (Object)new Integer(StringUtils.toInt((String)attributes.getValue(A_VALUE))));
            this.results.put(string11, this.slot);
        } else if (T_FOLDER.equals(string3)) {
            XPFolder xPFolder = new XPFolder();
            xPFolder.setName(attributes.getValue(A_NAME));
            if (this.parent == null) {
                this.folders.add(xPFolder);
            } else {
                this.fs.push(this.parent);
                this.parent.addFolder(xPFolder);
            }
            this.parent = xPFolder;
        } else if (T_FILES.equals(string3)) {
            this.count = 0;
            this.hasContent = true;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (T_METHOD.equals(string3) || T_FIELD.equals(string3)) {
            this.slot = this.clsSlot;
        } else if (T_COMMENT.equals(string3)) {
            this.hasContent = false;
            if (this.count > 0) {
                this.slot.setData((Object)ISlot.P_COMMENT, (Object)new String(this.buf, 0, this.count));
            }
        } else if (T_FILES.equals(string3)) {
            this.hasContent = false;
            if (this.count > 0) {
                this.parent.addFiles(StringUtils.split((String)new String(this.buf, 0, this.count), (char)','));
            }
        } else if (T_FOLDER.equals(string3)) {
            this.parent = this.fs.size() > 0 ? (XPFolder)this.fs.pop() : null;
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(URL uRL) throws ParserConfigurationException, SAXException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            this.parse(inputStream);
            Object var4_3 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Debug.warn((Throwable)iOException);
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            Debug.warn((Throwable)iOException);
        }
    }

    public void parse(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        xMLReader.setContentHandler(this);
        xMLReader.parse(new InputSource(inputStream));
    }
}

