/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xpc.wizards;

import com.spket.ui.internal.UIImages;
import com.spket.util.ByteArrayBuffer;
import com.spket.xpc.internal.XPCMessages;
import com.spket.xpc.internal.XPCPlugin;
import com.spket.xpc.wizards.NewExtensionProjectPage;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.osgi.framework.Bundle;

public class NewProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IProject newProject;
    private Map properties;
    private IWorkbench workbench;
    private IConfigurationElement configElement;
    private NewExtensionProjectPage mainPage;

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        this.configElement = iConfigurationElement;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(XPCMessages.New_Extension_title);
        this.workbench = iWorkbench;
        this.setDefaultPageImageDescriptor(UIImages.getImageDescriptor((String)"com.spket.js.xpc", (int)6, (String)"newfprj_wiz.png"));
    }

    public void addPages() {
        this.mainPage = new NewExtensionProjectPage("page1");
        this.mainPage.setTitle(XPCMessages.New_Extension_title);
        this.mainPage.setDescription(XPCMessages.New_Extension_desc);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IProject iProject;
        if (this.properties == null) {
            this.properties = new HashMap();
        } else {
            this.properties.clear();
        }
        this.properties.put("appName", this.mainPage.getProjectName());
        String string = System.getProperty("user.name");
        if (string != null) {
            this.properties.put("creator", string);
        }
        if ((string = this.mainPage.getFirefoxDirectory()) != null) {
            this.properties.put("ff.dir", string);
        }
        if ((iProject = this.createNewProject()) == null) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        this.selectAndReveal((IResource)iProject);
        return true;
    }

    protected void selectAndReveal(IResource iResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)iResource, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject iProject = this.mainPage.getProjectHandle();
        URI uRI = null;
        if (!this.mainPage.useDefaults()) {
            uRI = this.mainPage.getLocationURI();
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
        iProjectDescription.setLocationURI(uRI);
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                NewProjectWizard.this.createProject(iProjectDescription, iProject, iProgressMonitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof CoreException) {
                if (((CoreException)throwable).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)iProject.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, null, (IStatus)((CoreException)throwable).getStatus());
                }
            } else {
                XPCPlugin.log(throwable);
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_internalError, (Object)throwable.getMessage()));
            }
            return null;
        }
        this.newProject = iProject;
        return this.newProject;
    }

    private void createProject(IProjectDescription iProjectDescription, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        try {
            iProgressMonitor.beginTask("", 1000);
            iProject.create(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            iProject.open(128, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            Bundle bundle = XPCPlugin.getDefault().getBundle();
            this.copy(bundle, (IContainer)iProject, "/config/exts/", iProgressMonitor);
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "com.spket.js.xpc", 4, iOException.getLocalizedMessage(), (Throwable)iOException));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(Bundle bundle, IContainer iContainer, String string, IProgressMonitor iProgressMonitor) throws CoreException, IOException {
        Enumeration enumeration = bundle.getEntryPaths(string);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                URL uRL;
                String string2 = (String)enumeration.nextElement();
                Path path = new Path(string2);
                String string3 = this.convert(path.lastSegment());
                if (!Path.ROOT.isValidSegment(string3)) {
                    throw new IOException("File name not valid: " + string3);
                }
                if (path.hasTrailingSeparator()) {
                    uRL = iContainer.getFolder((IPath)new Path(string3));
                    if (!uRL.exists()) {
                        uRL.create(true, true, iProgressMonitor);
                    }
                    this.copy(bundle, (IContainer)uRL, string2, iProgressMonitor);
                    continue;
                }
                uRL = bundle.getEntry(string2);
                if (uRL == null) {
                    throw new FileNotFoundException(string2);
                }
                InputStream inputStream = null;
                try {
                    inputStream = uRL.openStream();
                    InputStream inputStream2 = this.convert(inputStream);
                    if (inputStream2 == null) continue;
                    IFile iFile = iContainer.getFile((IPath)new Path(string3));
                    if (iFile.exists()) {
                        iFile.setContents(inputStream2, true, true, iProgressMonitor);
                        continue;
                    }
                    iFile.create(inputStream2, true, iProgressMonitor);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
        }
    }

    protected InputStream convert(InputStream inputStream) throws IOException {
        Appendable appendable;
        int n;
        char c = '\u0000';
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[8192];
        Stack<StringBuffer> stack = new Stack<StringBuffer>();
        StringBuffer stringBuffer = new StringBuffer(8192);
        while ((n = inputStreamReader.read(cArray)) != -1) {
            block6: for (int i = 0; i < n; ++i) {
                char c2 = cArray[i];
                switch (c2) {
                    case '#': {
                        if (c == '#') {
                            c = '\u0000';
                            stringBuffer.append('#');
                            continue block6;
                        }
                        c = c2;
                        continue block6;
                    }
                    case '{': {
                        if (c == '#') {
                            stack.push(stringBuffer);
                            stringBuffer = new StringBuffer();
                        } else {
                            stringBuffer.append(c2);
                        }
                        c = '\u0000';
                        continue block6;
                    }
                    case '}': {
                        if (stack.size() > 0) {
                            Object v;
                            appendable = stringBuffer;
                            stringBuffer = (StringBuffer)stack.pop();
                            if (((StringBuffer)appendable).length() > 0 && (v = this.properties.get(((StringBuffer)appendable).toString())) != null) {
                                stringBuffer.append(v.toString());
                            }
                        } else {
                            stringBuffer.append(c2);
                        }
                        c = '\u0000';
                        continue block6;
                    }
                    default: {
                        if (c == '#') {
                            stringBuffer.append('#');
                        }
                        c = '\u0000';
                        stringBuffer.append(c2);
                    }
                }
            }
        }
        while (!stack.isEmpty()) {
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer = (StringBuffer)stack.pop();
            if (stringBuffer2.length() <= 0 || (appendable = this.properties.get(stringBuffer2.toString())) == null) continue;
            stringBuffer.append(appendable.toString());
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(8192);
        appendable = new OutputStreamWriter((OutputStream)byteArrayBuffer);
        ((Writer)appendable).write(stringBuffer.toString());
        ((OutputStreamWriter)appendable).flush();
        return new ByteArrayInputStream(byteArrayBuffer.toByteArray(), 0, byteArrayBuffer.size());
    }

    protected String convert(String string) {
        int n = string.indexOf(36);
        if (n == -1) {
            return string;
        }
        n = -1;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '$') {
                if (bl) {
                    if (i > n) {
                        Object v = this.properties.get(string.substring(n, i));
                        if (v != null) {
                            stringBuffer.append(v.toString());
                        }
                    } else {
                        stringBuffer.append('$');
                    }
                    bl = false;
                    continue;
                }
                bl = true;
                n = i + 1;
                continue;
            }
            if (bl) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

