/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model;

import com.spket.buffer.BufferChangedEvent;
import com.spket.buffer.BufferManager;
import com.spket.buffer.IBuffer;
import com.spket.buffer.IBufferListener;
import com.spket.wpfe.model.EventHandler;
import com.spket.wpfe.model.WPFEHelper;
import com.spket.xml.DOMModel;
import com.spket.xml.IDOMModel;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class XAMLManager {
    private static final int F_ERROR = 1;
    private static final int F_WORKING = 2;
    private static final String EXT_JS = ".js";
    private static final String EXT_XAML = ".xaml";
    private static XAMLManager gManager;
    private static BufferManager gBufferManager;
    private Map states = new HashMap();

    public static XAMLManager getDefault() {
        if (gManager == null) {
            gManager = new XAMLManager();
        }
        return gManager;
    }

    private XAMLManager() {
    }

    public IDOMModel getModel(IPath iPath) {
        State state = this.getState(iPath, true);
        if (state != null) {
            if (state.model == null && state.status == 0) {
                IBuffer iBuffer = gBufferManager.getBuffer(iPath);
                if (iBuffer == null) {
                    state.status = 1;
                } else {
                    state.model = (IDOMModel)new DOMModel(iPath, iBuffer);
                }
            }
            return state.model;
        }
        return null;
    }

    public void becomeWorkingCopy(XMLModel xMLModel) {
        if (xMLModel == null) {
            return;
        }
        IPath iPath = xMLModel.getPath();
        if (iPath == null) {
            return;
        }
        State state = this.getState(iPath, true);
        if (state != null) {
            state.model = (IDOMModel)xMLModel;
            state.status = 2;
            IBuffer iBuffer = xMLModel.getBuffer();
            if (iBuffer != null) {
                iBuffer.addBufferListener((IBufferListener)state);
            }
        }
    }

    public void releaseWorkingCopy(XMLModel xMLModel) {
        if (xMLModel == null) {
            return;
        }
        IPath iPath = xMLModel.getPath();
        if (iPath == null) {
            return;
        }
        State state = this.getState(iPath, false);
        if (state != null) {
            state.status = 0;
            this.states.remove(iPath);
            IBuffer iBuffer = xMLModel.getBuffer();
            if (iBuffer != null) {
                iBuffer.removeBufferListener((IBufferListener)state);
            }
        }
    }

    protected State getState(IPath iPath, boolean bl) {
        State state = (State)this.states.get(iPath);
        if (state == null) {
            IPath iPath2 = gBufferManager.resolve(iPath);
            if (iPath2 != iPath) {
                iPath = iPath2;
                state = (State)this.states.get(iPath);
            }
            if (state == null && bl) {
                state = new State();
                state.path = iPath;
                this.states.put(iPath, state);
            }
        }
        return state;
    }

    public String findName(String string, String string2) {
        State state;
        IPath iPath = this.getXamlPath(string);
        if (iPath != null && (state = this.getState(iPath, false)) != null) {
            this.prepared(state);
            if (state.names != null) {
                return (String)state.names.get(string2);
            }
        }
        return null;
    }

    public EventHandler findEventHandler(String string, String string2) {
        State state;
        IPath iPath = this.getXamlPath(string);
        if (iPath != null && (state = this.getState(iPath, true)) != null) {
            this.prepared(state);
            if (state.events != null) {
                return (EventHandler)state.events.get(string2);
            }
        }
        return null;
    }

    protected void prepared(State state) {
        if (state.names == null) {
            XMLElement xMLElement;
            XMLDocument xMLDocument;
            IDOMModel iDOMModel = this.getModel(state.path);
            if (iDOMModel != null && (xMLDocument = iDOMModel.getXMLDocument()) != null && (xMLElement = xMLDocument.getDocumentElement()) != null) {
                state.names = new HashMap();
                state.events = new HashMap();
                this.visit(state, xMLElement);
            }
            if (state.names == null || state.names.size() == 0) {
                state.names = Collections.EMPTY_MAP;
            }
            if (state.events == null || state.events.size() == 0) {
                state.events = Collections.EMPTY_MAP;
            }
        }
    }

    protected IPath getXamlPath(String string) {
        if (string.endsWith(EXT_JS)) {
            Path path = (string = string.substring(0, string.length() - EXT_JS.length())).endsWith(EXT_XAML) ? new Path(string) : new Path(string + EXT_XAML);
            return path;
        }
        return null;
    }

    protected void visit(State state, XMLElement xMLElement) {
        Object object;
        int n = xMLElement.getAttrCount();
        if (n > 0) {
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            block3: for (int i = 0; i < n; ++i) {
                XMLAttr xMLAttr = xMLAttrArray[i];
                String string = xMLAttr.getName();
                if ("x:Name".equals(string)) {
                    object = XMLUtils.getValue((XMLAttr)xMLAttr);
                    if (object == null || ((String)object).length() <= 0) continue;
                    state.names.put(object, xMLElement.getLocalName());
                    continue;
                }
                int n2 = WPFEHelper.getAttrId(string);
                switch (n2) {
                    case 13: 
                    case 27: 
                    case 30: 
                    case 34: 
                    case 36: 
                    case 56: 
                    case 60: 
                    case 71: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 85: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: {
                        EventHandler eventHandler;
                        object = XMLUtils.getValue((XMLAttr)xMLAttr);
                        if (object == null || ((String)object).length() <= 0 || (eventHandler = (EventHandler)state.events.get(object)) != null) continue block3;
                        eventHandler = new EventHandler(n2, xMLElement.getLocalName());
                        state.events.put(object, eventHandler);
                    }
                }
            }
        }
        if ((n = xMLElement.getChildrenCount()) > 0) {
            object = xMLElement.getChildren();
            for (int i = 0; i < n; ++i) {
                XMLNode xMLNode = object[i];
                if (1 != xMLNode.getNodeType()) continue;
                this.visit(state, (XMLElement)xMLNode);
            }
        }
    }

    static {
        gBufferManager = BufferManager.getDefault();
    }

    private class State
    implements IBufferListener {
        private int status;
        private IPath path;
        private IDOMModel model;
        private Map names;
        private Map events;

        private State() {
        }

        public void bufferAboutToBeChanged(BufferChangedEvent bufferChangedEvent) {
        }

        public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
            this.clear();
        }

        public void bufferClosed(IBuffer iBuffer) {
            iBuffer.removeBufferListener((IBufferListener)this);
            this.clear();
            if (this.path != null) {
                XAMLManager.this.states.remove(this.path);
                this.path = null;
            }
        }

        protected void clear() {
            if (this.names != null) {
                if (this.names.size() > 0) {
                    this.names.clear();
                }
                this.names = null;
            }
            if (this.events != null) {
                if (this.events.size() > 0) {
                    this.events.clear();
                }
                this.events = null;
            }
        }
    }
}

