/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model.render;

import com.spket.as.internal.compiler.util.HashtableOfInt;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import com.spket.wpfe.model.WPFEHelper;
import com.spket.wpfe.model.render.IRelativeBrush;
import com.spket.wpfe.model.render.RelativeLinearGradientPaint;
import com.spket.wpfe.model.render.RelativeRadialGradientPaint;
import com.spket.wpfe.model.render.TransformHandler;
import com.spket.wpfe.model.render.XAMLHandler;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.apache.batik.ext.awt.MultipleGradientPaint;

public class BrushHandler {
    public static Paint handle(XMLElement xMLElement) {
        int n = xMLElement.getChildrenCount();
        if (n > 0) {
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            block6: for (int i = 0; i < n; ++i) {
                XMLNode xMLNode = xMLNodeArray[i];
                if (1 != xMLNode.getNodeType()) continue;
                int n2 = WPFEHelper.getTagId(xMLNode.getLocalName());
                switch (n2) {
                    case 170: {
                        return BrushHandler.createSolidBrush((XMLElement)xMLNode);
                    }
                    case 91: {
                        return BrushHandler.createLinearGradientBrush((XMLElement)xMLNode);
                    }
                    case 148: {
                        return BrushHandler.createRadialGradientBrush((XMLElement)xMLNode);
                    }
                    case 58: {
                        continue block6;
                    }
                }
            }
        }
        return null;
    }

    public static Paint createSolidBrush(XMLElement xMLElement) {
        Color color;
        String string;
        HashtableOfInt hashtableOfInt;
        int n = xMLElement.getAttrCount();
        if (n > 0 && (hashtableOfInt = XAMLHandler.getAttributes(xMLElement)) != null && (string = (String)hashtableOfInt.get(25)) != null && (color = XAMLHandler.toColor(string)) != null) {
            return XAMLHandler.opacity(color, StringUtils.toFloat((String)((String)hashtableOfInt.get(101)), (float)1.0f));
        }
        return null;
    }

    protected static void setTransform(IRelativeBrush iRelativeBrush, XMLElement xMLElement, HashtableOfInt hashtableOfInt) {
        int n;
        boolean bl = true;
        AffineTransform affineTransform = null;
        if (hashtableOfInt != null) {
            affineTransform = TransformHandler.toTransform((String)hashtableOfInt.get(160));
            if (affineTransform == null) {
                affineTransform = TransformHandler.toTransform((String)hashtableOfInt.get(117));
            } else {
                bl = false;
            }
        }
        if (affineTransform == null && (n = xMLElement.getChildrenCount()) > 0) {
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            int n2 = xMLElement.getLocalName().length();
            for (int i = 0; i < n; ++i) {
                String string;
                XMLNode xMLNode = xMLNodeArray[i];
                if (1 != xMLNode.getNodeType() || (string = xMLNode.getLocalName()).length() <= n2 + 1 || string.charAt(n2) != '.') continue;
                if ("Transform".equals(string = string.substring(n2 + 1))) {
                    bl = false;
                    affineTransform = TransformHandler.handle((XMLElement)xMLNode);
                    break;
                }
                if (!"RelativeTransform".equals(string)) continue;
                affineTransform = TransformHandler.handle((XMLElement)xMLNode);
                break;
            }
        }
        if (affineTransform != null && !affineTransform.isIdentity()) {
            iRelativeBrush.setTransform(affineTransform, bl);
        }
    }

    public static Paint createLinearGradientBrush(XMLElement xMLElement) {
        ColorStop[] colorStopArray;
        HashtableOfInt hashtableOfInt = XAMLHandler.getAttributes(xMLElement);
        float f = 1.0f;
        if (hashtableOfInt != null) {
            f = StringUtils.toFloat((String)((String)hashtableOfInt.get(101)), (float)1.0f);
            if (f > 1.0f) {
                f = 1.0f;
            } else if ((double)f < 0.002) {
                return null;
            }
        }
        if ((colorStopArray = BrushHandler.parseStops(xMLElement)) != null && colorStopArray.length > 1) {
            Point2D point2D = null;
            Point2D point2D2 = null;
            boolean bl = BrushHandler.getRelative(hashtableOfInt);
            if (hashtableOfInt != null) {
                point2D = XAMLHandler.toPoint((String)hashtableOfInt.get(135));
                point2D2 = XAMLHandler.toPoint((String)hashtableOfInt.get(39));
            }
            if (point2D == null) {
                point2D = new Point2D.Double(0.0, 0.0);
            }
            if (point2D2 == null) {
                point2D2 = bl ? new Point2D.Double(1.0, 1.0) : new Point2D.Double(0.0, 0.0);
            }
            if (!point2D.equals(point2D2)) {
                RelativeLinearGradientPaint relativeLinearGradientPaint;
                int n;
                Color[] colorArray = new Color[colorStopArray.length];
                float[] fArray = new float[colorStopArray.length];
                if (f < 1.0f) {
                    for (n = 0; n < colorStopArray.length; ++n) {
                        Color color = colorStopArray[n].color;
                        int n2 = (int)((double)((float)color.getAlpha() * f) + 0.5);
                        colorArray[n] = new Color(color.getRed(), color.getGreen(), color.getBlue(), n2);
                        fArray[n] = colorStopArray[n].offset;
                    }
                } else {
                    for (n = 0; n < colorStopArray.length; ++n) {
                        colorArray[n] = colorStopArray[n].color;
                        fArray[n] = colorStopArray[n].offset;
                    }
                }
                try {
                    relativeLinearGradientPaint = new RelativeLinearGradientPaint(point2D, point2D2, fArray, colorArray, BrushHandler.getCycleMethod(hashtableOfInt), BrushHandler.getColorSpace(hashtableOfInt));
                }
                catch (RuntimeException runtimeException) {
                    Debug.debug((Throwable)runtimeException);
                    return null;
                }
                relativeLinearGradientPaint.setRelative(bl);
                BrushHandler.setTransform(relativeLinearGradientPaint, xMLElement, hashtableOfInt);
                return relativeLinearGradientPaint;
            }
        }
        return null;
    }

    protected static MultipleGradientPaint.ColorSpaceEnum getColorSpace(HashtableOfInt hashtableOfInt) {
        String string;
        if (hashtableOfInt != null && (string = (String)hashtableOfInt.get(26)) != null && "ScRgbLinearInterpolation".equalsIgnoreCase(string)) {
            return MultipleGradientPaint.LINEAR_RGB;
        }
        return MultipleGradientPaint.SRGB;
    }

    protected static boolean getRelative(HashtableOfInt hashtableOfInt) {
        String string;
        if (hashtableOfInt != null && (string = (String)hashtableOfInt.get(83)) != null) {
            return !"Absolute".equalsIgnoreCase(string);
        }
        return true;
    }

    protected static MultipleGradientPaint.CycleMethodEnum getCycleMethod(HashtableOfInt hashtableOfInt) {
        String string;
        if (hashtableOfInt != null && (string = (String)hashtableOfInt.get(134)) != null) {
            if ("Reflect".equals(string)) {
                return MultipleGradientPaint.REFLECT;
            }
            if ("Repeat".equalsIgnoreCase(string)) {
                return MultipleGradientPaint.REPEAT;
            }
        }
        return MultipleGradientPaint.NO_CYCLE;
    }

    public static Paint createRadialGradientBrush(XMLElement xMLElement) {
        ColorStop[] colorStopArray;
        HashtableOfInt hashtableOfInt = XAMLHandler.getAttributes(xMLElement);
        float f = 1.0f;
        if (hashtableOfInt != null) {
            f = StringUtils.toFloat((String)((String)hashtableOfInt.get(101)), (float)1.0f);
            if (f > 1.0f) {
                f = 1.0f;
            } else if ((double)f < 0.002) {
                return null;
            }
        }
        if ((colorStopArray = BrushHandler.parseStops(xMLElement)) != null && colorStopArray.length > 1) {
            float f2;
            boolean bl = BrushHandler.getRelative(hashtableOfInt);
            float f3 = f2 = bl ? 0.5f : 0.0f;
            float f4 = f2;
            Point2D point2D = null;
            Point2D point2D2 = null;
            if (hashtableOfInt != null) {
                point2D = XAMLHandler.toPoint((String)hashtableOfInt.get(19));
                point2D2 = XAMLHandler.toPoint((String)hashtableOfInt.get(57));
                f3 = StringUtils.toFloat((String)((String)hashtableOfInt.get(114)), (float)f2);
                f4 = StringUtils.toFloat((String)((String)hashtableOfInt.get(115)), (float)f2);
            }
            if (point2D == null) {
                point2D = bl ? new Point2D.Double(f2, f2) : new Point2D.Double(0.0, 0.0);
            }
            if (point2D2 == null) {
                point2D2 = point2D;
            }
            if (f3 > 0.0f && f4 > 0.0f) {
                RelativeRadialGradientPaint relativeRadialGradientPaint;
                int n;
                Color[] colorArray = new Color[colorStopArray.length];
                float[] fArray = new float[colorStopArray.length];
                if (f < 1.0f) {
                    for (n = 0; n < colorStopArray.length; ++n) {
                        Color color = colorStopArray[n].color;
                        int n2 = (int)((double)((float)color.getAlpha() * f) + 0.5);
                        colorArray[n] = new Color(color.getRed(), color.getGreen(), color.getBlue(), n2);
                        fArray[n] = colorStopArray[n].offset;
                    }
                } else {
                    for (n = 0; n < colorStopArray.length; ++n) {
                        colorArray[n] = colorStopArray[n].color;
                        fArray[n] = colorStopArray[n].offset;
                    }
                }
                try {
                    relativeRadialGradientPaint = new RelativeRadialGradientPaint(point2D, f3, f4, point2D2, fArray, colorArray, BrushHandler.getCycleMethod(hashtableOfInt), BrushHandler.getColorSpace(hashtableOfInt));
                }
                catch (RuntimeException runtimeException) {
                    Debug.debug((Throwable)runtimeException);
                    return null;
                }
                relativeRadialGradientPaint.setRelative(bl);
                BrushHandler.setTransform(relativeRadialGradientPaint, xMLElement, hashtableOfInt);
                return relativeRadialGradientPaint;
            }
        }
        return null;
    }

    public static Paint createImageBrush(XMLElement xMLElement) {
        return null;
    }

    public static Paint createVideoBrush(XMLElement xMLElement) {
        return null;
    }

    protected static ColorStop[] parseStops(XMLElement xMLElement) {
        int n = xMLElement.getChildrenCount();
        if (n > 0) {
            int n2 = 0;
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            ColorStop[] colorStopArray = new ColorStop[n];
            for (int i = 0; i < n; ++i) {
                XMLNode xMLNode = xMLNodeArray[i];
                if (1 != xMLNode.getNodeType()) continue;
                String string = xMLNode.getLocalName();
                if ("GradientStop".equals(string)) {
                    ColorStop colorStop = BrushHandler.createColorStop((XMLElement)xMLNode);
                    if (colorStop == null) continue;
                    colorStopArray[n2++] = colorStop;
                    continue;
                }
                if ("GradientStopCollection".equals(string)) {
                    return BrushHandler.parseStops((XMLElement)xMLNode);
                }
                int n3 = string.indexOf(46);
                if (n3 <= 0 || !"GradientStops".equals(string.substring(n3 + 1))) continue;
                return BrushHandler.parseStops((XMLElement)xMLNode);
            }
            if (n2 == colorStopArray.length) {
                return colorStopArray;
            }
            if (n2 > 0) {
                ColorStop[] colorStopArray2 = new ColorStop[n2];
                System.arraycopy(colorStopArray, 0, colorStopArray2, 0, n2);
                return colorStopArray2;
            }
        }
        return null;
    }

    protected static ColorStop createColorStop(XMLElement xMLElement) {
        int n = xMLElement.getAttrCount();
        if (n > 0) {
            float f = 0.0f;
            Color color = null;
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            for (int i = 0; i < n; ++i) {
                XMLAttr xMLAttr = xMLAttrArray[i];
                String string = xMLAttr.getName();
                if ("Color".equals(string)) {
                    color = XAMLHandler.toColor(xMLAttr);
                    if (color != null) continue;
                    break;
                }
                if (!"Offset".equals(string)) continue;
                f = StringUtils.toFloat((String)XMLUtils.getValue((XMLAttr)xMLAttr));
            }
            if (color != null) {
                ColorStop colorStop = new ColorStop();
                colorStop.color = color;
                colorStop.offset = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
                return colorStop;
            }
        }
        return null;
    }

    private static class ColorStop {
        public float offset;
        public Color color;

        private ColorStop() {
        }
    }
}

