/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model.render;

import com.spket.wpfe.model.render.UIElement;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class Canvas
extends UIElement {
    private static final UIElement[] NO_CHILDREN = new UIElement[0];
    private int count;
    private UIElement[] children = NO_CHILDREN;
    private Paint background;

    public Paint getBackground() {
        return this.background;
    }

    public void setBackground(Paint paint) {
        this.background = paint;
    }

    public void addChild(UIElement uIElement) {
        if (this.count >= this.children.length) {
            UIElement[] uIElementArray = new UIElement[this.count * 3 / 2 + 1];
            if (this.count > 0) {
                System.arraycopy(this.children, 0, uIElementArray, 0, this.count);
            }
            this.children = uIElementArray;
        }
        this.children[this.count++] = uIElement;
    }

    public Rectangle2D getOriginBounds() {
        return this.getGeometryBounds();
    }

    public Rectangle2D getGeometryBounds() {
        if (this.width > 0.0 && this.height > 0.0) {
            return new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
        }
        return null;
    }

    public Rectangle2D getPrimitiveBounds() {
        if (this.count == 0) {
            if (this.width > 0.0 && this.height > 0.0) {
                return new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
            }
        } else {
            int n = 0;
            RectangularShape rectangularShape = null;
            Rectangle2D rectangle2D = null;
            while (n < this.count) {
                if ((rectangle2D = this.children[n++].getTransformedBounds(IDENTITY)) == null) continue;
                if (rectangularShape == null) {
                    rectangularShape = rectangle2D;
                    continue;
                }
                ((Rectangle2D)rectangularShape).add(rectangle2D);
            }
            if (rectangularShape != null) {
                if (this.width > rectangularShape.getWidth()) {
                    if (this.height > rectangularShape.getHeight()) {
                        ((Rectangle2D)rectangularShape).add(this.width, this.height);
                    } else {
                        ((Rectangle2D)rectangularShape).add(this.width, rectangularShape.getMaxY());
                    }
                } else if (this.height > rectangularShape.getHeight()) {
                    ((Rectangle2D)rectangularShape).add(rectangularShape.getMaxX(), this.height);
                }
            }
            return rectangularShape;
        }
        return null;
    }

    public void primitivePaint(Graphics2D graphics2D) {
        if (this.background != null) {
            double d = this.getWidth();
            double d2 = this.getHeight();
            if (d > 0.0 && d2 > 0.0) {
                Paint paint = graphics2D.getPaint();
                graphics2D.setPaint(this.background);
                graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, d, d2));
                graphics2D.setPaint(paint);
            }
        }
        if (this.count == 0) {
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            this.children[i].paint(graphics2D);
        }
    }
}

