/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model.render;

import com.spket.as.internal.compiler.util.HashtableOfInt;
import com.spket.util.Debug;
import com.spket.util.StringUtils;
import com.spket.wpfe.model.WPFEHelper;
import com.spket.wpfe.model.render.XAMLHandler;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;

public class PathParser {
    private int start;
    private int end;
    private char[] values;
    protected float currentX;
    protected float currentY;
    protected float xCenter;
    protected float yCenter;
    private ExtendedGeneralPath path;

    public Shape parse(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        this.start = 0;
        this.end = string.length();
        this.values = string.toCharArray();
        this.currentX = 0.0f;
        this.currentY = 0.0f;
        this.xCenter = 0.0f;
        this.yCenter = 0.0f;
        this.path = new ExtendedGeneralPath(0);
        try {
            this.skipFillRule();
            this.skipSpaces();
            this.parseCommand();
        }
        catch (RuntimeException runtimeException) {
            Debug.debug((Throwable)runtimeException);
            return null;
        }
        return this.path;
    }

    public Shape parse(XMLElement xMLElement, boolean bl) {
        int n = xMLElement.getChildrenCount();
        if (n > 0) {
            Shape shape = null;
            Shape shape2 = null;
            Path2D path2D = null;
            XMLElement xMLElement2 = null;
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                XMLNode xMLNode = xMLNodeArray[i];
                if (1 != xMLNode.getNodeType()) continue;
                xMLElement2 = (XMLElement)xMLNode;
                int n2 = WPFEHelper.getTagId(xMLNode.getLocalName());
                switch (n2) {
                    case 32: {
                        shape2 = this.createEllipse(xMLElement2);
                        break;
                    }
                    case 86: {
                        shape2 = this.createLine(xMLElement2);
                        break;
                    }
                    case 160: {
                        shape2 = this.createRectangle(xMLElement2);
                        break;
                    }
                    case 40: {
                        shape2 = this.createCompositeShape(xMLElement2);
                        break;
                    }
                    case 121: {
                        shape2 = this.createPath(xMLElement2);
                        break;
                    }
                    case 41: {
                        if (!bl || !"GeometryGroup".equals(xMLElement.getLocalName())) break;
                        shape = null;
                        path2D = null;
                        shape2 = this.parse(xMLElement2, true);
                    }
                }
                if (shape2 == null) continue;
                if (41 != n2) {
                    // empty if block
                }
                if (!bl) break;
                if (path2D == null) {
                    if (shape == null) {
                        shape = shape2;
                        continue;
                    }
                    path2D = new GeneralPath(shape);
                    path2D.append(shape2, false);
                    continue;
                }
                path2D.append(shape2, false);
            }
            return shape2;
        }
        return null;
    }

    protected Shape createRectangle(XMLElement xMLElement) {
        int n = xMLElement.getAttrCount();
        if (n > 0) {
            double[] dArray = null;
            double d = 0.0;
            double d2 = 0.0;
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            block5: for (int i = 0; i < n; ++i) {
                XMLAttr xMLAttr = xMLAttrArray[i];
                int n2 = WPFEHelper.getAttrId(xMLAttr.getName());
                switch (n2) {
                    case 116: {
                        dArray = XAMLHandler.toPoints(xMLAttr);
                        continue block5;
                    }
                    case 114: {
                        d = StringUtils.toDouble((String)XMLUtils.getValue((XMLAttr)xMLAttr));
                        continue block5;
                    }
                    case 115: {
                        d2 = StringUtils.toDouble((String)XMLUtils.getValue((XMLAttr)xMLAttr));
                    }
                }
            }
            if (dArray != null && dArray.length == 4) {
                if (d == 0.0 || d2 == 0.0) {
                    return new Rectangle2D.Double(dArray[0], dArray[1], dArray[2], dArray[3]);
                }
                return new RoundRectangle2D.Double(dArray[0], dArray[1], dArray[2], dArray[3], d * 2.0, d2 * 2.0);
            }
        }
        return null;
    }

    protected Shape createLine(XMLElement xMLElement) {
        int n = xMLElement.getAttrCount();
        if (n > 0) {
            Point2D point2D = null;
            Point2D point2D2 = null;
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            block4: for (int i = 0; i < n; ++i) {
                XMLAttr xMLAttr = xMLAttrArray[i];
                int n2 = WPFEHelper.getAttrId(xMLAttr.getName());
                switch (n2) {
                    case 135: {
                        point2D = XAMLHandler.toPoint(xMLAttr);
                        continue block4;
                    }
                    case 39: {
                        point2D2 = XAMLHandler.toPoint(xMLAttr);
                    }
                }
            }
            if (point2D == null) {
                if (point2D2 == null) {
                    return new Line2D.Double();
                }
                return new Line2D.Double(0.0, 0.0, point2D2.getX(), point2D2.getY());
            }
            if (point2D2 == null) {
                return new Line2D.Double(point2D.getX(), point2D.getY(), 0.0, 0.0);
            }
            return new Line2D.Double(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
        }
        return null;
    }

    protected Shape createEllipse(XMLElement xMLElement) {
        int n = xMLElement.getAttrCount();
        if (n > 0) {
            Point2D point2D = null;
            double d = 0.0;
            double d2 = 0.0;
            XMLAttr[] xMLAttrArray = xMLElement.getAttrs();
            block5: for (int i = 0; i < n; ++i) {
                XMLAttr xMLAttr = xMLAttrArray[i];
                int n2 = WPFEHelper.getAttrId(xMLAttr.getName());
                switch (n2) {
                    case 19: {
                        point2D = XAMLHandler.toPoint(xMLAttr);
                        continue block5;
                    }
                    case 114: {
                        d = StringUtils.toDouble((String)XMLUtils.getValue((XMLAttr)xMLAttr));
                        continue block5;
                    }
                    case 115: {
                        d2 = StringUtils.toDouble((String)XMLUtils.getValue((XMLAttr)xMLAttr));
                    }
                }
            }
            if (d > 0.0 && d2 > 0.0) {
                if (point2D == null) {
                    new Ellipse2D.Double(-d, -d2, d * 2.0, d2 * 2.0);
                }
                new Ellipse2D.Double(point2D.getX() - d, point2D.getY() - d2, d * 2.0, d2 * 2.0);
            }
        }
        return null;
    }

    protected Shape createCompositeShape(XMLElement xMLElement) {
        return this.parse(xMLElement, true);
    }

    protected ExtendedGeneralPath createPath(XMLElement xMLElement) {
        int n = xMLElement.getChildrenCount();
        if (n > 0) {
            ExtendedGeneralPath extendedGeneralPath = null;
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            for (int i = 0; i < n; ++i) {
                XMLNode xMLNode = xMLNodeArray[i];
                ExtendedGeneralPath extendedGeneralPath2 = null;
                String string = xMLNode.getLocalName();
                if ("PathFigureCollection".equals(string)) {
                    extendedGeneralPath2 = this.createPath((XMLElement)xMLNode);
                } else if ("PathFigure".equals(string)) {
                    extendedGeneralPath2 = this.createFigure((XMLElement)xMLNode);
                }
                if (extendedGeneralPath2 == null) continue;
                if (extendedGeneralPath == null) {
                    extendedGeneralPath = extendedGeneralPath2;
                    continue;
                }
                extendedGeneralPath.append((Shape)extendedGeneralPath2, false);
            }
            return extendedGeneralPath;
        }
        return null;
    }

    protected ExtendedGeneralPath createFigure(XMLElement xMLElement) {
        ExtendedGeneralPath extendedGeneralPath;
        if (xMLElement.getChildrenCount() == 0) {
            return null;
        }
        double[] dArray = null;
        boolean bl = false;
        int n = xMLElement.getAttrCount();
        if (n > 0) {
            extendedGeneralPath = xMLElement.getAttrs();
            for (int i = 0; i < n; ++i) {
                ExtendedGeneralPath extendedGeneralPath2 = extendedGeneralPath[i];
                String string = extendedGeneralPath2.getName();
                if ("StartPoint".equals(string)) {
                    dArray = XAMLHandler.toPoints((XMLAttr)extendedGeneralPath2);
                    continue;
                }
                if (!"IsClosed".equals(string)) continue;
                bl = StringUtils.toBoolean((String)XMLUtils.getValue((XMLAttr)extendedGeneralPath2));
            }
        }
        extendedGeneralPath = new ExtendedGeneralPath();
        if (dArray == null || dArray.length < 2) {
            extendedGeneralPath.moveTo(0.0f, 0.0f);
        } else {
            extendedGeneralPath.moveTo((float)dArray[0], (float)dArray[1]);
        }
        this.parseSegments(xMLElement, extendedGeneralPath);
        if (bl) {
            extendedGeneralPath.closePath();
        }
        return extendedGeneralPath;
    }

    protected void parseSegments(XMLElement xMLElement, ExtendedGeneralPath extendedGeneralPath) {
        int n = xMLElement.getChildrenCount();
        if (n > 0) {
            XMLNode[] xMLNodeArray = xMLElement.getChildren();
            block10: for (int i = 0; i < n; ++i) {
                XMLNode xMLNode = xMLNodeArray[i];
                if (1 != xMLNode.getNodeType()) continue;
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                int n2 = WPFEHelper.getTagId(xMLNode.getLocalName());
                switch (n2) {
                    case 88: {
                        double[] dArray = XAMLHandler.toPoints(XMLUtils.getAttrValue((XMLElement)xMLElement2, (String)"Point"));
                        if (dArray != null && dArray.length == 2) {
                            extendedGeneralPath.lineTo((float)dArray[0], (float)dArray[1]);
                            continue block10;
                        }
                        extendedGeneralPath.lineTo(0.0f, 0.0f);
                        continue block10;
                    }
                    case 1: {
                        float f6;
                        float f2;
                        float f3;
                        float f4;
                        HashtableOfInt hashtableOfInt = XAMLHandler.getAttributes(xMLElement2);
                        if (hashtableOfInt == null) continue block10;
                        String string = (String)hashtableOfInt.get(154);
                        float f5 = StringUtils.toFloat((String)((String)hashtableOfInt.get(123)));
                        boolean bl = StringUtils.toBoolean((String)((String)hashtableOfInt.get(68)), (boolean)false);
                        double[] dArray = XAMLHandler.toPoints(XMLUtils.getAttrValue((XMLElement)xMLElement2, (String)"Point"));
                        if (dArray == null && dArray.length != 2) {
                            f4 = 0.0f;
                            f3 = 0.0f;
                        } else {
                            f4 = (float)dArray[0];
                            f3 = (float)dArray[1];
                        }
                        dArray = XAMLHandler.toPoints(XMLUtils.getAttrValue((XMLElement)xMLElement2, (String)"Size"));
                        if (dArray == null && dArray.length != 2) {
                            f2 = 0.0f;
                            f6 = 0.0f;
                        } else {
                            f2 = (float)dArray[0];
                            f6 = (float)dArray[1];
                        }
                        extendedGeneralPath.arcTo(f2, f6, f5, bl, "Clockwise".equalsIgnoreCase(string), f4, f3);
                        continue block10;
                    }
                    case 4: {
                        float f;
                        float f6;
                        float f2;
                        float f3;
                        float f4;
                        float f5;
                        HashtableOfInt hashtableOfInt = XAMLHandler.getAttributes(xMLElement2);
                        if (hashtableOfInt == null) continue block10;
                        double[] dArray = XAMLHandler.toPoints((String)hashtableOfInt.get(108));
                        if (dArray == null) {
                            f4 = 0.0f;
                            f3 = 0.0f;
                        } else {
                            f4 = (float)dArray[0];
                            f3 = (float)dArray[1];
                        }
                        dArray = XAMLHandler.toPoints((String)hashtableOfInt.get(109));
                        if (dArray == null) {
                            f2 = 0.0f;
                            f6 = 0.0f;
                        } else {
                            f2 = (float)dArray[0];
                            f6 = (float)dArray[1];
                        }
                        dArray = XAMLHandler.toPoints((String)hashtableOfInt.get(110));
                        if (dArray == null) {
                            f = 0.0f;
                            f5 = 0.0f;
                        } else {
                            f = (float)dArray[0];
                            f5 = (float)dArray[1];
                        }
                        extendedGeneralPath.curveTo(f4, f3, f2, f6, f, f5);
                        continue block10;
                    }
                    case 147: {
                        float f6;
                        float f2;
                        float f3;
                        float f4;
                        HashtableOfInt hashtableOfInt = XAMLHandler.getAttributes(xMLElement2);
                        if (hashtableOfInt == null) continue block10;
                        double[] dArray = XAMLHandler.toPoints((String)hashtableOfInt.get(108));
                        if (dArray == null) {
                            f4 = 0.0f;
                            f3 = 0.0f;
                        } else {
                            f4 = (float)dArray[0];
                            f3 = (float)dArray[1];
                        }
                        dArray = XAMLHandler.toPoints((String)hashtableOfInt.get(109));
                        if (dArray == null) {
                            f2 = 0.0f;
                            f6 = 0.0f;
                        } else {
                            f2 = (float)dArray[0];
                            f6 = (float)dArray[1];
                        }
                        extendedGeneralPath.quadTo(f4, f3, f2, f6);
                        continue block10;
                    }
                    case 128: {
                        continue block10;
                    }
                    case 130: {
                        continue block10;
                    }
                    case 124: {
                        this.parseSegments(xMLElement2, extendedGeneralPath);
                        continue block10;
                    }
                    case 119: {
                        this.parseSegments(xMLElement2, extendedGeneralPath);
                    }
                }
            }
        }
    }

    protected void skipFillRule() {
        this.skipSpaces();
        char c = this.values[this.start];
        if (c == 'F' || c == 'f') {
            ++this.start;
            switch (this.values[this.start++]) {
                case '0': {
                    this.path.setWindingRule(0);
                    break;
                }
                case '1': {
                    this.path.setWindingRule(1);
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
        }
    }

    protected boolean skipSpaces() {
        int n = this.start;
        block3: while (this.start < this.end) {
            switch (this.values[this.start++]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            --this.start;
            return this.start > n;
        }
        return this.start > n;
    }

    protected boolean skipCommaSpaces() {
        boolean bl = true;
        int n = this.start;
        block4: while (this.start < this.end) {
            switch (this.values[this.start++]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
                case ',': {
                    if (bl) {
                        bl = false;
                        continue block4;
                    }
                    --this.start;
                    throw new IllegalPathStateException();
                }
            }
            --this.start;
            return this.start > n;
        }
        return this.start > n;
    }

    protected void parseCommand() {
        block22: while (this.start < this.end) {
            char c = this.values[this.start++];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block22;
                }
                case 'm': {
                    this.moveto(false);
                    continue block22;
                }
                case 'M': {
                    this.moveto(true);
                    continue block22;
                }
                case 'l': {
                    this.lineto(false);
                }
                case 'L': {
                    this.lineto(true);
                    continue block22;
                }
                case 'h': {
                    this.linetoHorizontal(false);
                    continue block22;
                }
                case 'H': {
                    this.linetoHorizontal(true);
                    continue block22;
                }
                case 'v': {
                    this.linetoVertical(false);
                    continue block22;
                }
                case 'V': {
                    this.linetoVertical(true);
                    continue block22;
                }
                case 'c': {
                    this.curvetoCubic(false);
                    continue block22;
                }
                case 'C': {
                    this.curvetoCubic(true);
                    continue block22;
                }
                case 'q': {
                    this.curvetoQuadratic(false);
                    continue block22;
                }
                case 'Q': {
                    this.curvetoQuadratic(true);
                    continue block22;
                }
                case 's': {
                    this.curvetoCubicSmooth(false);
                    continue block22;
                }
                case 'S': {
                    this.curvetoCubicSmooth(true);
                    continue block22;
                }
                case 't': {
                    this.curvetoQuadraticSmooth(false);
                    continue block22;
                }
                case 'T': {
                    this.curvetoQuadraticSmooth(true);
                    continue block22;
                }
                case 'a': {
                    this.arcto(false);
                    continue block22;
                }
                case 'A': {
                    this.arcto(true);
                    continue block22;
                }
                case 'Z': 
                case 'z': {
                    this.path.closePath();
                    continue block22;
                }
            }
            throw new IllegalPathStateException();
        }
    }

    protected void moveto(boolean bl) {
        this.skipSpaces();
        float f = this.parseFloat();
        this.skipCommaSpaces();
        float f2 = this.parseFloat();
        if (bl) {
            this.xCenter = this.currentX = f;
            this.yCenter = this.currentY = f2;
            this.path.moveTo(this.currentX, this.currentY);
        } else {
            this.xCenter = this.currentX += f;
            this.yCenter = this.currentY += f2;
            this.path.moveTo(this.currentX, this.currentY);
        }
    }

    protected void lineto(boolean bl) {
        this.skipSpaces();
        try {
            do {
                float f = this.parseFloat();
                this.skipCommaSpaces();
                float f2 = this.parseFloat();
                if (bl) {
                    this.xCenter = this.currentX = f;
                    this.yCenter = this.currentY = f2;
                    this.path.lineTo(this.currentX, this.currentY);
                } else {
                    this.xCenter = this.currentX += f;
                    this.yCenter = this.currentY += f2;
                    this.path.lineTo(this.currentX, this.currentY);
                }
                this.skipCommaSpaces();
            } while (this.start < this.end);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void linetoHorizontal(boolean bl) {
        this.skipSpaces();
        try {
            do {
                float f = this.parseFloat();
                if (bl) {
                    this.xCenter = this.currentX = f;
                    this.yCenter = this.currentY;
                    this.path.lineTo(this.currentX, this.yCenter);
                } else {
                    this.xCenter = this.currentX += f;
                    this.yCenter = this.currentY;
                    this.path.lineTo(this.currentX, this.yCenter);
                }
                this.skipCommaSpaces();
            } while (this.start < this.end);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void linetoVertical(boolean bl) {
        this.skipSpaces();
        try {
            do {
                float f = this.parseFloat();
                if (bl) {
                    this.xCenter = this.currentX;
                    this.yCenter = this.currentY = f;
                    this.path.lineTo(this.xCenter, this.currentY);
                } else {
                    this.xCenter = this.currentX;
                    this.yCenter = this.currentY += f;
                    this.path.lineTo(this.xCenter, this.currentY);
                }
                this.skipCommaSpaces();
            } while (this.start < this.end);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void arcto(boolean bl) {
        this.skipSpaces();
        try {
            boolean bl2;
            boolean bl3;
            float f = this.parseFloat();
            this.skipCommaSpaces();
            float f2 = this.parseFloat();
            this.skipCommaSpaces();
            float f3 = this.parseFloat();
            this.skipCommaSpaces();
            switch (this.values[this.start++]) {
                case '0': {
                    bl3 = false;
                    break;
                }
                case '1': {
                    bl3 = true;
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
            this.skipCommaSpaces();
            switch (this.values[this.start++]) {
                case '0': {
                    bl2 = false;
                    break;
                }
                case '1': {
                    bl2 = true;
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
            this.skipCommaSpaces();
            float f4 = this.parseFloat();
            this.skipCommaSpaces();
            float f5 = this.parseFloat();
            if (bl) {
                this.xCenter = this.currentX = f4;
                this.yCenter = this.currentY = f5;
                this.path.arcTo(f, f2, f3, bl3, bl2, this.currentX, this.currentY);
            } else {
                this.xCenter = this.currentX += f4;
                this.yCenter = this.currentY += f5;
                this.path.arcTo(f, f2, f3, bl3, bl2, this.currentX, this.currentY);
            }
            this.skipCommaSpaces();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void curvetoCubic(boolean bl) {
        this.skipSpaces();
        try {
            do {
                float f = this.parseFloat();
                this.skipCommaSpaces();
                float f2 = this.parseFloat();
                this.skipCommaSpaces();
                float f3 = this.parseFloat();
                this.skipCommaSpaces();
                float f4 = this.parseFloat();
                this.skipCommaSpaces();
                float f5 = this.parseFloat();
                this.skipCommaSpaces();
                float f6 = this.parseFloat();
                if (bl) {
                    this.xCenter = f3;
                    this.yCenter = f4;
                    this.currentX = f5;
                    this.currentY = f6;
                    this.path.curveTo(f, f2, this.xCenter, this.yCenter, this.currentX, this.currentY);
                } else {
                    this.xCenter = this.currentX + f3;
                    this.yCenter = this.currentY + f4;
                    this.path.curveTo(this.currentX + f, this.currentY + f2, this.xCenter, this.yCenter, this.currentX += f5, this.currentY += f6);
                }
                this.skipCommaSpaces();
            } while (this.start < this.end);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void curvetoQuadratic(boolean bl) {
        this.skipSpaces();
        try {
            do {
                float f = this.parseFloat();
                this.skipCommaSpaces();
                float f2 = this.parseFloat();
                this.skipCommaSpaces();
                float f3 = this.parseFloat();
                this.skipCommaSpaces();
                float f4 = this.parseFloat();
                if (bl) {
                    this.xCenter = f;
                    this.yCenter = f2;
                    this.currentX = f3;
                    this.currentY = f4;
                    this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
                } else {
                    this.xCenter = this.currentX + f;
                    this.yCenter = this.currentY + f2;
                    this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f3, this.currentY += f4);
                }
                this.skipCommaSpaces();
            } while (this.start < this.end);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void curvetoCubicSmooth(boolean bl) {
        this.skipSpaces();
        try {
            do {
                float f = this.parseFloat();
                this.skipCommaSpaces();
                float f2 = this.parseFloat();
                this.skipCommaSpaces();
                float f3 = this.parseFloat();
                this.skipCommaSpaces();
                float f4 = this.parseFloat();
                if (bl) {
                    this.xCenter = f;
                    this.yCenter = f2;
                    this.currentX = f3;
                    this.currentY = f4;
                    this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX, this.currentY);
                } else {
                    this.xCenter = this.currentX + f;
                    this.yCenter = this.currentY + f2;
                    this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX += f3, this.currentY += f4);
                }
                this.skipCommaSpaces();
            } while (this.start < this.end);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void curvetoQuadraticSmooth(boolean bl) {
        this.skipSpaces();
        try {
            do {
                float f = this.parseFloat();
                this.skipCommaSpaces();
                float f2 = this.parseFloat();
                if (bl) {
                    this.xCenter = this.currentX * 2.0f - this.xCenter;
                    this.yCenter = this.currentY * 2.0f - this.yCenter;
                    this.currentX = f;
                    this.currentY = f2;
                    this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
                } else {
                    this.xCenter = this.currentX * 2.0f - this.xCenter;
                    this.yCenter = this.currentY * 2.0f - this.yCenter;
                    this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f, this.currentY += f2);
                }
                this.skipCommaSpaces();
            } while (this.start < this.end);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected float parseFloat() {
        int n = 0;
        int n2 = this.start;
        block9: while (this.start < this.end) {
            int n3 = this.values[this.start];
            block0 : switch (n3) {
                case 43: 
                case 45: {
                    if (this.start <= n2) break;
                    switch (n) {
                        case 46: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            break block9;
                        }
                        case 69: 
                        case 101: {
                            break block0;
                        }
                        default: {
                            throw new NumberFormatException();
                        }
                    }
                }
                case 46: {
                    if (n != 46) break;
                    break block9;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 69: 
                case 101: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            n = n3;
            ++this.start;
        }
        if (this.start > n2) {
            return Float.parseFloat(new String(this.values, n2, this.start - n2));
        }
        throw new IllegalStateException();
    }
}

