/*
 * Decompiled with CFR 0.152.
 */
package com.spket.wpfe.model.render;

import com.spket.util.Debug;
import com.spket.wpfe.model.render.IRelativeBrush;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.LinearGradientPaintContext;
import org.apache.batik.ext.awt.MultipleGradientPaint;

public class RelativeLinearGradientPaint
extends LinearGradientPaint
implements IRelativeBrush {
    private boolean relative;
    private boolean relativeTransform;

    public RelativeLinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) {
        super(point2D, point2D2, fArray, colorArray, cycleMethodEnum, colorSpaceEnum);
    }

    public void setRelative(boolean bl) {
        this.relative = bl;
    }

    public void setTransform(AffineTransform affineTransform, boolean bl) {
        this.gradientTransform = affineTransform;
        this.relativeTransform = bl;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (this.relative || this.relativeTransform && this.gradientTransform != null) {
            Point2D point2D = this.getStartPoint();
            Point2D point2D2 = this.getEndPoint();
            if (this.relative) {
                point2D.setLocation(point2D.getX() * rectangle2D.getWidth() + rectangle2D.getX(), point2D.getY() * rectangle2D.getHeight() + rectangle2D.getY());
                point2D2.setLocation(point2D2.getX() * rectangle2D.getWidth() + rectangle2D.getX(), point2D2.getY() * rectangle2D.getHeight() + rectangle2D.getY());
            }
            try {
                return new LinearGradientPaintContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints, point2D, point2D2, this.fractions, this.getColors(), this.cycleMethod, this.colorSpace);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Debug.debug((Throwable)noninvertibleTransformException);
                throw new IllegalArgumentException("transform should beinvertible");
            }
        }
        return super.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }
}

