/*
 * Decompiled with CFR 0.152.
 */
package com.spket.svg.model;

import com.spket.svg.model.SVGConstants;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.util.SymbolTable;

public class SVGHelper
implements SVGConstants {
    private static final String[] tags;
    private static final String[] attrs;
    private static Map tagMap;
    private static Map attrMap;

    public static Integer getTagID(String string) {
        if (string == null) {
            return null;
        }
        return (Integer)tagMap.get(string);
    }

    public static int getTagId(String string) {
        Integer n = SVGHelper.getTagID(string);
        return n == null ? Integer.MIN_VALUE : n;
    }

    public static String getTagName(int n) {
        if (n > 0 && n <= tags.length) {
            return tags[n - 1];
        }
        return null;
    }

    public static Integer getAttrID(String string) {
        if (string == null) {
            return null;
        }
        return (Integer)attrMap.get(string);
    }

    public static int getAttrId(String string) {
        Integer n = SVGHelper.getAttrID(string);
        return n == null ? Integer.MIN_VALUE : n;
    }

    public static String getAttrName(int n) {
        if (n > 0 && n <= attrs.length) {
            return attrs[n - 1];
        }
        return null;
    }

    public static boolean isEventAttribute(String string) {
        return string.length() > 2 && string.startsWith("on");
    }

    public static void initSymbolTable(SymbolTable symbolTable) {
        int n;
        symbolTable.addSymbol("http://www.w3.org/XML/1998/namespace");
        symbolTable.addSymbol("http://www.w3.org/1999/xlink");
        symbolTable.addSymbol("http://www.w3.org/2000/svg");
        symbolTable.addSymbol("xml");
        symbolTable.addSymbol("xlink");
        symbolTable.addSymbol("svg");
        for (n = 0; n < tags.length; ++n) {
            symbolTable.addSymbol(tags[n]);
        }
        for (n = 0; n < attrs.length; ++n) {
            symbolTable.addSymbol(attrs[n]);
        }
    }

    static {
        int n;
        tags = new String[]{"a", "altGlyph", "altGlyphDef", "altGlyphItem", "animate", "animateColor", "animateMotion", "animateTransform", "circle", "clipPath", "color-profile", "cursor", "definition-src", "defs", "desc", "ellipse", "feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence", "filter", "font", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignObject", "g", "glyph", "glyphRef", "hkern", "image", "line", "linearGradient", "marker", "mask", "metadata", "missing-glyph", "mpath", "path", "pattern", "polygon", "polyline", "radialGradient", "rect", "script", "set", "stop", "style", "svg", "switch", "symbol", "text", "textPath", "title", "tref", "tspan", "use", "view", "vkern"};
        attrs = new String[]{"accent-height", "accumulate", "additive", "alignment-baseline", "alphabetic", "amplitude", "arabic-form", "ascent", "attributeName", "attributeType", "azimuth", "baseFrequency", "baseProfile", "baseline-shift", "bbox", "begin", "bias", "by", "calcMode", "cap-height", "class", "clip", "clip-path", "clip-rule", "clipPathUnits", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "contentScriptType", "contentStyleType", "cursor", "cx", "cy", "d", "descent", "diffuseConstant", "direction", "display", "divisor", "dominant-baseline", "dur", "dx", "dy", "edgeMode", "elevation", "enable-background", "end", "exponent", "externalResourcesRequired", "fill", "fill-opacity", "fill-rule", "filter", "filterRes", "filterUnits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "format", "from", "fx", "fy", "g1", "g2", "glyph-name", "glyph-orientation-horizontal", "glyph-orientation-vertical", "glyphRef", "gradientTransform", "gradientUnits", "hanging", "height", "horiz-adv-x", "horiz-origin-x", "horiz-origin-y", "id", "ideographic", "image-rendering", "in", "in2", "intercept", "k", "k1", "k2", "k3", "k4", "kernelMatrix", "kernelUnitLength", "kerning", "keyPoints", "keySplines", "keyTimes", "lang", "lengthAdjust", "letter-spacing", "lighting-color", "limitingConeAngle", "local", "marker-end", "marker-mid", "marker-start", "markerHeight", "markerUnits", "markerWidth", "mask", "maskContentUnits", "maskUnits", "mathematical", "max", "media", "method", "min", "mode", "name", "numOctaves", "offset", "onabort", "onactivate", "onbegin", "onclick", "onend", "onerror", "onfocusin", "onfocusout", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onrepeat", "onresize", "onscroll", "onunload", "onzoom", "opacity", "operator", "order", "orient", "orientation", "origin", "overflow", "overline-position", "overline-thickness", "panose-1", "path", "pathLength", "patternContentUnits", "patternTransform", "patternUnits", "pointer-events", "points", "pointsAtX", "pointsAtY", "pointsAtZ", "preserveAlpha", "preserveAspectRatio", "primitiveUnits", "r", "radius", "refX", "refY", "rendering-intent", "repeatCount", "repeatDur", "requiredExtensions", "requiredFeatures", "restart", "result", "rotate", "rx", "ry", "scale", "seed", "shape-rendering", "slope", "spacing", "specularConstant", "specularExponent", "spreadMethod", "startOffset", "stdDeviation", "stemh", "stemv", "stitchTiles", "stop-color", "stop-opacity", "strikethrough-position", "strikethrough-thickness", "string", "stroke", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke-width", "style", "surfaceScale", "systemLanguage", "tableValues", "target", "targetX", "targetY", "text-anchor", "text-decoration", "text-rendering", "textLength", "title", "to", "transform", "type", "u1", "u2", "underline-position", "underline-thickness", "unicode", "unicode-bidi", "unicode-range", "units-per-em", "v-alphabetic", "v-hanging", "v-ideographic", "v-mathematical", "values", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "viewBox", "viewTarget", "visibility", "width", "widths", "word-spacing", "writing-mode", "x", "x-height", "x1", "x2", "xChannelSelector", "xmlns", "y", "y1", "y2", "yChannelSelector", "z", "zoomAndPan"};
        tagMap = new HashMap(tags.length);
        attrMap = new HashMap(attrs.length);
        for (n = 0; n < tags.length; ++n) {
            tagMap.put(tags[n], new Integer(n + 1));
        }
        for (n = 0; n < attrs.length; ++n) {
            attrMap.put(attrs[n], new Integer(n + 1));
        }
    }
}

