/*
 * Decompiled with CFR 0.152.
 */
package com.spket.svg.model;

import com.spket.js.model.Context;
import com.spket.js.model.ICompletionRequestor;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSObject;
import com.spket.js.model.ObjectImpl;
import com.spket.js.model.ObjectWrapper;
import com.spket.js.model.Slot;
import com.spket.js.model.Window;
import com.spket.js.profile.CoreVisitor;
import com.spket.svg.internal.SVGPlugin;

public class SVGLibrary
extends Context {
    private static final String WINDOW = "window";
    private static final String PROFILE_ID = "com.spket.svg11";
    private static SVGLibrary library;
    private JSObject global;

    public static SVGLibrary getInstance() {
        if (library == null) {
            Context.getContext((String)PROFILE_ID);
            if (library == null) {
                SVGLibrary sVGLibrary = new SVGLibrary();
                if (library == null) {
                    library = sVGLibrary;
                }
            }
            library.initialize();
        }
        return library;
    }

    public SVGLibrary() {
        if (library != null) {
            throw new IllegalStateException("Should not be called");
        }
        library = this;
    }

    public JSObject getGlobal() {
        return this.global;
    }

    public JSObject getGlobalForEdit() {
        Object object = this.isInitialized() ? new Global(this.global) : new ObjectImpl();
        return object;
    }

    protected void loadClasses() {
        Window window = new Window();
        this.global = window;
        CoreVisitor coreVisitor = new CoreVisitor();
        coreVisitor.load((ObjectImpl)window, SVGPlugin.getDefault().getBundle());
    }

    private static class Global
    extends ObjectWrapper {
        private ISlot window = new Slot();

        public Global(JSObject jSObject) {
            super(jSObject);
            this.window.setObject((JSObject)this);
        }

        public ISlot getLocalSlot(String string) {
            if (SVGLibrary.WINDOW.equals(string)) {
                return this.window;
            }
            return super.getLocalSlot(string);
        }

        public ISlot getSlot(String string) {
            if (SVGLibrary.WINDOW.equals(string)) {
                return this.window;
            }
            return super.getSlot(string);
        }

        public void codeComplete(ICompletionRequestor iCompletionRequestor) {
            iCompletionRequestor.accept((JSObject)this, SVGLibrary.WINDOW, this.window);
            super.codeComplete(iCompletionRequestor);
        }

        public void codeComplete(ICompletionRequestor iCompletionRequestor, int n) {
            iCompletionRequestor.accept((JSObject)this, SVGLibrary.WINDOW, this.window);
            super.codeComplete(iCompletionRequestor, n);
        }
    }
}

