/*
 * Decompiled with CFR 0.152.
 */
package com.spket.mime.editors;

import com.spket.js.editors.JSItem;
import com.spket.js.internal.text.BracketInserter;
import com.spket.js.internal.text.JSPairMatcher;
import com.spket.js.internal.text.Partitioner;
import com.spket.js.internal.text.hover.JSHyperlinkDetector;
import com.spket.js.model.ILexerContext;
import com.spket.mime.internal.MIMEPlugin;
import com.spket.mime.text.MIMEPartitionScanner;
import com.spket.mime.text.MIMESourceViewerConfiguration;
import com.spket.ui.editors.PlainTextEditor;
import com.spket.xml.XMLModel;
import com.spket.xml.editors.XMLEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public abstract class MIMETextEditor
extends XMLEditor {
    private static final String[] ContentTypes = new String[]{"__js_elem", "__js_cdata"};
    private static final String[] StopPartitions = new String[]{"__xml_tag", "__xml_cdata"};
    private Partitioner fPartitioner;
    private JSPairMatcher fBracketMatcher;
    private BracketInserter fBracketInserter;
    static /* synthetic */ Class class$com$spket$js$model$ILexerContext;

    public void dispose() {
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        if (this.fBracketInserter != null) {
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (iSourceViewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)iSourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
            }
            this.fBracketInserter = null;
        }
        if (this.fPartitioner != null) {
            this.fPartitioner.dispose();
            this.fPartitioner = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        if ((class$com$spket$js$model$ILexerContext == null ? (class$com$spket$js$model$ILexerContext = MIMETextEditor.class$("com.spket.js.model.ILexerContext")) : class$com$spket$js$model$ILexerContext).equals(clazz)) {
            XMLModel xMLModel = this.getModel();
            if (xMLModel instanceof ILexerContext) {
                return xMLModel;
            }
            return null;
        }
        return super.getAdapter(clazz);
    }

    public Partitioner getPartitioner() {
        if (this.fPartitioner == null) {
            this.fPartitioner = new Partitioner(this.getDocumentPartitioning(), ContentTypes);
            this.fPartitioner.setStopPartitions(StopPartitions);
        }
        return this.fPartitioner;
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer instanceof ITextViewerExtension) {
            this.fBracketInserter = new BracketInserter((PlainTextEditor)this, this.getDocumentPartitioning());
            this.fBracketInserter.setContentTypes(ContentTypes);
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            this.fBracketInserter.setCloseStringsEnabled(iPreferenceStore.getBoolean("js_closeStrings"));
            this.fBracketInserter.setCloseBracketsEnabled(iPreferenceStore.getBoolean("js_closeBrackets"));
            ((ITextViewerExtension)iSourceViewer).appendVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    protected void initializeEditor() {
        IPreferenceStore iPreferenceStore = MIMEPlugin.getDefault().getCombinedPreferenceStore();
        this.setPreferenceStore(iPreferenceStore);
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration(iPreferenceStore));
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] stringArray = super.collectContextMenuPreferencePages();
        String[] stringArray2 = new String[stringArray.length + 5];
        stringArray2[0] = "com.spket.js.pref.jseditor";
        stringArray2[1] = "com.spket.js.pref.color";
        stringArray2[2] = "com.spket.js.pref.template";
        stringArray2[3] = "com.spket.js.pref.typing";
        stringArray2[4] = "com.spket.js.pref.profile";
        System.arraycopy(stringArray, 0, stringArray2, 5, stringArray.length);
        return stringArray2;
    }

    protected String getDocumentPartitioning() {
        return "___mime_partitioning";
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration(IPreferenceStore iPreferenceStore) {
        return new MIMESourceViewerConfiguration(this, this.getTextTools().getColorManager(), iPreferenceStore, this.getDocumentPartitioning());
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport sourceViewerDecorationSupport) {
        if (this.fBracketMatcher == null) {
            this.fBracketMatcher = new JSPairMatcher(this.getPartitioner());
        }
        sourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        sourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys("matchingBrackets", "matchingBracketsColor");
        super.configureSourceViewerDecorationSupport(sourceViewerDecorationSupport);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.fBracketInserter != null) {
            String string = propertyChangeEvent.getProperty();
            if ("js_closeStrings".equals(string)) {
                this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(string));
                return;
            }
            if ("js_closeBrackets".equals(string)) {
                this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(string));
                return;
            }
        }
        super.handlePreferenceStoreChanged(propertyChangeEvent);
    }

    protected int[] getRegion(Object object) {
        if (object instanceof JSItem) {
            JSItem jSItem = (JSItem)object;
            if (jSItem.range != null) {
                int n = jSItem.range.x;
                int n2 = jSItem.range.y;
                if (n2 > 0) {
                    n2 = n2 - n + 1;
                }
                return new int[]{n, n2, n2};
            }
            return null;
        }
        return super.getRegion(object);
    }

    protected void openDeclaration(int n) {
        IHyperlink[] iHyperlinkArray;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        int n2 = -1;
        String string = this.getDocumentPartitioning();
        try {
            iHyperlinkArray = TextUtilities.getPartition((IDocument)iDocument, (String)string, (int)n, (boolean)false);
            if (iHyperlinkArray != null) {
                n2 = MIMEPartitionScanner.getState(iHyperlinkArray.getType());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (n2 >= 7 && (iHyperlinkArray = JSHyperlinkDetector.detectHyperlinks((ITextEditor)this, (IDocument)iDocument, (String)string, (int)n)) != null && iHyperlinkArray.length > 0) {
            iHyperlinkArray[0].open();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

