/*
 * Decompiled with CFR 0.152.
 */
package com.spket.mime.text;

import com.spket.js.internal.text.JSCodeScanner;
import com.spket.js.internal.text.JSCommentScanner;
import com.spket.js.internal.text.JSDocScanner;
import com.spket.mime.text.MIMEPartitions;
import com.spket.ui.text.ConfigurableScanner;
import com.spket.ui.text.IColorManager;
import com.spket.ui.text.IConfigurable;
import com.spket.ui.text.SingleTokenScanner;
import com.spket.xml.internal.text.XMLCommentScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class HoverSourceViewerConfiguration
extends TextSourceViewerConfiguration
implements IConfigurable {
    private IColorManager fColorManager;
    private ConfigurableScanner[] fScanners;

    public HoverSourceViewerConfiguration(IPreferenceStore iPreferenceStore, IColorManager iColorManager) {
        super(iPreferenceStore);
        this.fColorManager = iColorManager;
        this.initializeScanners();
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return MIMEPartitions.TYPES;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        return null;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string, int n) {
        return null;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        presentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        for (int i = 0; i < this.fScanners.length; ++i) {
            ConfigurableScanner configurableScanner = this.fScanners[i];
            if (configurableScanner == null) continue;
            DefaultDamagerRepairer defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.fScanners[i]);
            presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, MIMEPartitions.TYPES[i]);
            presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, MIMEPartitions.TYPES[i]);
        }
        return presentationReconciler;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        for (int i = 0; i < this.fScanners.length; ++i) {
            if (this.fScanners[i] == null || !this.fScanners[i].affectsTextPresentation(propertyChangeEvent)) continue;
            return true;
        }
        return false;
    }

    public void changeConfiguration(PropertyChangeEvent propertyChangeEvent) {
        for (int i = 0; i < this.fScanners.length; ++i) {
            if (this.fScanners[i] == null) continue;
            this.fScanners[i].changeConfiguration(propertyChangeEvent);
        }
    }

    private void initializeScanners() {
        IColorManager iColorManager = this.fColorManager;
        this.fScanners = new ConfigurableScanner[MIMEPartitions.TYPES.length];
        this.fScanners[0] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_default");
        this.fScanners[1] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_proc_instr");
        this.fScanners[2] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_doctype");
        this.fScanners[3] = new XMLCommentScanner(iColorManager, this.fPreferenceStore, "xml_comments");
        this.fScanners[4] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_cdata");
        this.fScanners[5] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_tags");
        this.fScanners[6] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "xml_attr_value");
        this.fScanners[7] = new JSCodeScanner(iColorManager, this.fPreferenceStore);
        this.fScanners[8] = this.fScanners[7];
        this.fScanners[9] = new JSCommentScanner(iColorManager, this.fPreferenceStore, "js_sl_comment");
        this.fScanners[13] = this.fScanners[9];
        this.fScanners[10] = new JSCommentScanner(iColorManager, this.fPreferenceStore, "js_ml_comment");
        this.fScanners[14] = this.fScanners[10];
        this.fScanners[11] = new JSDocScanner(iColorManager, this.fPreferenceStore);
        this.fScanners[15] = this.fScanners[11];
        this.fScanners[12] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "js_string");
        this.fScanners[16] = this.fScanners[12];
        this.fScanners[17] = new SingleTokenScanner(iColorManager, this.fPreferenceStore, "js_regexp");
        this.fScanners[18] = this.fScanners[17];
    }
}

