/*
 * Decompiled with CFR 0.152.
 */
package com.spket.mime.text;

import com.spket.mime.text.MIMEPartitions;
import com.spket.ui.text.BufferedDocumentScanner;
import com.spket.xml.XMLUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class MIMEPartitionScanner
implements IPartitionTokenScanner,
MIMEPartitions {
    protected static final IToken[] tokens = new IToken[]{new Token(null), new Token((Object)MIMEPartitions.TYPES[1]), new Token((Object)MIMEPartitions.TYPES[2]), new Token((Object)MIMEPartitions.TYPES[3]), new Token((Object)MIMEPartitions.TYPES[4]), new Token((Object)MIMEPartitions.TYPES[5]), new Token((Object)MIMEPartitions.TYPES[6]), new Token((Object)MIMEPartitions.TYPES[7]), new Token((Object)MIMEPartitions.TYPES[8]), new Token((Object)MIMEPartitions.TYPES[9]), new Token((Object)MIMEPartitions.TYPES[10]), new Token((Object)MIMEPartitions.TYPES[11]), new Token((Object)MIMEPartitions.TYPES[12]), new Token((Object)MIMEPartitions.TYPES[13]), new Token((Object)MIMEPartitions.TYPES[14]), new Token((Object)MIMEPartitions.TYPES[15]), new Token((Object)MIMEPartitions.TYPES[16]), new Token((Object)MIMEPartitions.TYPES[17]), new Token((Object)MIMEPartitions.TYPES[18])};
    private int fLast;
    private int fState;
    private int fTokenOffset;
    private int fTokenLength;
    private int fPrefixLength;
    private int fTagStart;
    private int fAttrQuote;
    private int fJavaQuote;
    private String fPartitioning;
    protected char[] fNameBuffer = new char[256];
    protected final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(2048);

    public static int getParentState(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 0;
            }
            case 6: {
                return 5;
            }
            case 7: 
            case 8: {
                return 0;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: {
                return 7;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                return 8;
            }
        }
        return 0;
    }

    protected static final IToken getToken(int n) {
        return tokens[n & 0xFFFF];
    }

    public static int getState(String string) {
        if (string == null) {
            return 0;
        }
        if ("__xml_tag".equals(string)) {
            return 5;
        }
        if ("__xml_attr_value".equals(string)) {
            return 6;
        }
        if ("__xml_cdata".equals(string)) {
            return 4;
        }
        if ("__xml_comment".equals(string)) {
            return 3;
        }
        if ("__xml_pi".equals(string)) {
            return 1;
        }
        if ("__xml_doctype".equals(string)) {
            return 2;
        }
        if ("__js_elem".equals(string)) {
            return 7;
        }
        if ("__js_cdata".equals(string)) {
            return 8;
        }
        if ("__js_string".equals(string)) {
            return 12;
        }
        if ("_js_c_string".equals(string)) {
            return 16;
        }
        if ("__js_multiline_comment".equals(string)) {
            return 10;
        }
        if ("_js_c_multi_comment".equals(string)) {
            return 14;
        }
        if ("__js_jsdoc".equals(string)) {
            return 11;
        }
        if ("_js_c_doc".equals(string)) {
            return 15;
        }
        if ("__js_singleline_comment".equals(string)) {
            return 9;
        }
        if ("_js_c_comment".equals(string)) {
            return 13;
        }
        if ("__js_regexp".equals(string)) {
            return 17;
        }
        if ("_js_c_regexp".equals(string)) {
            return 18;
        }
        return 0;
    }

    public MIMEPartitionScanner(String string) {
        this.fPartitioning = string == null ? "__dftl_partitioning" : string;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    public IToken nextToken() {
        IToken iToken = this.nextToken0();
        while (this.fTokenLength == 0 && iToken != Token.EOF) {
            iToken = this.nextToken0();
        }
        return iToken;
    }

    public void setRange(IDocument iDocument, int n, int n2) {
        this.setPartialRange(iDocument, n, n2, null, -1);
    }

    public void setPartialRange(IDocument iDocument, int n, int n2, String string, int n3) {
        this.fJavaQuote = 0;
        this.fAttrQuote = 0;
        this.fTokenLength = 0;
        this.fTagStart = -1;
        this.fLast = -1;
        this.fTokenOffset = n3;
        this.fPrefixLength = n - n3;
        this.fScanner.setRange(iDocument, n, n2);
        if (n > 0 && n == n3 && string == "__dftl_partition_content_type") {
            ITypedRegion iTypedRegion = null;
            try {
                iTypedRegion = this.getPartition(iDocument, n);
            }
            catch (BadLocationException badLocationException) {
                iTypedRegion = null;
            }
            if (iTypedRegion == null) {
                this.fState = MIMEPartitionScanner.getState(string);
            } else {
                this.fState = MIMEPartitionScanner.getState(iTypedRegion.getType());
                if (this.fState == 6) {
                    try {
                        this.fJavaQuote = iDocument.getChar(iTypedRegion.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        this.fJavaQuote = 34;
                    }
                }
            }
        } else {
            this.fState = MIMEPartitionScanner.getState(string);
            if (n3 > 0 && this.fState == 6) {
                try {
                    ITypedRegion iTypedRegion = this.getPartition(iDocument, n3);
                    if (iTypedRegion != null) {
                        this.fJavaQuote = iDocument.getChar(iTypedRegion.getOffset());
                    }
                }
                catch (BadLocationException badLocationException) {
                    this.fJavaQuote = 34;
                }
            }
        }
        if (2 == this.fState) {
            this.fPrefixLength = 0;
            n = n3;
            if (n < 0) {
                n = 0;
            }
            this.fScanner.setRange(iDocument, n, n2);
            this.fState = this.getParentState();
        }
    }

    protected ITypedRegion getPartition(IDocument iDocument, int n) throws BadLocationException {
        if (iDocument instanceof IDocumentExtension3) {
            try {
                return ((IDocumentExtension3)iDocument).getPartition(this.fPartitioning, n, false);
            }
            catch (BadPartitioningException badPartitioningException) {
                return null;
            }
        }
        return iDocument.getPartition(n);
    }

    protected final int getParentState() {
        return MIMEPartitionScanner.getParentState(this.fState);
    }

    protected final IToken preFix(int n, int n2, int n3, int n4) {
        this.fPrefixLength = n4;
        this.fLast = n3;
        this.fState = n2;
        return MIMEPartitionScanner.getToken(n);
    }

    protected IToken nextToken0() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        switch (this.fState) {
            case 17: 
            case 18: {
                return this.scanRegExp();
            }
        }
        block70: while (true) {
            int n;
            block92: {
                if ((n = this.fScanner.read()) != -1) {
                    ++this.fTokenLength;
                }
                block3 : switch (n) {
                    case -1: {
                        if (this.fTokenLength > 0) {
                            return this.preFix(this.fState, this.getParentState(), n, 0);
                        }
                        this.fPrefixLength = 0;
                        return Token.EOF;
                    }
                    case 60: {
                        int n2;
                        switch (this.fState) {
                            case 0: {
                                this.fTokenOffset += this.fTokenLength - 1;
                                this.fTokenLength = 1;
                                if (this.fScanner.skipChar('!')) {
                                    ++this.fTokenLength;
                                    if (this.fScanner.skipChar('-')) {
                                        ++this.fTokenLength;
                                        if (!this.fScanner.skipChar('-')) break block3;
                                        ++this.fTokenLength;
                                        this.fState = 3;
                                        break block3;
                                    }
                                    if (this.fScanner.skipString("[CDATA[")) {
                                        this.fState = 4;
                                        this.fTokenLength = 9;
                                        break block3;
                                    }
                                    if (!this.fScanner.skipString("DOCTYPE")) break block3;
                                    this.fTokenLength = 9;
                                    this.scanDoctypeDecl();
                                    return this.preFix(2, 0, n, 0);
                                }
                                if (this.fScanner.skipChar('?')) {
                                    this.fTokenLength = 2;
                                    this.fState = 1;
                                    break block3;
                                }
                                if (!XMLUtils.isValidNameStartChar((int)this.fScanner.peekChar())) break block3;
                                this.fState = 5;
                                this.fTagStart = this.fTokenOffset + 1;
                                break block3;
                            }
                            case 7: {
                                n2 = this.fScanner.peekChar();
                                if (n2 == 33 && this.fScanner.skipString("![CDATA[")) {
                                    --this.fTokenLength;
                                    return this.preFix(this.fState, 8, 91, 9);
                                }
                                if (n2 == 47 || XMLUtils.isValidNameStartChar((int)n2)) {
                                    --this.fTokenLength;
                                    this.fScanner.unread();
                                    return this.preFix(this.fState, 0, this.fLast, 0);
                                }
                                if (this.fLast != 47 || !this.isRegExp(1)) break block3;
                                if (this.fTokenLength > 2) {
                                    this.fTokenLength -= 2;
                                    return this.preFix(this.fState, 17, n, 2);
                                }
                                return this.scanRegExp();
                            }
                            case 1: 
                            case 3: 
                            case 4: 
                            case 8: {
                                break block3;
                            }
                        }
                        int n3 = this.getParentState();
                        if (n3 == 8 || n3 == 4) break;
                        --this.fTokenLength;
                        this.fScanner.unread();
                        return this.preFix(this.fState, 0, this.fLast, 0);
                    }
                    case 62: {
                        switch (this.fState) {
                            case 5: {
                                if (this.fLast != 47 && this.fTagStart > 0 && this.isScriptTag(this.fTagStart)) {
                                    return this.preFix(this.fState, 7, n, 0);
                                }
                                this.fTagStart = -1;
                                return this.preFix(this.fState, 0, n, 0);
                            }
                            case 4: 
                            case 8: {
                                if (this.fLast != 93 || this.fScanner.getChar(this.fTokenOffset + this.fTokenLength - 3) != 93) break;
                                return this.preFix(this.fState, this.getParentState(), n, 0);
                            }
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: {
                                if (this.fLast != 93 || this.fScanner.getChar(this.fTokenOffset + this.fTokenLength - 3) != 93) break;
                                this.fScanner.unread();
                                this.fTokenLength -= 3;
                                return this.preFix(this.fState, MIMEPartitionScanner.getParentState(this.getParentState()), 93, 2);
                            }
                            case 3: {
                                if (this.fLast != 45 || this.fScanner.getChar(this.fTokenOffset + this.fTokenLength - 3) != 45) break;
                                return this.preFix(this.fState, this.getParentState(), n, 0);
                            }
                            case 1: {
                                if (this.fLast != 63) break;
                                return this.preFix(this.fState, this.getParentState(), n, 0);
                            }
                        }
                        break;
                    }
                    case 34: 
                    case 39: {
                        switch (this.fState) {
                            case 5: {
                                this.fAttrQuote = n;
                                --this.fTokenLength;
                                return this.preFix(this.fState, 6, n, 1);
                            }
                            case 6: {
                                if (n != this.fAttrQuote) break;
                                return this.preFix(this.fState, 5, n, 0);
                            }
                            case 7: 
                            case 8: {
                                --this.fTokenLength;
                                this.fJavaQuote = n;
                                return this.preFix(this.fState, this.fState == 7 ? 12 : 16, n, 1);
                            }
                            case 12: 
                            case 16: {
                                if (n != this.fJavaQuote || this.fLast == 92) break;
                                return this.preFix(this.fState, this.getParentState(), n, 0);
                            }
                        }
                        break;
                    }
                    case 13: {
                        if (this.fLast != 13) break;
                        switch (this.fState) {
                            case 9: 
                            case 12: 
                            case 13: 
                            case 16: {
                                --this.fTokenLength;
                                return this.preFix(this.fState, this.getParentState(), n, 1);
                            }
                        }
                        break;
                    }
                    case 10: {
                        switch (this.fState) {
                            case 9: 
                            case 12: 
                            case 13: 
                            case 16: {
                                return this.preFix(this.fState, this.getParentState(), n, 0);
                            }
                        }
                        break;
                    }
                    case 47: {
                        int n2;
                        block39 : switch (this.fState) {
                            case 0: {
                                if (this.fLast == 60 && XMLUtils.isValidNameStartChar((int)this.fScanner.peekChar())) {
                                    this.fTagStart = -1;
                                    this.fTokenOffset += this.fTokenLength - 2;
                                    this.fTokenLength = 2;
                                    this.fState = 5;
                                    break;
                                }
                                break block92;
                            }
                            case 7: {
                                switch (this.fScanner.peekChar()) {
                                    case 47: {
                                        --this.fTokenLength;
                                        this.fScanner.read();
                                        return this.preFix(this.fState, 9, n, 2);
                                    }
                                    case 42: {
                                        --this.fTokenLength;
                                        this.fScanner.read();
                                        return this.preFix(this.fState, 10, n, 2);
                                    }
                                    case 60: {
                                        break block39;
                                    }
                                }
                                if (this.isRegExp(0)) {
                                    if (this.fTokenLength > 1) {
                                        --this.fTokenLength;
                                        return this.preFix(this.fState, 17, n, 1);
                                    }
                                    return this.scanRegExp();
                                }
                                break block92;
                            }
                            case 8: {
                                switch (this.fScanner.peekChar()) {
                                    case 47: {
                                        --this.fTokenLength;
                                        this.fScanner.read();
                                        return this.preFix(this.fState, 13, n, 2);
                                    }
                                    case 42: {
                                        --this.fTokenLength;
                                        this.fScanner.read();
                                        return this.preFix(this.fState, 14, n, 2);
                                    }
                                    case 93: {
                                        int n4 = this.fScanner.getOffset();
                                        if (this.fScanner.getChar(n4 + 1) == 93 && this.fScanner.getChar(n4 + 2) == 62) break block39;
                                    }
                                    default: {
                                        if (this.isRegExp(0)) {
                                            if (this.fTokenLength > 1) {
                                                --this.fTokenLength;
                                                return this.preFix(this.fState, 18, n, 1);
                                            }
                                            return this.scanRegExp();
                                        }
                                        break block92;
                                    }
                                }
                            }
                            case 10: 
                            case 14: {
                                if (this.fLast == 42 && this.fTokenLength > 2) {
                                    return this.preFix(this.fState, this.getParentState(), n, 0);
                                }
                                break block92;
                            }
                            case 11: 
                            case 15: {
                                if (this.fLast == 42) {
                                    n2 = this.fTokenLength;
                                    if (n2 > 4) {
                                        return this.preFix(this.fState, this.getParentState(), n, 0);
                                    }
                                    return this.preFix(this.fState == 11 ? 10 : 14, this.getParentState(), n, 0);
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case 42: {
                        switch (this.fState) {
                            case 7: 
                            case 8: {
                                if (this.fLast != 47) break;
                                this.fTokenLength -= 2;
                                return this.preFix(this.fState, this.fState == 7 ? 10 : 14, n, 2);
                            }
                            case 10: 
                            case 14: {
                                if (this.fTokenLength != 3) break;
                                this.fState = this.fState == 10 ? 11 : 15;
                            }
                        }
                        break;
                    }
                    case 38: {
                        int n2;
                        block60 : switch (this.fState) {
                            case 7: 
                            case 12: {
                                n2 = 0;
                                if (this.fScanner.skipString("quot;")) {
                                    n2 = 34;
                                } else if (this.fScanner.skipString("apos;")) {
                                    n2 = 39;
                                }
                                if (n2 == 0) break;
                                switch (this.fState) {
                                    case 12: {
                                        this.fTokenLength += 5;
                                        if (n2 != this.fJavaQuote) break block60;
                                        return this.preFix(this.fState, this.getParentState(), 59, 0);
                                    }
                                    case 7: {
                                        --this.fTokenLength;
                                        this.fJavaQuote = n2;
                                        return this.preFix(this.fState, 12, n, 6);
                                    }
                                }
                            }
                        }
                        break;
                    }
                    case 92: {
                        if (this.fLast != 92) break;
                        switch (this.fState) {
                            case 12: 
                            case 16: {
                                this.fLast = 0;
                                continue block70;
                            }
                        }
                    }
                }
            }
            this.fLast = n;
        }
    }

    protected boolean skipSpaces() {
        int n = this.fScanner.read();
        if (XMLUtils.isSpace((int)n)) {
            while ((n = this.fScanner.read()) != -1) {
                if (XMLUtils.isSpace((int)n)) continue;
                this.fScanner.unread();
                break;
            }
            return true;
        }
        if (n != -1) {
            this.fScanner.unread();
        }
        return false;
    }

    protected String scanName() {
        int n = 0;
        int n2 = this.fScanner.peekChar();
        if (XMLUtils.isValidNameStartChar((int)n2)) {
            this.fScanner.scanChar();
            this.fNameBuffer[n++] = (char)n2;
            while (XMLUtils.isValidNameChar((int)(n2 = this.fScanner.peekChar()))) {
                this.fScanner.scanChar();
                if (n == this.fNameBuffer.length) {
                    char[] cArray = new char[n << 1];
                    System.arraycopy(this.fNameBuffer, 0, cArray, 0, n);
                    this.fNameBuffer = cArray;
                }
                this.fNameBuffer[n++] = (char)n2;
            }
        }
        if (n > 0) {
            return new String(this.fNameBuffer, 0, n);
        }
        return null;
    }

    protected void scanDecl(boolean bl) {
        int n = -1;
        while (true) {
            int n2 = this.fScanner.read();
            switch (n2) {
                case -1: {
                    return;
                }
                case 62: {
                    if (n != -1) break;
                    return;
                }
                case 34: 
                case 39: {
                    if (n == n2) {
                        n = -1;
                        break;
                    }
                    if (n != -1) break;
                    n = n2;
                    break;
                }
                case 60: {
                    if (bl) {
                        if (n != -1) break;
                        this.fScanner.unread();
                        return;
                    }
                    this.fScanner.unread();
                    return;
                }
            }
        }
    }

    protected void scanComment() {
        int n;
        int n2 = -1;
        int n3 = -1;
        while ((n = this.fScanner.read()) != 62 || n2 != 45 || n3 != 45) {
            n3 = n2;
            n2 = n;
            if (n != -1) continue;
        }
    }

    protected void scanPI() {
        int n;
        int n2 = -1;
        while ((n = this.fScanner.read()) != 62 || n2 != 63) {
            n2 = n;
            if (n != -1) continue;
        }
    }

    protected String scanLiteral() {
        int n = this.fScanner.peekChar();
        if (n == 39 || n == 34) {
            int n2;
            this.fScanner.scanChar();
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = this.fScanner.scanChar()) != n) {
                if (n2 == 60) {
                    this.fScanner.unread();
                    break;
                }
                if (n2 == -1) break;
                stringBuffer.append((char)n2);
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
        }
        return null;
    }

    protected void scanExternalID(String string) {
        if ("PUBLIC".equals(string) || this.fScanner.skipString("PUBLIC")) {
            this.skipSpaces();
            this.scanLiteral();
            this.skipSpaces();
            this.scanLiteral();
        } else if ("SYSTEM".equals(string) || this.fScanner.skipString("SYSTEM")) {
            this.skipSpaces();
            this.scanLiteral();
        }
    }

    protected void scanDTDInternalSubset() {
        while (true) {
            int n = this.fScanner.read();
            switch (n) {
                case -1: {
                    return;
                }
                case 60: {
                    if (this.fScanner.skipChar('!')) {
                        if (this.fScanner.skipString("--")) {
                            this.scanComment();
                        }
                        this.scanDecl(true);
                        break;
                    }
                    if (!this.fScanner.skipChar('?')) break;
                    this.scanPI();
                    break;
                }
                case 93: {
                    do {
                        if ((n = this.fScanner.read()) == 62) {
                            return;
                        }
                        if (n != 60) continue;
                        this.fScanner.unread();
                        return;
                    } while (n != -1);
                }
            }
        }
    }

    protected void scanDoctypeDecl() {
        int n = this.fTokenLength;
        int n2 = this.fScanner.getOffset();
        this.skipSpaces();
        String string = this.scanName();
        if (this.skipSpaces()) {
            this.scanExternalID(string);
            this.skipSpaces();
        }
        if (this.fScanner.skipChar('[')) {
            this.scanDTDInternalSubset();
        } else {
            this.scanDecl(false);
        }
        this.fTokenLength = n + this.fScanner.getOffset() - n2;
    }

    protected boolean isScriptTag(int n) {
        return false;
    }

    protected IToken scanRegExp() {
        int n;
        if (this.fTokenLength == 0) {
            n = this.fScanner.read();
            if (n == -1) {
                this.fPrefixLength = 0;
                return Token.EOF;
            }
            ++this.fTokenLength;
        }
        int n2 = this.fLast;
        boolean bl = false;
        block14: while (true) {
            n = this.fScanner.read();
            ++this.fTokenLength;
            switch (n) {
                case -1: {
                    --this.fTokenLength;
                    break block14;
                }
                case 10: {
                    break block14;
                }
                case 13: {
                    if (n2 == 13) {
                        --this.fTokenLength;
                        return this.preFix(this.fState, this.getParentState(), n, 1);
                    }
                    n2 = n;
                    continue block14;
                }
                case 93: {
                    if (this.fState == 18 && this.fScanner.peekChar() == 93 && this.fScanner.getChar(this.fScanner.getOffset() + 1) == 62) {
                        --this.fTokenLength;
                        return this.preFix(this.fState, this.getParentState(), n, 1);
                    }
                    if (n2 != 92) {
                        bl = false;
                    }
                    n2 = 0;
                    continue block14;
                }
                default: {
                    if (n2 == 92) {
                        n2 = 0;
                        continue block14;
                    }
                    switch (n) {
                        case 91: {
                            bl = true;
                            break;
                        }
                        case 47: {
                            if (bl) break;
                            block15: while (true) {
                                n = this.fScanner.read();
                                switch (n) {
                                    case -1: {
                                        break block14;
                                    }
                                    case 103: 
                                    case 105: 
                                    case 109: {
                                        ++this.fTokenLength;
                                        continue block15;
                                    }
                                }
                                break;
                            }
                            this.fScanner.unread();
                            break block14;
                        }
                    }
                    n2 = n;
                    continue block14;
                }
            }
            break;
        }
        return this.preFix(this.fState, this.getParentState(), 0, 0);
    }

    protected boolean isRegExp(int n) {
        int n2 = this.fScanner.getOffset() - 2 - n;
        while (n2 > 0) {
            int n3 = this.fScanner.getChar(n2--);
            switch (n3) {
                case -1: 
                case 125: {
                    return true;
                }
                case 34: 
                case 39: 
                case 41: 
                case 93: {
                    return false;
                }
                case 43: 
                case 45: {
                    return this.fScanner.getChar(n2) != n3;
                }
            }
            if (n3 >= 48 && n3 <= 57 || Character.isJavaIdentifierPart((char)n3)) {
                return false;
            }
            if (Character.isWhitespace((char)n3)) continue;
            break;
        }
        return true;
    }
}

