/*
 * Decompiled with CFR 0.152.
 */
package com.spket.util;

import com.spket.util.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Debug {
    private static final Logger logger = Logger.global;

    public static void assertTrue(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void assertTrue(boolean bl, String string) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    public static void assertNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
    }

    public static void assertNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void fatal(String string) {
        Debug.log(Level.SEVERE, string, null);
    }

    public static void fatal(String string, Throwable throwable) {
        Debug.log(Level.SEVERE, string, throwable);
    }

    public static void fatal(Throwable throwable) {
        Debug.log(Level.SEVERE, null, throwable);
    }

    public static void error(String string) {
        Debug.log(Level.SEVERE, string, null);
    }

    public static void error(String string, Throwable throwable) {
        Debug.log(Level.SEVERE, string, throwable);
    }

    public static void error(Throwable throwable) {
        Debug.log(Level.SEVERE, null, throwable);
    }

    public static void warn(String string) {
        Debug.log(Level.WARNING, string, null);
    }

    public static void warn(String string, Throwable throwable) {
        Debug.log(Level.WARNING, string, throwable);
    }

    public static void warn(Throwable throwable) {
        Debug.log(Level.WARNING, null, throwable);
    }

    public static void info(String string) {
        Debug.log(Level.INFO, string, null);
    }

    public static void info(String string, Throwable throwable) {
        Debug.log(Level.INFO, string, throwable);
    }

    public static void info(Throwable throwable) {
        Debug.log(Level.INFO, null, throwable);
    }

    public static void debug(String string) {
        Debug.log(Level.INFO, string, null);
    }

    public static void debug(String string, Throwable throwable) {
        Debug.log(Level.INFO, string, throwable);
    }

    public static void debug(Throwable throwable) {
        Debug.log(Level.INFO, null, throwable);
    }

    private static void log(Level level, String string, Throwable throwable) {
        if (logger.isLoggable(level)) {
            Throwable throwable2 = new Throwable();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            String string2 = "unknown";
            String string3 = "unknown";
            if (stackTraceElementArray != null && stackTraceElementArray.length > 2) {
                StackTraceElement stackTraceElement = stackTraceElementArray[2];
                string2 = stackTraceElement.getClassName();
                string3 = stackTraceElement.getMethodName();
            }
            if (string == null) {
                string = StringUtils.EMPTY_STRING;
            }
            if (throwable == null) {
                logger.logp(level, string2, string3, string);
            } else {
                logger.logp(level, string2, string3, string, throwable);
            }
        }
    }

    static {
        logger.setLevel(Level.ALL);
    }
}

