/*
 * Decompiled with CFR 0.152.
 */
package com.spket.laszlo.internal.editors;

import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.js.model.ILexerContext;
import com.spket.js.model.ILexerProvider;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSObject;
import com.spket.js.parser.CompletionEngine;
import com.spket.laszlo.internal.LaszloPlugin;
import com.spket.laszlo.model.DocAdapter;
import com.spket.laszlo.model.LZXDoc;
import com.spket.laszlo.model.LZXModel;
import com.spket.laszlo.model.LaszloLibrary;
import com.spket.laszlo.model.LzDoc;
import com.spket.laszlo.model.LzHelper;
import com.spket.laszlo.model.LzUnit;
import com.spket.laszlo.model.LzUnitManager;
import com.spket.laszlo.text.LZXSourceViewerConfiguration;
import com.spket.laszlo.text.LzClassProvider;
import com.spket.laszlo.text.LzHierarchyInformationControl;
import com.spket.laszlo.text.LzOutlineInformationControl;
import com.spket.mime.editors.MIMETextEditor;
import com.spket.mime.text.MIMEPartitions;
import com.spket.ui.text.IDocumentation;
import com.spket.ui.text.IDocumentationProvider;
import com.spket.ui.text.TextTools;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLComment;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import com.spket.xml.editors.XMLEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class LZXEditor
extends MIMETextEditor
implements IDocumentationProvider {
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fHierarchyPresenter;

    public TextTools getTextTools() {
        return LaszloPlugin.getDefault().getTextTools();
    }

    protected XMLModel createModel() {
        LaszloLibrary.getInstance();
        return new LZXModel();
    }

    public void dispose() {
        LzUnitManager lzUnitManager = LzUnitManager.getDefault();
        lzUnitManager.releaseWorkingCopy(this.getModel());
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.uninstall();
            this.fHierarchyPresenter = null;
        }
        super.dispose();
    }

    public IDocumentation getDocument() {
        int n;
        XMLModel xMLModel = this.getModel();
        if (xMLModel == null) {
            return null;
        }
        ISelectionProvider iSelectionProvider = this.getSelectionProvider();
        if (iSelectionProvider == null) {
            return null;
        }
        ISelection iSelection = iSelectionProvider.getSelection();
        if (iSelection == null) {
            return null;
        }
        if (iSelection instanceof ITextSelection && (n = ((ITextSelection)iSelection).getOffset()) != -1) {
            BufferedScanner bufferedScanner;
            ILexerProvider iLexerProvider = null;
            PositionInfo positionInfo = new PositionInfo();
            XMLUtils.findNode((XMLModel)xMLModel, (int)n, (PositionInfo)positionInfo);
            switch (positionInfo.nodeType) {
                case 3: 
                case 4: 
                case 100: {
                    if (!(xMLModel instanceof ILexerContext) || (iLexerProvider = ((ILexerContext)xMLModel).getLexerProvider(n)) == null || (bufferedScanner = iLexerProvider.getLexer()) == null) break;
                    CompletionEngine completionEngine = new CompletionEngine(iLexerProvider);
                    completionEngine.setLexer(bufferedScanner);
                    ISlot iSlot = completionEngine.select(n);
                    if (iSlot == null) {
                        return null;
                    }
                    return new DocAdapter(completionEngine.getTokenName(), iSlot);
                }
            }
            bufferedScanner = null;
            for (XMLNode xMLNode = positionInfo.node; xMLNode != null; xMLNode = xMLNode.getParent()) {
                short s = xMLNode.getNodeType();
                if (1 == s) {
                    bufferedScanner = (XMLElement)xMLNode;
                    break;
                }
                if (0 == s) break;
            }
            if (bufferedScanner != null) {
                String string = bufferedScanner.getLocalName();
                int n2 = LzHelper.getTagId(string);
                if (11 == n2) {
                    return new LZXDoc((XMLElement)bufferedScanner);
                }
                XMLComment xMLComment = LZXDoc.getComment((XMLNode)bufferedScanner);
                if (xMLComment == null) {
                    LzUnit lzUnit;
                    switch (n2) {
                        case 1: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 40: 
                        case 42: 
                        case 45: 
                        case 54: {
                            return null;
                        }
                    }
                    IPath iPath = xMLModel.getPath();
                    if (iPath != null && (lzUnit = LzUnitManager.getDefault().getUnit(iPath)) != null) {
                        JSObject jSObject = LaszloLibrary.getInstance().getGlobalForEdit();
                        lzUnit.setParentScope(jSObject);
                        ISlot iSlot = lzUnit.getSlot(string);
                        if (iSlot != null) {
                            return new DocAdapter(string, iSlot);
                        }
                    }
                } else {
                    return new LzDoc(xMLComment);
                }
            }
        }
        return null;
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        LzUnitManager lzUnitManager = LzUnitManager.getDefault();
        lzUnitManager.releaseWorkingCopy(this.getModel());
        super.doSetInput(iEditorInput);
        lzUnitManager.becomeWorkingCopy(this.getModel());
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        ISourceViewer iSourceViewer = super.createSourceViewer(composite, iVerticalRuler, n);
        this.fOutlinePresenter = this.createOutlinePresenter(iSourceViewer);
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.install((ITextViewer)iSourceViewer);
        }
        this.fHierarchyPresenter = this.createHierarchyPresenter(iSourceViewer);
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.install((ITextViewer)iSourceViewer);
        }
        return iSourceViewer;
    }

    protected boolean canDoOperation(int n) {
        if (1 == n) {
            return this.fOutlinePresenter != null;
        }
        if (2 == n) {
            return this.fHierarchyPresenter != null;
        }
        return super.canDoOperation(n);
    }

    protected void doOperation(int n) {
        if (1 == n) {
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.showInformation();
            }
            return;
        }
        if (2 == n) {
            if (this.fHierarchyPresenter != null) {
                this.fHierarchyPresenter.showInformation();
            }
            return;
        }
        super.doOperation(n);
    }

    protected IInformationPresenter createOutlinePresenter(ISourceViewer iSourceViewer) {
        InformationPresenter informationPresenter = new InformationPresenter(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = 16;
                int n2 = 768;
                return new LzOutlineInformationControl(shell, n, n2);
            }
        });
        informationPresenter.setDocumentPartitioning(this.getDocumentPartitioning());
        informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        LzClassProvider lzClassProvider = new LzClassProvider((XMLEditor)this);
        String[] stringArray = MIMEPartitions.TYPES;
        for (int i = 0; i < stringArray.length; ++i) {
            informationPresenter.setInformationProvider((IInformationProvider)lzClassProvider, stringArray[i]);
        }
        informationPresenter.setSizeConstraints(50, 20, true, false);
        return informationPresenter;
    }

    protected IInformationPresenter createHierarchyPresenter(ISourceViewer iSourceViewer) {
        InformationPresenter informationPresenter = new InformationPresenter(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = 16;
                int n2 = 768;
                return new LzHierarchyInformationControl(shell, n, n2);
            }
        });
        informationPresenter.setDocumentPartitioning(this.getDocumentPartitioning());
        informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        LzClassProvider lzClassProvider = new LzClassProvider((XMLEditor)this);
        String[] stringArray = MIMEPartitions.TYPES;
        for (int i = 0; i < stringArray.length; ++i) {
            informationPresenter.setInformationProvider((IInformationProvider)lzClassProvider, stringArray[i]);
        }
        informationPresenter.setSizeConstraints(50, 20, true, false);
        return informationPresenter;
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration(IPreferenceStore iPreferenceStore) {
        return new LZXSourceViewerConfiguration(this, this.getTextTools().getColorManager(), iPreferenceStore, this.getDocumentPartitioning());
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] stringArray = super.collectContextMenuPreferencePages();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "com.spket.laszlo.pref.template";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }
}

