/*
 * Decompiled with CFR 0.152.
 */
package com.spket.laszlo.model;

import com.spket.js.model.ICompletionRequestor;
import com.spket.js.model.ISlot;
import com.spket.js.model.JSObject;
import com.spket.js.model.Slot;
import com.spket.laszlo.model.LZXDoc;
import com.spket.laszlo.model.LaszloLibrary;
import com.spket.laszlo.model.LzClass;
import com.spket.laszlo.model.LzUnitManager;
import com.spket.util.StringUtils;
import com.spket.xml.IDOMModel;
import com.spket.xml.INodeRegion;
import com.spket.xml.XMLAttr;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLNode;
import com.spket.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Point;

public class LzUnit
implements JSObject {
    private static final LzUnit[] EMPTY = new LzUnit[0];
    private static LzUnitManager gManager = LzUnitManager.getDefault();
    private Map fClasses;
    private LzUnit[] fIncludes;
    private JSObject fScope;
    private IDOMModel fModel;

    public LzUnit(IDOMModel iDOMModel) {
        this.fModel = iDOMModel;
    }

    public String getClassName() {
        return null;
    }

    public void setClassName(String string) {
    }

    protected JSObject getScope() {
        return this.fScope;
    }

    public JSObject getParentScope() {
        return null;
    }

    public void setParentScope(JSObject jSObject) {
        this.fScope = jSObject;
    }

    public int prototype() {
        return 0;
    }

    public JSObject getPrototype() {
        return null;
    }

    public void setPrototype(JSObject jSObject) {
    }

    public ISlot getLocalSlot(String string) {
        return (ISlot)this.getClasses().get(string);
    }

    public ISlot getSlot(String string) {
        LaszloLibrary laszloLibrary;
        HashSet hashSet = new HashSet();
        ISlot iSlot = this.getSlot(string, hashSet, true);
        if (iSlot == null && this.fScope != null && (iSlot = this.fScope.getSlot(string)) == null && (string = (laszloLibrary = LaszloLibrary.getInstance()).getLzClass(string)) != null) {
            iSlot = this.fScope.getSlot(string);
        }
        return iSlot;
    }

    protected ISlot getSlot(String string, Set set, boolean bl) {
        LzUnit[] lzUnitArray;
        if (this.fModel == null) {
            return null;
        }
        IPath iPath = this.fModel.getPath();
        if (iPath == null || set.contains(iPath)) {
            return null;
        }
        set.add(iPath);
        ISlot iSlot = this.getLocalSlot(string);
        if (iSlot == null && bl && (iPath = (IPath)(lzUnitArray = LzUnitManager.getDefault()).getIncludes().get(string)) != null && !set.contains(iPath)) {
            set.add(iPath);
            LzUnit lzUnit = lzUnitArray.getUnit(iPath);
            if (lzUnit != null) {
                lzUnit.setParentScope(this.getScope());
                iSlot = lzUnit.getLocalSlot(string);
            }
        }
        if (iSlot == null) {
            lzUnitArray = this.getIncludes();
            for (int i = 0; i < lzUnitArray.length && (iSlot = lzUnitArray[i].getSlot(string, set, false)) == null; ++i) {
            }
        }
        return iSlot;
    }

    public JSObject getProperty(String string) {
        ISlot iSlot = this.getSlot(string);
        return iSlot == null ? null : iSlot.getObject();
    }

    public JSObject createProperty(JSObject jSObject, String string) {
        return null;
    }

    public boolean hasProperty(String string) {
        return this.getSlot(string) != null;
    }

    public void setProperty(String string, JSObject jSObject) {
        if (this.fScope != null) {
            this.fScope.setProperty(string, jSObject);
        }
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object object) {
    }

    public void reset(boolean bl) {
        this.fIncludes = null;
        if (this.fClasses != null) {
            if (this.fClasses.size() > 0) {
                this.fClasses.clear();
            }
            this.fClasses = null;
        }
        if (bl) {
            this.fModel = null;
        }
    }

    public void codeComplete(ICompletionRequestor iCompletionRequestor) {
        this.codeComplete(iCompletionRequestor, 0);
    }

    public void codeComplete(ICompletionRequestor iCompletionRequestor, int n) {
        if (iCompletionRequestor.accept((JSObject)this)) {
            Object object;
            Map map = this.getClasses();
            if (map.size() > 0) {
                object = map.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    iCompletionRequestor.accept((JSObject)this, entry.getKey().toString(), (ISlot)entry.getValue());
                }
            }
            object = this.getIncludes();
            for (int i = 0; i < ((Object)object).length; ++i) {
                ((LzUnit)object[i]).codeComplete(iCompletionRequestor, n);
            }
        }
        if (this.fScope != null) {
            this.fScope.codeComplete(iCompletionRequestor, n);
        }
    }

    protected XMLDocument getDocument() {
        if (this.fModel == null) {
            return null;
        }
        return this.fModel.getXMLDocument();
    }

    protected LzUnit[] getIncludes() {
        if (this.fIncludes == null) {
            XMLElement xMLElement = null;
            XMLDocument xMLDocument = this.getDocument();
            if (xMLDocument != null) {
                xMLElement = xMLDocument.getDocumentElement();
            }
            if (xMLElement != null) {
                ArrayList<LzUnit> arrayList = null;
                IPath iPath = this.fModel.getPath();
                int n = xMLElement.getChildrenCount();
                XMLNode[] xMLNodeArray = xMLElement.getChildren();
                for (int i = 0; i < n; ++i) {
                    LzUnit lzUnit;
                    String string;
                    XMLAttr xMLAttr;
                    XMLNode xMLNode = xMLNodeArray[i];
                    if (1 != xMLNode.getNodeType() || !"include".equals(xMLNode.getName()) || (xMLAttr = ((XMLElement)xMLNode).getAttr("href")) == null || (string = StringUtils.makeNullIfEmpty((String)xMLAttr.getValue())) == null) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<LzUnit>(4);
                    }
                    Path path = new Path(string);
                    if ((path = gManager.resolve(iPath, (IPath)path)) == null || (lzUnit = gManager.getUnit((IPath)path)) == null) continue;
                    arrayList.add(lzUnit);
                    lzUnit.setParentScope(this.getScope());
                }
                if (arrayList != null && arrayList.size() > 0) {
                    this.fIncludes = new LzUnit[arrayList.size()];
                    arrayList.toArray(this.fIncludes);
                }
            }
            if (this.fIncludes == null) {
                this.fIncludes = EMPTY;
            }
        }
        return this.fIncludes;
    }

    protected Map getClasses() {
        if (this.fClasses == null) {
            XMLElement xMLElement = null;
            XMLDocument xMLDocument = this.getDocument();
            if (xMLDocument != null) {
                xMLElement = xMLDocument.getDocumentElement();
            }
            if (xMLElement != null) {
                int n = xMLElement.getChildrenCount();
                XMLNode[] xMLNodeArray = xMLElement.getChildren();
                for (int i = 0; i < n; ++i) {
                    String string;
                    XMLNode xMLNode = xMLNodeArray[i];
                    if (1 != xMLNode.getNodeType() || !"class".equals(xMLNode.getName()) || (string = StringUtils.makeNullIfEmpty((String)XMLUtils.getAttrValue((XMLElement)(xMLElement = (XMLElement)xMLNode), (String)"name"))) == null) continue;
                    if (this.fClasses == null) {
                        this.fClasses = new HashMap();
                    }
                    Slot slot = new Slot();
                    LzClass lzClass = new LzClass(string, xMLElement);
                    lzClass.setParentScope(this);
                    slot.setObject((JSObject)lzClass);
                    slot.setData((Object)ISlot.P_SOURCE, (Object)this.fModel.getPath().toPortableString());
                    INodeRegion iNodeRegion = xMLElement.getStartTagRegion();
                    int n2 = iNodeRegion.getStart();
                    slot.setData((Object)ISlot.P_RANGE, (Object)new Point(n2 + 1, n2));
                    slot.setData((Object)ISlot.P_COMMENT, (Object)new LZXDoc(xMLElement));
                    this.fClasses.put(string, slot);
                }
            }
            if (this.fClasses == null) {
                this.fClasses = Collections.EMPTY_MAP;
            }
        }
        return this.fClasses;
    }
}

