/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.EmptyStatement;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.lookup.Frame;

public class IfStatement
extends Statement {
    public Expression condition;
    public Statement thenStatement;
    public Statement elseStatement;

    public IfStatement(Expression expression, Statement statement, int n, int n2) {
        this.condition = expression;
        this.thenStatement = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    public IfStatement(Expression expression, Statement statement, Statement statement2, int n, int n2) {
        this.condition = expression;
        this.thenStatement = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.elseStatement = statement2;
        if (statement2 instanceof IfStatement) {
            statement2.bits |= 0x20000000;
        }
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        IfStatement.printIndent(n, stringBuffer).append("if (");
        this.condition.printExpression(0, stringBuffer).append(")\n");
        this.thenStatement.printStatement(n + 2, stringBuffer);
        if (this.elseStatement != null) {
            stringBuffer.append('\n');
            IfStatement.printIndent(n, stringBuffer);
            stringBuffer.append("else\n");
            this.elseStatement.printStatement(n + 2, stringBuffer);
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (aSTVisitor.visit(this, frame)) {
            this.condition.traverse(aSTVisitor, frame);
            if (this.thenStatement != null) {
                this.thenStatement.traverse(aSTVisitor, frame);
            }
            if (this.elseStatement != null) {
                this.elseStatement.traverse(aSTVisitor, frame);
            }
        }
        aSTVisitor.endVisit(this, frame);
    }
}

