/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.lookup.Frame;

public class InvokeExpression
extends Expression {
    public Expression receiver;
    public Expression[] arguments;

    public InvokeExpression(int n) {
        this.kind = n;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        switch (this.kind) {
            case 50: {
                stringBuffer.append("new ");
                break;
            }
        }
        this.receiver.printExpression(n, stringBuffer);
        if (this.arguments != null) {
            stringBuffer.append('(');
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[i].printExpression(n, stringBuffer);
            }
            stringBuffer.append(')');
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (aSTVisitor.visit(this, frame)) {
            if (this.receiver != null) {
                this.receiver.traverse(aSTVisitor, frame);
            }
            if (this.arguments != null) {
                int n = this.arguments.length;
                for (int i = 0; i < n; ++i) {
                    this.arguments[i].traverse(aSTVisitor, frame);
                }
            }
        }
        aSTVisitor.endVisit(this, frame);
    }
}

