/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.parser;

import com.spket.as.core.compiler.InvalidInputException;
import com.spket.as.internal.compiler.parser.Scanner;
import com.spket.as.internal.compiler.parser.ScannerHelper;

public class BufferedScanner
extends Scanner {
    private int count;
    private Token[] tokens;
    private boolean inited;
    private int sourceOffset;
    private int start;
    private int end;
    private int offset;
    private char[] buf;
    private boolean isVirtualSemicolon;
    private int threshold = 64;
    private int increment = 16;

    public BufferedScanner(int n) {
        super(n);
    }

    public BufferedScanner(int n, char[][] cArray, char[][] cArray2, boolean bl) {
        super(false, false, false, n, cArray, cArray2, bl);
    }

    public BufferedScanner(BufferedScanner bufferedScanner, int n, int n2) {
        super(bufferedScanner.sourceLevel);
        this.source = bufferedScanner.source;
        this.linePtr = bufferedScanner.linePtr;
        this.lineEnds = bufferedScanner.lineEnds;
        this.commentPtr = bufferedScanner.commentPtr;
        if (this.commentPtr == -1) {
            this.commentStarts = bufferedScanner.commentStarts;
            this.commentStops = bufferedScanner.commentStops;
            this.commentTagStarts = bufferedScanner.commentTagStarts;
        } else {
            int n3 = this.commentPtr + 1;
            this.commentStarts = new int[n3];
            this.commentStops = new int[n3];
            this.commentTagStarts = new int[n3];
            System.arraycopy(bufferedScanner.commentStarts, 0, this.commentStarts, 0, n3);
            System.arraycopy(bufferedScanner.commentStops, 0, this.commentStops, 0, n3);
            System.arraycopy(bufferedScanner.commentTagStarts, 0, this.commentTagStarts, 0, n3);
        }
        this.inited = true;
        this.count = bufferedScanner.count;
        this.tokens = bufferedScanner.tokens;
        this.setRange(n, n2);
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.offset = n;
        this.start = n;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getSourceOffset() {
        return this.sourceOffset;
    }

    public void setSourceOffset(int n) {
        this.sourceOffset = n;
    }

    public int getSize() {
        if (!this.inited) {
            this.prepare();
        }
        return this.count;
    }

    public int getLength() {
        if (this.start != -1) {
            return this.end - this.start;
        }
        return 0;
    }

    public void setRange(int n, int n2) {
        this.offset = n;
        this.start = n;
        this.end = n2;
    }

    public int getTokenIndex(int n) {
        if (!this.inited) {
            this.prepare();
        }
        if (this.count > 0) {
            int n2 = 0;
            int n3 = this.count - 1;
            while (n2 <= n3) {
                int n4 = n2 + n3 >> 1;
                Token token = this.tokens[n4];
                if (n < token.start) {
                    n3 = n4 - 1;
                    continue;
                }
                if (n > token.end) {
                    n2 = n4 + 1;
                    continue;
                }
                return n < token.end ? n4 : n4 + 1;
            }
            return n2;
        }
        return this.count;
    }

    public int getToken(int n) {
        if (!this.inited) {
            this.prepare();
        }
        if (n < this.count) {
            return this.tokens[n].token;
        }
        return 45;
    }

    public char[] getTokenSource(int n) {
        char[] cArray = null;
        if (n < this.count) {
            Token token = this.tokens[n];
            cArray = token.source;
            if (cArray == null) {
                cArray = new char[token.end - token.start];
                System.arraycopy(this.source, token.start, cArray, 0, cArray.length);
            }
        }
        return cArray;
    }

    public char[] getTokenSourceString(int n) {
        char[] cArray = null;
        if (n < this.count) {
            Token token = this.tokens[n];
            cArray = new char[token.end - token.start - 2];
            if (token.source == null) {
                System.arraycopy(this.source, token.start + 1, cArray, 0, cArray.length);
            } else {
                System.arraycopy(token.source, 1, cArray, 0, cArray.length);
            }
        }
        return cArray;
    }

    public int getTokenStart(int n) {
        if (n < this.count) {
            return this.tokens[n].start;
        }
        return -1;
    }

    public int getTokenEnd(int n) {
        if (n < this.count) {
            return this.tokens[n].end - 1;
        }
        return -1;
    }

    public void pushBack() {
        if (this.offset > this.start) {
            --this.offset;
        }
    }

    public int getNextToken() {
        if (!this.inited) {
            this.prepare();
        }
        if (this.offset < this.end) {
            Token token = this.tokens[this.offset++];
            this.buf = token.source;
            this.crPos = this.isVirtualSemicolon ? 0 : token.crPos;
            this.isVirtualSemicolon = false;
            this.startPosition = token.start;
            this.currentPosition = token.end;
            return token.token;
        }
        return 45;
    }

    public int next() {
        if (!this.inited) {
            this.prepare();
        }
        if (this.offset < this.end) {
            return this.tokens[this.offset++].token;
        }
        return 45;
    }

    public int peek() {
        if (!this.inited) {
            this.prepare();
        }
        if (this.offset < this.end) {
            return this.tokens[this.offset].token;
        }
        return 45;
    }

    public void unget() {
        --this.offset;
    }

    public boolean sameLine(int n) {
        if (n < this.end) {
            return this.tokens[n].crPos == 0;
        }
        return false;
    }

    public void insertVirtualSemicolon() {
        --this.offset;
        this.isVirtualSemicolon = true;
    }

    public void setSource(char[] cArray) {
        this.inited = false;
        this.offset = 0;
        this.start = 0;
        this.end = 0;
        if (this.count > 0) {
            for (int i = 0; i < this.count; ++i) {
                this.tokens[i] = null;
            }
            this.count = 0;
        }
        super.setSource(cArray);
    }

    public char[] getCurrentIdentifierSource() {
        if (this.inited && this.buf != null) {
            return this.buf;
        }
        return super.getCurrentIdentifierSource();
    }

    public char[] getCurrentTokenSource() {
        if (this.inited && this.buf != null) {
            return this.buf;
        }
        return super.getCurrentTokenSource();
    }

    public char[] getCurrentTokenSourceString() {
        if (this.inited && this.buf != null) {
            char[] cArray = new char[this.buf.length - 2];
            System.arraycopy(this.buf, 2, cArray, 0, this.buf.length - 2);
            return cArray;
        }
        return super.getCurrentTokenSourceString();
    }

    public void prepare() {
        if (this.inited) {
            return;
        }
        int n = 0;
        int n2 = 0;
        this.offset = 0;
        this.start = 0;
        this.end = 0;
        this.count = 0;
        this.threshold = this.eofPosition * 3 / 4;
        this.increment = Math.max(16, this.eofPosition / 64);
        if (this.tokens == null) {
            this.tokens = new Token[Math.max(16, this.eofPosition / 10)];
        }
        boolean bl = (this.sourceLevel & 2) != 0;
        block6: while (true) {
            try {
                while (true) {
                    n2 = super.getNextToken();
                    switch (n2) {
                        case 45: {
                            break block6;
                        }
                        case 10: 
                        case 89: {
                            if (bl && (ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[n] & 0x300000) == 0) {
                                n2 = this.scanRegExp();
                            }
                        }
                        default: {
                            n = n2;
                            this.addToken(n);
                            break;
                        }
                    }
                }
            }
            catch (InvalidInputException invalidInputException) {
                n = 116;
                this.addToken(116);
                continue;
            }
            break;
        }
        this.end = this.count;
        this.inited = true;
        this.withoutUnicodePtr = 0;
    }

    private void addToken(int n) {
        Object object;
        if (this.count >= this.tokens.length) {
            object = this.currentPosition * 2 < this.eofPosition ? new Token[this.count * 2] : (this.currentPosition < this.threshold ? new Token[this.count * 3 / 2 + 1] : new Token[this.count + this.increment]);
            System.arraycopy(this.tokens, 0, object, 0, this.count);
            this.tokens = object;
        }
        object = new Token();
        this.tokens[this.count++] = object;
        object.token = n;
        object.crPos = this.crPos;
        object.start = this.startPosition;
        object.end = this.currentPosition;
        if (n != 116 && this.withoutUnicodePtr != 0) {
            object.source = this.getCurrentTokenSource();
        }
    }

    private static class Token {
        public int token;
        public int crPos;
        public int start;
        public int end;
        public char[] source;

        private Token() {
        }
    }
}

