/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.util;

public final class HashtableOfInt {
    public int[] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfInt() {
        this(13);
    }

    public HashtableOfInt(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new int[n2];
        this.valueTable = new Object[n2];
    }

    public boolean containsKey(int n) {
        int n2;
        int n3 = n % this.valueTable.length;
        while ((n2 = this.keyTable[n3]) != 0) {
            if (n2 == n) {
                return true;
            }
            n3 = (n3 + 1) % this.keyTable.length;
        }
        return false;
    }

    public Object get(int n) {
        int n2;
        int n3 = n % this.valueTable.length;
        while ((n2 = this.keyTable[n3]) != 0) {
            if (n2 == n) {
                return this.valueTable[n3];
            }
            n3 = (n3 + 1) % this.keyTable.length;
        }
        return null;
    }

    public Object put(int n, Object object) {
        int n2;
        int n3 = n % this.valueTable.length;
        while ((n2 = this.keyTable[n3]) != 0) {
            if (n2 == n) {
                this.valueTable[n3] = object;
                return this.valueTable[n3];
            }
            n3 = (n3 + 1) % this.keyTable.length;
        }
        this.keyTable[n3] = n;
        this.valueTable[n3] = object;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object;
    }

    private void rehash() {
        HashtableOfInt hashtableOfInt = new HashtableOfInt(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            int n2 = this.keyTable[n];
            if (n2 == 0) continue;
            hashtableOfInt.put(n2, this.valueTable[n]);
        }
        this.keyTable = hashtableOfInt.keyTable;
        this.valueTable = hashtableOfInt.valueTable;
        this.threshold = hashtableOfInt.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n = this.valueTable.length;
        for (int i = 0; i < n; ++i) {
            Object object = this.valueTable[i];
            if (object == null) continue;
            string = string + this.keyTable[i] + " -> " + object.toString() + "\n";
        }
        return string;
    }
}

