/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xul.internal.editors;

import com.spket.js.model.Context;
import com.spket.mime.editors.MIMETextEditor;
import com.spket.mime.text.MIMEPartitions;
import com.spket.ui.text.TextTools;
import com.spket.xml.XMLModel;
import com.spket.xpc.model.Typelib15;
import com.spket.xul.internal.XULPlugin;
import com.spket.xul.internal.actions.ImplementationAction;
import com.spket.xul.internal.text.XBLClassProvider;
import com.spket.xul.internal.text.XBLHierarchyInformationControl;
import com.spket.xul.internal.text.XBLOutlineInformationControl;
import com.spket.xul.internal.text.XULSourceViewerConfiguration;
import com.spket.xul.model.XULModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class XULEditor
extends MIMETextEditor {
    private ImplementationAction fImplAction;
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fHierarchyPresenter;

    public TextTools getTextTools() {
        return XULPlugin.getDefault().getTextTools();
    }

    public void dispose() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.uninstall();
            this.fHierarchyPresenter = null;
        }
        super.dispose();
    }

    protected XMLModel createModel() {
        return new XULModel();
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.doSetInput(iEditorInput);
        XMLModel xMLModel = this.getModel();
        if (xMLModel == null) {
            Typelib15.getInstance();
        } else {
            Context context = XULModel.getContext(xMLModel);
            if (context != null) {
                context.initialize();
            }
        }
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration(IPreferenceStore iPreferenceStore) {
        return new XULSourceViewerConfiguration(this, this.getTextTools().getColorManager(), iPreferenceStore, this.getDocumentPartitioning());
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        ISourceViewer iSourceViewer = super.createSourceViewer(composite, iVerticalRuler, n);
        this.fOutlinePresenter = this.createOutlinePresenter(iSourceViewer);
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.install((ITextViewer)iSourceViewer);
        }
        this.fHierarchyPresenter = this.createHierarchyPresenter(iSourceViewer);
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.install((ITextViewer)iSourceViewer);
        }
        return iSourceViewer;
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] stringArray = super.collectContextMenuPreferencePages();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "com.spket.xul.pref.template";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    protected void createActions() {
        super.createActions();
        this.fImplAction = new ImplementationAction(this);
        this.setAction("ImplementationAction", (IAction)this.fImplAction);
        this.markAsStateDependentAction("ImplementationAction", true);
    }

    public void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        iMenuManager.appendToGroup("group.edit", (IAction)this.fImplAction);
    }

    protected boolean canDoOperation(int n) {
        if (1 == n) {
            return this.fOutlinePresenter != null;
        }
        if (2 == n) {
            return this.fHierarchyPresenter != null;
        }
        return super.canDoOperation(n);
    }

    protected void doOperation(int n) {
        if (1 == n) {
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.showInformation();
            }
            return;
        }
        if (2 == n) {
            if (this.fHierarchyPresenter != null) {
                this.fHierarchyPresenter.showInformation();
            }
            return;
        }
        super.doOperation(n);
    }

    protected IInformationPresenter createOutlinePresenter(ISourceViewer iSourceViewer) {
        InformationPresenter informationPresenter = new InformationPresenter(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = 16;
                int n2 = 768;
                return new XBLOutlineInformationControl(shell, n, n2);
            }
        });
        informationPresenter.setDocumentPartitioning(this.getDocumentPartitioning());
        informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        XBLClassProvider xBLClassProvider = new XBLClassProvider(this);
        String[] stringArray = MIMEPartitions.TYPES;
        for (int i = 0; i < stringArray.length; ++i) {
            informationPresenter.setInformationProvider((IInformationProvider)xBLClassProvider, stringArray[i]);
        }
        informationPresenter.setSizeConstraints(50, 20, true, false);
        return informationPresenter;
    }

    protected IInformationPresenter createHierarchyPresenter(ISourceViewer iSourceViewer) {
        InformationPresenter informationPresenter = new InformationPresenter(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = 16;
                int n2 = 768;
                return new XBLHierarchyInformationControl(shell, n, n2);
            }
        });
        informationPresenter.setDocumentPartitioning(this.getDocumentPartitioning());
        informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        XBLClassProvider xBLClassProvider = new XBLClassProvider(this);
        String[] stringArray = MIMEPartitions.TYPES;
        for (int i = 0; i < stringArray.length; ++i) {
            informationPresenter.setInformationProvider((IInformationProvider)xBLClassProvider, stringArray[i]);
        }
        informationPresenter.setSizeConstraints(50, 20, true, false);
        return informationPresenter;
    }
}

