/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xul.model;

import com.spket.buffer.BufferChangedEvent;
import com.spket.js.model.Context;
import com.spket.js.model.ILexerContext;
import com.spket.js.model.ILexerProvider;
import com.spket.mime.text.LexerProvider;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLElement;
import com.spket.xml.XMLModel;
import com.spket.xml.XMLNode;
import com.spket.xpc.model.Typelib;
import com.spket.xpc.model.Typelib15;
import com.spket.xul.internal.XULImages;
import com.spket.xul.internal.XULPlugin;
import com.spket.xul.model.XBLLexerProvider;
import com.spket.xul.model.XULHelper;
import com.spket.xul.model.XULLexerProvider;
import org.apache.xerces.util.SymbolTable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

public class XULModel
extends XMLModel
implements ILexerContext {
    public static SymbolTable gSymbolTable = new SymbolTable();
    private LexerProvider fProvider;

    public static Context getContext(XMLModel xMLModel) {
        ProjectScope projectScope;
        IEclipsePreferences iEclipsePreferences;
        String string = null;
        IProject iProject = xMLModel.getProject();
        if (iProject != null && (iEclipsePreferences = (projectScope = new ProjectScope(iProject)).getNode("com.spket.js")) != null) {
            string = iEclipsePreferences.get("js.profile", null);
        }
        if (string != null && (projectScope = Context.getContext(string)) instanceof Typelib) {
            return projectScope;
        }
        return Typelib15.getInstance();
    }

    public SymbolTable getSymbolTable() {
        return gSymbolTable;
    }

    public Image getImage(Object object) {
        String string;
        if (object instanceof XMLElement && (string = ((XMLElement)object).getLocalName()) != null) {
            return XULImages.get(string);
        }
        return null;
    }

    public ILexerProvider getLexerProvider(int n) {
        XMLElement xMLElement;
        if (this.fProvider != null && n >= this.fProvider.getStart() && n <= this.fProvider.getEnd()) {
            return this.fProvider;
        }
        this.fProvider = null;
        XMLDocument xMLDocument = this.getXMLDocument();
        if (xMLDocument != null && (xMLElement = xMLDocument.getDocumentElement()) != null) {
            String string = xMLElement.getNamespace();
            this.fProvider = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul".equals(string) ? new XULLexerProvider(this, n) : new XBLLexerProvider(this, n);
        }
        return this.fProvider;
    }

    public Template[] getTemplates(String string) {
        return XULPlugin.getDefault().getTemplateStore().getTemplates();
    }

    public TemplateContextType getContextType(PositionInfo positionInfo) {
        short s;
        String string = null;
        for (XMLNode xMLNode = positionInfo.node; xMLNode != null; xMLNode = xMLNode.getParent()) {
            s = xMLNode.getNodeType();
            if (1 != s) continue;
            string = xMLNode.getNamespace();
            break;
        }
        s = 0;
        if (string == null) {
            IPath iPath = this.getPath();
            if (iPath != null && "xul".equals(iPath.getFileExtension())) {
                s = 1;
            }
        } else {
            s = (short)("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul".equals(string) ? 1 : 0);
        }
        return XULPlugin.getDefault().getTemplateContextRegistry().getContextType(s != 0 ? "xul" : "xbl");
    }

    protected void onBufferAboutToBeChanged(BufferChangedEvent bufferChangedEvent) {
        this.fProvider = null;
        super.onBufferAboutToBeChanged(bufferChangedEvent);
    }

    static {
        XULHelper.initSymbolTable(gSymbolTable);
    }
}

