/*
 * Decompiled with CFR 0.152.
 */
package com.spket.buffer;

import com.spket.buffer.CharBuffer;
import com.spket.buffer.DocumentBuffer;
import com.spket.buffer.IBuffer;
import com.spket.buffer.IBufferProvider;
import com.spket.buffer.IURIResolver;
import com.spket.buffer.ZipPath;
import com.spket.ui.internal.UIPlugin;
import com.spket.ui.util.Compatibility;
import com.spket.util.Debug;
import com.spket.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.IDocument;

public class BufferManager {
    private static final int F_ERROR = 1;
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static BufferManager manager;
    private IURIResolver[] resolvers;
    private Map buffers = new HashMap();
    private IBufferProvider bufferProvider;
    private ITextFileBufferManager bufferManager;
    private BufferListener fListener;

    public static synchronized BufferManager getDefault() {
        if (manager == null) {
            manager = new BufferManager();
        }
        return manager;
    }

    private BufferManager() {
        this.startup();
    }

    private void startup() {
        IWorkspace iWorkspace = null;
        try {
            iWorkspace = ResourcesPlugin.getWorkspace();
            if (iWorkspace != null) {
                this.fListener = new BufferListener();
                iWorkspace.addResourceChangeListener((IResourceChangeListener)this.fListener);
                this.bufferManager = FileBuffers.getTextFileBufferManager();
                if (this.bufferManager != null) {
                    this.bufferManager.addFileBufferListener((IFileBufferListener)this.fListener);
                    this.bufferProvider = Compatibility.createBufferProvider();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.initializeResolvers();
    }

    public IBuffer getBuffer(IPath iPath) {
        BufferInfo bufferInfo = this.getBufferInfo(iPath, true);
        ++bufferInfo.count;
        this.checkBuffer(bufferInfo);
        return bufferInfo.buffer;
    }

    public void releaseBuffer(IPath iPath) {
        this.releaseBuffer(iPath, false);
    }

    protected void releaseBuffer(IPath iPath, boolean bl) {
        BufferInfo bufferInfo = this.getBufferInfo(iPath, false);
        if (bufferInfo != null) {
            --bufferInfo.count;
            if (bl && bufferInfo.buffer != null) {
                bufferInfo.buffer.close();
                bufferInfo.buffer = null;
            }
            if (bufferInfo.count <= 0) {
                this.buffers.remove(bufferInfo.path);
                if (bufferInfo.buffer != null) {
                    bufferInfo.buffer.close();
                    bufferInfo.buffer = null;
                }
            }
        }
    }

    protected void setDirty(IPath iPath) {
        BufferInfo bufferInfo = this.getBufferInfo(iPath, false);
        if (bufferInfo != null) {
            if (bufferInfo.buffer != null && !(bufferInfo.buffer instanceof DocumentBuffer)) {
                bufferInfo.buffer.close();
                bufferInfo.buffer = null;
            }
            bufferInfo.state &= 0xFFFFFFFE;
        }
    }

    public IPath resolve(IPath iPath) {
        for (int i = 0; i < this.resolvers.length; ++i) {
            IPath iPath2 = this.resolvers[i].resolve(iPath);
            if (iPath2 == null || iPath2 == iPath) continue;
            return iPath2;
        }
        return iPath;
    }

    public IPath resolve(IPath iPath, IPath iPath2, Map map) {
        for (int i = 0; i < this.resolvers.length; ++i) {
            IPath iPath3 = this.resolvers[i].resolve(iPath, iPath2, map);
            if (iPath3 == null || iPath3 == iPath) continue;
            return iPath3;
        }
        return iPath;
    }

    protected BufferInfo getBufferInfo(IPath iPath, boolean bl) {
        BufferInfo bufferInfo = (BufferInfo)this.buffers.get(iPath);
        if (bl && bufferInfo == null) {
            bufferInfo = new BufferInfo();
            bufferInfo.path = iPath;
            this.buffers.put(iPath, bufferInfo);
        }
        return bufferInfo;
    }

    protected void checkBuffer(BufferInfo bufferInfo) {
        Object object;
        if ((bufferInfo.state & 1) != 0) {
            return;
        }
        if (bufferInfo.buffer != null) {
            return;
        }
        if (this.bufferManager != null && (object = this.bufferProvider.getTextFileBuffer(bufferInfo.path)) != null) {
            IDocument iDocument = object.getDocument();
            if (iDocument == null) {
                Debug.warn((String)("No document: " + bufferInfo.path.toString()));
            } else {
                bufferInfo.buffer = new DocumentBuffer(bufferInfo.path, iDocument);
            }
        }
        if (bufferInfo.buffer == null) {
            try {
                object = this.getContents(bufferInfo.path);
                if (object == null) {
                    bufferInfo.state |= 1;
                } else {
                    bufferInfo.buffer = new CharBuffer(bufferInfo.path, (char[])object);
                }
            }
            catch (Exception exception) {
                bufferInfo.state |= 1;
                Debug.debug((Throwable)exception);
            }
        }
    }

    protected IFileStore getFileStore(IPath iPath) throws CoreException {
        String string = iPath.getDevice();
        if (string == null) {
            URI uRI;
            IWorkspaceRoot iWorkspaceRoot;
            IFile iFile;
            if (iPath.segmentCount() > 1 && (iFile = (iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).exists(iPath) ? iWorkspaceRoot.getFile(iPath) : iWorkspaceRoot.getFileForLocation(iPath)) != null && iFile.exists() && (uRI = iFile.getLocationURI()) != null) {
                return EFS.getStore((URI)uRI);
            }
        } else if ("jar:".equals(string)) {
            return null;
        }
        return EFS.getLocalFileSystem().getStore(iPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] getContents(IPath iPath) throws CoreException, IOException {
        block15: {
            InputStream inputStream = null;
            try {
                Object object;
                QualifiedName[] qualifiedNameArray;
                IFileStore iFileStore = this.getFileStore(iPath);
                if (iFileStore == null) {
                    ZipFile zipFile;
                    if (iPath instanceof ZipPath && (qualifiedNameArray = (zipFile = new ZipFile(((ZipPath)(object = (ZipPath)iPath)).getFileName())).getEntry(((ZipPath)object).getEntryName())) != null) {
                        inputStream = zipFile.getInputStream((ZipEntry)qualifiedNameArray);
                    }
                } else {
                    object = iFileStore.fetchInfo();
                    if (object != null && object.exists() && !object.isDirectory()) {
                        inputStream = iFileStore.openInputStream(0, null);
                    }
                }
                if (inputStream == null) break block15;
                object = null;
                boolean bl = false;
                inputStream = FileUtils.cache((InputStream)inputStream);
                try {
                    qualifiedNameArray = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                    IContentDescription iContentDescription = Platform.getContentTypeManager().getDescriptionFor(inputStream, iPath.lastSegment(), qualifiedNameArray);
                    if (iContentDescription != null) {
                        bl = iContentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK) != null;
                        object = iContentDescription.getCharset();
                    }
                }
                finally {
                    inputStream.reset();
                }
                if (object == null) {
                    object = this.bufferManager.getDefaultEncoding();
                }
                if (bl && CHARSET_UTF_8.equals(object)) {
                    int n;
                    int n2 = 0;
                    do {
                        if ((n = inputStream.read(new byte[IContentDescription.BOM_UTF_8.length])) != -1) continue;
                        throw new IOException();
                    } while ((n2 += n) < IContentDescription.BOM_UTF_8.length);
                }
                char[] cArray = new FileUtils().getContents((Reader)new InputStreamReader(inputStream, (String)object));
                return cArray;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return null;
    }

    private void initializeResolvers() {
        if (this.resolvers != null) {
            return;
        }
        ArrayList<IURIResolver> arrayList = new ArrayList<IURIResolver>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.spket.ui.editorConfigurations");
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            if (!"resolver".equals(iConfigurationElementArray[i].getName())) continue;
            try {
                arrayList.add((IURIResolver)iConfigurationElementArray[i].createExecutableExtension("class"));
                continue;
            }
            catch (CoreException coreException) {
                UIPlugin.log(coreException);
                continue;
            }
            catch (RuntimeException runtimeException) {
                UIPlugin.log(runtimeException);
            }
        }
        this.resolvers = new IURIResolver[arrayList.size()];
        if (this.resolvers.length > 0) {
            arrayList.toArray(this.resolvers);
        }
    }

    private class BufferListener
    implements IResourceDeltaVisitor,
    IResourceChangeListener,
    IFileBufferListener {
        private BufferListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            if (iResourceDelta != null) {
                try {
                    iResourceDelta.accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException coreException) {
                    UIPlugin.log(coreException.getStatus());
                }
            }
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            if (iResourceDelta == null) {
                return false;
            }
            IResource iResource = iResourceDelta.getResource();
            if (iResource != null) {
                if (iResource.getType() == 1) {
                    switch (iResourceDelta.getKind()) {
                        case 4: 
                        case 262144: {
                            BufferManager.this.setDirty(iResource.getFullPath());
                            break;
                        }
                        case 2: {
                            BufferManager.this.releaseBuffer(iResource.getFullPath(), true);
                        }
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer iFileBuffer) {
        }

        public void bufferContentReplaced(IFileBuffer iFileBuffer) {
        }

        public void bufferCreated(IFileBuffer iFileBuffer) {
            if (iFileBuffer instanceof ITextFileBuffer) {
                BufferInfo bufferInfo = BufferManager.this.getBufferInfo(iFileBuffer.getLocation(), true);
                ++bufferInfo.count;
                if (bufferInfo.buffer != null) {
                    bufferInfo.buffer.close();
                    bufferInfo.buffer = null;
                }
                bufferInfo.state &= 0xFFFFFFFE;
            }
        }

        public void bufferDisposed(IFileBuffer iFileBuffer) {
            if (iFileBuffer instanceof ITextFileBuffer) {
                BufferManager.this.releaseBuffer(iFileBuffer.getLocation(), true);
            }
        }

        public void dirtyStateChanged(IFileBuffer iFileBuffer, boolean bl) {
        }

        public void stateChangeFailed(IFileBuffer iFileBuffer) {
        }

        public void stateChanging(IFileBuffer iFileBuffer) {
        }

        public void stateValidationChanged(IFileBuffer iFileBuffer, boolean bl) {
        }

        public void underlyingFileDeleted(IFileBuffer iFileBuffer) {
            BufferManager.this.releaseBuffer(iFileBuffer.getLocation(), true);
        }

        public void underlyingFileMoved(IFileBuffer iFileBuffer, IPath iPath) {
            BufferManager.this.releaseBuffer(iFileBuffer.getLocation(), true);
            BufferManager.this.setDirty(iPath);
        }
    }

    private static final class BufferInfo {
        public int count;
        public int state;
        public IPath path;
        public IBuffer buffer;

        private BufferInfo() {
        }
    }
}

