/*
 * Decompiled with CFR 0.152.
 */
package com.spket.buffer;

import com.spket.buffer.IBufferProvider;
import com.spket.util.Debug;
import java.net.URI;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class BufferProvider
implements IBufferProvider {
    private ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();

    public ITextFileBuffer getTextFileBuffer(IPath iPath) {
        ITextFileBuffer iTextFileBuffer = this.manager.getTextFileBuffer(iPath, LocationKind.LOCATION);
        if (iTextFileBuffer == null) {
            IFileStore iFileStore = null;
            URI uRI = URIUtil.toURI((IPath)iPath);
            try {
                iFileStore = EFS.getStore((URI)uRI);
            }
            catch (CoreException coreException) {
                Debug.debug((Throwable)coreException);
            }
            if (iFileStore != null) {
                iTextFileBuffer = this.manager.getFileStoreTextFileBuffer(iFileStore);
            }
        }
        return iTextFileBuffer;
    }
}

