/*
 * Decompiled with CFR 0.152.
 */
package com.spket.buffer;

import com.spket.buffer.CharBufferReader;
import com.spket.buffer.IBuffer;
import com.spket.buffer.IBufferListener;
import com.spket.buffer.IBufferReader;
import com.spket.util.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;

public class CharBuffer
implements IBuffer {
    private IPath path;
    private char[] source;
    private ListenerList fListeners;

    public CharBuffer(IPath iPath, char[] cArray) {
        this.path = iPath;
        this.source = cArray == null ? StringUtils.EMPTY_CHARS : cArray;
    }

    public void close() {
        this.source = StringUtils.EMPTY_CHARS;
        if (this.fListeners != null) {
            Object[] objectArray = this.fListeners.getListeners();
            this.fListeners.clear();
            this.fListeners = null;
            for (int i = 0; i < objectArray.length; ++i) {
                ((IBufferListener)objectArray[i]).bufferClosed(this);
            }
        }
    }

    public int getLength() {
        return this.source.length;
    }

    public char[] get() {
        return this.source;
    }

    public char get(int n) {
        return this.source[n];
    }

    public String get(int n, int n2) {
        return new String(this.source, n, n2);
    }

    public IPath getPath() {
        return this.path;
    }

    public IBufferReader createReader() {
        return new CharBufferReader(this.source, 0);
    }

    public IBufferReader createReader(int n, int n2) {
        return new CharBufferReader(this.source, n, n2);
    }

    public void addBufferListener(IBufferListener iBufferListener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList(1);
        }
        this.fListeners.add((Object)iBufferListener);
    }

    public void removeBufferListener(IBufferListener iBufferListener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove((Object)iBufferListener);
        if (this.fListeners.isEmpty()) {
            this.fListeners = null;
        }
    }
}

