/*
 * Decompiled with CFR 0.152.
 */
package com.spket.buffer;

import com.spket.buffer.IBufferReader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DocumentReader
implements IBufferReader {
    private static final int BUFFER_SIZE = 2048;
    private int fRangeOffset;
    private int fRangeEnd;
    private IDocument fDocument;
    private int fOffset;
    private int fBufferOffset;
    private int fBufferLength;
    private char[] fBuffer;

    public DocumentReader(IDocument iDocument, int n, int n2) {
        this(iDocument, n, n2, 2048);
    }

    public DocumentReader(IDocument iDocument, int n, int n2, int n3) {
        this.fDocument = iDocument;
        this.fRangeOffset = n;
        this.fRangeEnd = n + n2;
        n3 = Math.min(n2, n3);
        if (n3 == 0) {
            n3 = 1;
        }
        this.fBuffer = new char[n3];
        this.updateBuffer(n);
    }

    public String get(int n, int n2) {
        if (n < 0 || n2 == 0 || n + n2 > this.fDocument.getLength()) {
            return null;
        }
        if (n >= this.fBufferOffset && n + n2 < this.fBufferOffset + this.fBufferLength) {
            return new String(this.fBuffer, n - this.fBufferOffset, n2);
        }
        if (n >= this.fRangeOffset && n + n2 < this.fRangeEnd) {
            try {
                return this.fDocument.get(n, n2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    public int get(int n) {
        if (n >= this.fBufferOffset && n < this.fBufferOffset + this.fBufferLength) {
            char c = this.fBuffer[n - this.fBufferOffset];
            return c;
        }
        if (n >= this.fRangeOffset && n < this.fRangeEnd) {
            try {
                return this.fDocument.getChar(n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getOffset() {
        return this.fBufferOffset + this.fOffset;
    }

    public int peek() {
        if (this.fOffset == this.fBufferLength) {
            if (this.fBufferOffset + this.fBufferLength >= this.fRangeEnd) {
                return -1;
            }
            try {
                return this.fDocument.getChar(this.fBufferOffset + this.fBufferLength);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return this.fBuffer[this.fOffset];
    }

    public int read() {
        if (this.fOffset == this.fBufferLength) {
            if (this.fBufferOffset + this.fBufferLength == this.fRangeEnd) {
                return -1;
            }
            this.updateBuffer(this.fBufferOffset + this.fBufferLength);
            this.fOffset = 0;
        }
        return this.fBuffer[this.fOffset++];
    }

    public boolean skip(char c) {
        int n = this.peek();
        if (n == c) {
            this.read();
            return true;
        }
        return false;
    }

    public boolean skip(char[] cArray) {
        int n = cArray.length;
        if (this.fOffset + n >= this.fBufferLength) {
            if (this.fBufferOffset + this.fOffset + n < this.fRangeEnd) {
                this.updateBuffer(this.fBufferOffset + this.fOffset);
                this.fOffset = 0;
            } else {
                return false;
            }
        }
        if (this.fOffset + n < this.fBufferLength) {
            int n2 = this.fOffset;
            for (int i = 0; i < n; ++i) {
                if (this.fBuffer[n2++] == cArray[i]) continue;
                return false;
            }
            this.fOffset += n;
        }
        return true;
    }

    public void unread() {
        if (this.fOffset == 0) {
            if (this.fBufferOffset != this.fRangeOffset) {
                this.updateBuffer(this.fBufferOffset - this.fBuffer.length);
                this.fOffset = this.fBuffer.length - 1;
            }
        } else {
            --this.fOffset;
        }
    }

    private final void updateBuffer(int n) {
        this.fBufferOffset = n;
        this.fBufferLength = this.fBufferOffset + this.fBuffer.length > this.fRangeEnd ? this.fRangeEnd - this.fBufferOffset : this.fBuffer.length;
        if (this.fBufferLength > 0) {
            try {
                String string = this.fDocument.get(this.fBufferOffset, this.fBufferLength);
                string.getChars(0, this.fBufferLength, this.fBuffer, 0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

