/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.actions;

import com.spket.ui.actions.IDropDownAction;
import com.spket.widget.IPopup;
import com.spket.widget.UIUtils;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class DropDownToolBarItem
extends ContributionItem {
    private IDropDownAction fAction;
    private Image fImage;
    private Image fDisabledImage;
    private Widget fWidget;
    private IPropertyChangeListener fPropertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DropDownToolBarItem.this.actionPropertyChange(propertyChangeEvent);
        }
    };
    private Listener fToolItemListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 12: {
                    DropDownToolBarItem.this.handleWidgetDispose(event);
                    break;
                }
                case 13: {
                    Widget widget = event.widget;
                    if (widget == null) break;
                    DropDownToolBarItem.this.handleWidgetSelection(event, ((ToolItem)widget).getSelection());
                }
            }
        }
    };

    public DropDownToolBarItem(IDropDownAction iDropDownAction) {
        super(iDropDownAction.getId());
        this.fAction = iDropDownAction;
    }

    public void fill(ToolBar toolBar, int n) {
        if (this.fWidget == null && toolBar != null) {
            ToolItem toolItem = null;
            toolItem = n >= 0 ? new ToolItem(toolBar, 4, n) : new ToolItem(toolBar, 4);
            toolItem.setData((Object)this);
            toolItem.addListener(13, this.fToolItemListener);
            toolItem.addListener(12, this.fToolItemListener);
            this.fWidget = toolItem;
            this.update(null);
            this.fAction.addPropertyChangeListener(this.fPropertyListener);
        }
    }

    public void dispose() {
        this.fAction = null;
        this.fWidget = null;
        this.fPropertyListener = null;
        this.fToolItemListener = null;
        if (this.fImage != null) {
            this.fImage.dispose();
            this.fImage = null;
        }
        if (this.fDisabledImage != null) {
            this.fDisabledImage.dispose();
            this.fDisabledImage = null;
        }
        super.dispose();
    }

    public int hashCode() {
        return this.fAction.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DropDownToolBarItem)) {
            return false;
        }
        return this.fAction.equals(((DropDownToolBarItem)((Object)object)).fAction);
    }

    public boolean isEnabled() {
        return this.fAction != null && this.fAction.isEnabled();
    }

    public final void update() {
        this.update(null);
    }

    public void update(String string) {
        if (!(this.fWidget instanceof ToolItem)) {
            return;
        }
        boolean bl = string == null || string.equals("image");
        boolean bl2 = string == null || string.equals("toolTipText");
        boolean bl3 = string == null || string.equals("enabled") || string.equals("enabled");
        ToolItem toolItem = (ToolItem)this.fWidget;
        if (bl) {
            this.updateImages(true);
        }
        if (bl2) {
            toolItem.setToolTipText(this.fAction.getToolTipText());
        }
        if (bl3) {
            boolean bl4;
            boolean bl5 = bl4 = this.fAction.isEnabled() && this.isEnabledAllowed();
            if (toolItem.getEnabled() != bl4) {
                toolItem.setEnabled(bl4);
            }
        }
    }

    protected boolean isEnabledAllowed() {
        if (this.getParent() == null) {
            return true;
        }
        Boolean bl = this.getParent().getOverrides().getEnabled((IContributionItem)this);
        return bl == null ? true : bl;
    }

    private void actionPropertyChange(final PropertyChangeEvent propertyChangeEvent) {
        if (this.isVisible() && this.fWidget != null) {
            Display display = this.fWidget.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                this.update(propertyChangeEvent.getProperty());
            } else {
                display.asyncExec(new Runnable(){

                    public void run() {
                        DropDownToolBarItem.this.update(propertyChangeEvent.getProperty());
                    }
                });
            }
        }
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.fWidget) {
            this.fAction.removePropertyChangeListener(this.fPropertyListener);
            if (this.fImage != null) {
                this.fImage.dispose();
                this.fImage = null;
            }
            if (this.fDisabledImage != null) {
                this.fDisabledImage.dispose();
                this.fDisabledImage = null;
            }
            this.fWidget = null;
        }
    }

    private void handleWidgetSelection(Event event, boolean bl) {
        Widget widget = event.widget;
        if (widget != null) {
            if (event.detail == 4) {
                ToolBarPopup toolBarPopup = new ToolBarPopup((ToolItem)widget);
                UIUtils.popup((IPopup)toolBarPopup, (int)131072);
            } else if (this.fAction.isEnabled()) {
                this.fAction.runWithEvent(event);
            }
        }
    }

    private boolean updateImages(boolean bl) {
        if (this.fWidget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)this.fWidget;
            Image image = this.fImage;
            Image image2 = this.fDisabledImage;
            this.fImage = this.getImage(this.fAction.getImageDescriptor(0));
            this.fDisabledImage = this.getImage(this.fAction.getImageDescriptor(1));
            if (this.fImage == null && bl) {
                this.fImage = this.getImage(ImageDescriptor.getMissingImageDescriptor());
            }
            if (this.fDisabledImage != null) {
                toolItem.setDisabledImage(this.fDisabledImage);
            }
            toolItem.setImage(this.fImage);
            Rectangle rectangle = toolItem.getBounds();
            toolItem.getParent().redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            if (image != null) {
                image.dispose();
            }
            if (image2 != null) {
                image2.dispose();
            }
            return this.fImage != null;
        }
        return false;
    }

    private Image getImage(ImageDescriptor imageDescriptor) {
        return imageDescriptor == null ? null : imageDescriptor.createImage();
    }

    private class ToolBarPopup
    implements IPopup {
        private ToolItem host;

        public ToolBarPopup(ToolItem toolItem) {
            this.host = toolItem;
        }

        public Control createControl(Composite composite, int n) {
            if (composite == null) {
                composite = this.getShell();
            }
            return DropDownToolBarItem.this.fAction.createControl(composite, n);
        }

        public Rectangle getBounds(boolean bl) {
            ToolBar toolBar;
            Rectangle rectangle = this.host.getBounds();
            if (bl && (toolBar = this.host.getParent()) != null) {
                Point point = toolBar.toDisplay(rectangle.x, rectangle.y);
                rectangle.x = point.x;
                rectangle.y = point.y;
            }
            return rectangle;
        }

        public Shell getShell() {
            return this.host.getParent().getShell();
        }
    }
}

