/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;

public class TabConverter
implements IAutoEditStrategy {
    private int fTabRatio;
    private ILineTracker fLineTracker;

    public void setNumberOfSpacesPerTab(int n) {
        this.fTabRatio = n;
    }

    public void setLineTracker(ILineTracker iLineTracker) {
        this.fLineTracker = iLineTracker;
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        String string = documentCommand.text;
        if (string == null) {
            return;
        }
        if (string.length() == 1) {
            if (string.charAt(0) == '\t') {
                try {
                    IRegion iRegion = iDocument.getLineInformationOfOffset(documentCommand.offset);
                    int n = documentCommand.offset - iRegion.getOffset();
                    StringBuffer stringBuffer = new StringBuffer(4);
                    this.insertTabString(stringBuffer, n);
                    documentCommand.text = stringBuffer.toString();
                }
                catch (BadLocationException badLocationException) {}
            }
        } else {
            int n = string.indexOf(9);
            if (n > -1) {
                int n2 = documentCommand.offset;
                this.fLineTracker.set(documentCommand.text);
                int n3 = documentCommand.caretOffset;
                StringBuffer stringBuffer = new StringBuffer();
                int n4 = this.fLineTracker.getNumberOfLines();
                try {
                    for (int i = 0; i < n4; ++i) {
                        int n5 = this.fLineTracker.getLineOffset(i);
                        int n6 = n5 + this.fLineTracker.getLineLength(i);
                        String string2 = string.substring(n5, n6);
                        int n7 = 0;
                        if (i == 0) {
                            IRegion iRegion = iDocument.getLineInformationOfOffset(documentCommand.offset);
                            n7 = documentCommand.offset - iRegion.getOffset();
                        }
                        int n8 = string2.length();
                        for (int j = 0; j < n8; ++j) {
                            char c = string2.charAt(j);
                            if (c == '\t') {
                                int n9 = this.insertTabString(stringBuffer, n7);
                                if (n3 >= n2) {
                                    n3 += n9 - 1;
                                }
                                n2 += n9;
                                n7 += n9;
                                continue;
                            }
                            ++n2;
                            ++n7;
                            stringBuffer.append(c);
                        }
                    }
                    documentCommand.caretOffset = n3;
                    documentCommand.text = stringBuffer.toString();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    private int insertTabString(StringBuffer stringBuffer, int n) {
        if (this.fTabRatio == 0) {
            return 0;
        }
        int n2 = n % this.fTabRatio;
        n2 = this.fTabRatio - n2;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(' ');
        }
        return n2;
    }
}

