/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.palette;

import com.spket.widget.CItem;
import com.spket.widget.CList;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class ImageList
extends CList {
    protected static final int MIN_COLUMNS = 3;
    protected static final int ITEM_SIZE = 16;
    protected static final int SEPARATOR = 1;
    protected static final int SPAN_ALL = 2;
    private String label;

    public ImageList(Composite composite, int n) {
        super(composite, n);
    }

    public void setImages(String[] stringArray, Image[] imageArray) {
        CItem cItem;
        this.fItemCount = 0;
        this.fSelectedIndex = -1;
        this.fItems = EMPTY_ITEM;
        if (this.label != null) {
            cItem = new CItem(this.label);
            cItem.setType(2);
            this.addItem(cItem);
        }
        if (imageArray != null && imageArray.length > 0) {
            if (this.label != null) {
                this.addSeparator();
            }
            for (int i = 0; i < imageArray.length; ++i) {
                cItem = new CItem(stringArray[i]);
                cItem.setData((Object)imageArray[i]);
                this.addItem(cItem);
            }
        }
    }

    public void setDefaultLabel(String string) {
        this.label = string;
    }

    public String getImageName() {
        CItem cItem = this.getSelection();
        if (cItem != null && this.isNormal(cItem)) {
            return cItem.getText();
        }
        return null;
    }

    public void setImageName(String string) {
        int n = -1;
        if (string != null) {
            for (int i = 0; i < this.fItemCount; ++i) {
                CItem cItem = this.fItems[i];
                if (!this.isNormal(cItem) || !string.equals(cItem.getText())) continue;
                n = i;
                break;
            }
        }
        this.setSelection(n, false);
    }

    protected void doLayout() {
        Rectangle rectangle = this.getClientArea();
        int n = 0;
        int n2 = rectangle.x + 3;
        int n3 = 22;
        int n4 = 7;
        CItem cItem = null;
        int n5 = n2;
        int n6 = rectangle.y + 3;
        int n7 = n3;
        int n8 = n3;
        for (int i = 0; i < this.fItemCount; ++i) {
            CItem cItem2 = cItem;
            cItem = this.fItems[i];
            if (!this.isNormal(cItem)) {
                n5 = n2;
                n7 = rectangle.width - 3 - 3;
                if (n != 0) {
                    n6 += this.isSeparator(cItem2) ? n4 : n3;
                }
                n8 = this.isSeparator(cItem) ? n4 : n3;
            }
            Rectangle rectangle2 = cItem.getBounds(false);
            rectangle2.x = n5;
            rectangle2.y = n6;
            rectangle2.width = n7;
            rectangle2.height = n8;
            if (this.isNormal(cItem)) {
                if (++n < this.fColumnCount) {
                    n5 += n7;
                    continue;
                }
                n = 0;
                n5 = n2;
                n6 += n3;
                continue;
            }
            n = 0;
            n5 = n2;
            n6 += this.isSeparator(cItem) ? n4 : n3;
            n7 = n3;
            n8 = n3;
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = new Point(0, 0);
        int n3 = this.fColumnCount;
        if (n3 < 3) {
            n3 = 3;
        }
        int n4 = 22;
        int n5 = 7;
        point.x = n3 * n4;
        int n6 = 0;
        CItem cItem = null;
        CItem cItem2 = null;
        for (int i = 0; i < this.fItemCount; ++i) {
            cItem2 = cItem;
            cItem = this.fItems[i];
            if (!this.isNormal(cItem) && n6 != 0) {
                point.y = point.y + (this.isSeparator(cItem2) ? n5 : n4);
            }
            if (i >= this.fItemCount - 1) continue;
            if (this.isNormal(cItem)) {
                if (++n6 < this.fColumnCount) continue;
                n6 = 0;
                point.y += n4;
                continue;
            }
            n6 = 0;
            point.y = point.y + (this.isSeparator(cItem) ? n5 : n4);
        }
        if (cItem != null) {
            point.y = point.y + (this.isSeparator(cItem) ? n5 : n4);
        }
        point.x += 7;
        point.y += 7;
        return point;
    }

    public void addSeparator() {
        CItem cItem = new CItem();
        cItem.setType(1);
        this.addItem(cItem);
    }

    protected String calcToolTipText(int n) {
        CItem cItem = this.getItem(n);
        if (cItem != null && this.isNormal(cItem)) {
            return cItem.getText();
        }
        return null;
    }

    protected void drawItem(GC gC, int n) {
        CItem cItem = this.getItem(n);
        if (cItem == null) {
            return;
        }
        Rectangle rectangle = cItem.getBounds(false);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (this.isSeparator(cItem)) {
            this.drawSeparator(gC, n2, n3 += n5 / 2, n4, n5);
        } else if (this.isNormal(cItem)) {
            n2 += 3;
            n3 += 3;
            n4 -= 7;
            n5 -= 7;
            Image image = (Image)cItem.getData();
            if (image != null) {
                gC.drawImage(image, n2, n3);
            }
        } else {
            String string = cItem.getText();
            if (string != null) {
                Point point = gC.stringExtent(string);
                gC.drawString(string, n2 += (n4 - point.x) / 2, n3 += (n5 - point.y) / 2, true);
            }
        }
    }

    protected int getMinimumColumns() {
        return 3;
    }

    protected boolean isSeparator(CItem cItem) {
        return (cItem.getType() & 1) != 0;
    }

    protected boolean isNormal(CItem cItem) {
        return (cItem.getType() & 3) == 0;
    }
}

