/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.palette;

import com.spket.ui.palette.ImageList;
import com.spket.widget.CPicker;
import com.spket.widget.UIUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.CPopup;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class ImagePicker
extends CPicker {
    private static final int ARROW_WIDTH = 7;
    private static final int ARROW_HEIGHT = 4;
    private static final int[] PT_ARROW = new int[]{0, 0, 3, 4, 7, 0};
    private int index = -1;
    private String[] names;
    private Image[] images;
    private ImageList list;

    public ImagePicker(Composite composite, int n) {
        super(composite, n);
    }

    public void setImages(String[] stringArray, Image[] imageArray) {
        if (this.images == imageArray) {
            return;
        }
        if (imageArray == null || this.index >= imageArray.length) {
            this.index = -1;
        }
        this.names = stringArray;
        this.images = imageArray;
        this.redraw();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3 = this.getBorderWidth();
        int n4 = this.getItemSize() + 5 + 5;
        int n5 = n3 * 2 + n4 + 10;
        int n6 = n3 * 2 + n4;
        return new Point(n5, n6);
    }

    public int getSelection() {
        return this.index;
    }

    public String getImageName() {
        if (this.index < 0 || this.names == null) {
            return null;
        }
        if (this.index < this.names.length) {
            return this.names[this.index];
        }
        return null;
    }

    public void setImageName(String string) {
        int n = -1;
        if (string != null && this.names != null) {
            for (int i = 0; i < this.names.length; ++i) {
                if (!string.equals(this.names[i])) continue;
                n = i;
                break;
            }
        }
        if (n != this.index) {
            this.index = n;
            this.redraw();
        }
    }

    protected int getItemSize() {
        return 16;
    }

    protected void onPaint(Event event) {
        Color color;
        Color color2;
        GC gC = event.gc;
        Display display = this.getDisplay();
        Rectangle rectangle = this.getClientArea();
        gC.setBackground(this.getBackground());
        gC.fillRectangle(rectangle);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width - 10;
        int n4 = rectangle.height;
        this.paintContent(gC, n, n2, n3, n4);
        this.drawArrow(gC, n + n3 - 3, n2 - 3, 10, n4);
        if ((this.getStatus() & 2) == 0) {
            color2 = display.getSystemColor(20);
            color = display.getSystemColor(17);
        } else {
            color2 = display.getSystemColor(17);
            color = display.getSystemColor(20);
        }
        UIUtils.drawBorder((GC)gC, (int)rectangle.x, (int)rectangle.y, (int)(rectangle.width - 1), (int)(rectangle.height - 1), (Color)color2, (Color)color);
    }

    protected CPopup createPopup(Composite composite, int n) {
        this.list = new ImageList(composite, n | 0x800000);
        if (this.images != null) {
            this.list.setShowToolTip(true);
            this.list.ensureCapacity(this.images.length + 2);
            int n2 = (int)Math.sqrt(this.images.length) + 1;
            if (n2 < 4) {
                n2 = 4;
            }
            if (n2 > 16) {
                n2 = 16;
            }
            this.list.setColumnCount(n2);
            this.list.setDefaultLabel("no icons");
            this.list.setImages(this.names, this.images);
            String string = this.getImageName();
            if (string != null) {
                this.list.setImageName(string);
            }
        }
        return this.list;
    }

    protected void onSelectionChanged() {
        if (this.list != null) {
            String string = this.list.getImageName();
            if (!this.list.isDisposed()) {
                this.list.dispose();
            }
            this.list = null;
            String string2 = this.getImageName();
            if (string != string2) {
                this.setImageName(string);
                Event event = new Event();
                event.text = string;
                this.notifyListeners(24, event);
            }
        }
    }

    protected void paintContent(GC gC, int n, int n2, int n3, int n4) {
        if (this.images != null && this.index >= 0 && this.index < this.images.length) {
            Image image = this.images[this.index];
            gC.drawImage(image, n + 5, n2 + 5);
        }
    }

    protected void drawArrow(GC gC, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n + (n3 - 7) / 2;
        int n7 = n2 + n4 - 8;
        int[] nArray = new int[PT_ARROW.length];
        for (n5 = 0; n5 < PT_ARROW.length; ++n5) {
            nArray[n5] = PT_ARROW[n5] + n6;
            nArray[++n5] = PT_ARROW[n5] + n7;
        }
        n5 = this.getStatus();
        if ((n5 & 1) == 0) {
            gC.setBackground(this.getDisplay().getSystemColor(17));
        } else {
            gC.setBackground(this.getDisplay().getSystemColor(2));
        }
        gC.fillPolygon(nArray);
    }
}

